/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.matcher;

import io.opentelemetry.javaagent.extension.matcher.Utils;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeErasureMatcher<T extends TypeDefinition>
extends ElementMatcher.Junction.AbstractBase<T> {
    private static final Logger logger = LoggerFactory.getLogger(SafeErasureMatcher.class);
    private final ElementMatcher<TypeDescription> matcher;

    public SafeErasureMatcher(ElementMatcher<TypeDescription> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(T target) {
        TypeDescription erasure = SafeErasureMatcher.safeAsErasure(target);
        if (erasure == null) {
            return false;
        }
        return this.matcher.matches((Object)erasure);
    }

    static TypeDescription safeAsErasure(TypeDefinition typeDefinition) {
        try {
            return typeDefinition.asErasure();
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} trying to get erasure for target {}: {}", new Object[]{e.getClass().getSimpleName(), Utils.safeTypeDefinitionName(typeDefinition), e.getMessage()});
            }
            return null;
        }
    }

    public String toString() {
        return "safeErasure(" + this.matcher + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeErasureMatcher)) {
            return false;
        }
        SafeErasureMatcher other = (SafeErasureMatcher)((Object)obj);
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }
}

