/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.muzzle;

import io.opentelemetry.javaagent.extension.muzzle.FieldRef;
import io.opentelemetry.javaagent.extension.muzzle.Flag;
import io.opentelemetry.javaagent.extension.muzzle.MethodRef;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

final class ReferenceMergeUtil {
    static <T> Set<T> mergeSet(Set<T> set1, Set<T> set2) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    static Set<MethodRef> mergeMethods(Set<MethodRef> methods1, Set<MethodRef> methods2) {
        ArrayList<MethodRef> merged = new ArrayList<MethodRef>(methods1);
        for (MethodRef method : methods2) {
            int i = merged.indexOf(method);
            if (i == -1) {
                merged.add(method);
                continue;
            }
            merged.set(i, ((MethodRef)merged.get(i)).merge(method));
        }
        return new LinkedHashSet<MethodRef>(merged);
    }

    static Set<FieldRef> mergeFields(Set<FieldRef> fields1, Set<FieldRef> fields2) {
        ArrayList<FieldRef> merged = new ArrayList<FieldRef>(fields1);
        for (FieldRef field : fields2) {
            int i = merged.indexOf(field);
            if (i == -1) {
                merged.add(field);
                continue;
            }
            merged.set(i, ((FieldRef)merged.get(i)).merge(field));
        }
        return new LinkedHashSet<FieldRef>(merged);
    }

    static Set<Flag> mergeFlags(Set<Flag> flags1, Set<Flag> flags2) {
        Set<Flag> merged = ReferenceMergeUtil.mergeSet(flags1, flags2);
        return merged;
    }

    private ReferenceMergeUtil() {
    }
}

