/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.muzzle;

import io.opentelemetry.javaagent.extension.muzzle.ClassRefBuilder;
import io.opentelemetry.javaagent.extension.muzzle.FieldRef;
import io.opentelemetry.javaagent.extension.muzzle.Flag;
import io.opentelemetry.javaagent.extension.muzzle.MethodRef;
import io.opentelemetry.javaagent.extension.muzzle.ReferenceMergeUtil;
import io.opentelemetry.javaagent.extension.muzzle.Source;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ClassRef {
    private final Set<Source> sources;
    private final Set<Flag> flags;
    private final String className;
    private final String superClassName;
    private final Set<String> interfaceNames;
    private final Set<FieldRef> fields;
    private final Set<MethodRef> methods;

    ClassRef(Set<Source> sources, Set<Flag> flags, String className, String superClassName, Set<String> interfaceNames, Set<FieldRef> fields, Set<MethodRef> methods) {
        this.sources = sources;
        this.flags = flags;
        this.className = className;
        this.superClassName = superClassName;
        this.interfaceNames = interfaceNames;
        this.fields = fields;
        this.methods = methods;
    }

    public static ClassRefBuilder newBuilder(String className) {
        return new ClassRefBuilder(className);
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public String getClassName() {
        return this.className;
    }

    public @Nullable String getSuperClassName() {
        return this.superClassName;
    }

    public Set<String> getInterfaceNames() {
        return this.interfaceNames;
    }

    public Set<FieldRef> getFields() {
        return this.fields;
    }

    public Set<MethodRef> getMethods() {
        return this.methods;
    }

    public ClassRef merge(ClassRef anotherReference) {
        if (!anotherReference.getClassName().equals(this.className)) {
            throw new IllegalStateException("illegal merge " + this + " != " + anotherReference);
        }
        String superName = null == this.superClassName ? anotherReference.superClassName : this.superClassName;
        return new ClassRef(ReferenceMergeUtil.mergeSet(this.sources, anotherReference.sources), ReferenceMergeUtil.mergeFlags(this.flags, anotherReference.flags), this.className, superName, ReferenceMergeUtil.mergeSet(this.interfaceNames, anotherReference.interfaceNames), ReferenceMergeUtil.mergeFields(this.fields, anotherReference.fields), ReferenceMergeUtil.mergeMethods(this.methods, anotherReference.methods));
    }

    public String toString() {
        String extendsPart = this.superClassName == null ? "" : " extends " + this.superClassName;
        String implementsPart = this.interfaceNames.isEmpty() ? "" : " implements " + String.join((CharSequence)", ", this.interfaceNames);
        return this.getClass().getSimpleName() + ": " + this.className + extendsPart + implementsPart;
    }
}

