/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.matcher;

import io.opentelemetry.instrumentation.api.cache.Cache;
import io.opentelemetry.javaagent.instrumentation.api.internal.ClassLoaderMatcherCacheHolder;
import io.opentelemetry.javaagent.instrumentation.api.internal.InClassLoaderMatcher;
import net.bytebuddy.matcher.ElementMatcher;

class ClassLoaderHasClassesNamedMatcher
extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
    private final Cache<ClassLoader, Boolean> cache = Cache.weak();
    private final String[] resources;

    ClassLoaderHasClassesNamedMatcher(String ... classNames) {
        this.resources = classNames;
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i] = this.resources[i].replace(".", "/") + ".class";
        }
        ClassLoaderMatcherCacheHolder.addCache(this.cache);
    }

    public boolean matches(ClassLoader cl) {
        if (cl == null) {
            return false;
        }
        return (Boolean)this.cache.computeIfAbsent((Object)cl, this::hasResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResources(ClassLoader cl) {
        boolean priorValue = InClassLoaderMatcher.getAndSet((boolean)true);
        try {
            for (String resource : this.resources) {
                if (cl.getResource(resource) != null) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            InClassLoaderMatcher.set((boolean)priorValue);
        }
        return true;
    }
}

