/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.instrumentation;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.extension.Ordered;
import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class InstrumentationModule
implements Ordered {
    private static final boolean DEFAULT_ENABLED = Config.get().getBoolean("otel.instrumentation.common.default-enabled", true);
    private final Set<String> instrumentationNames;

    protected InstrumentationModule(String mainInstrumentationName, String ... additionalInstrumentationNames) {
        this(InstrumentationModule.toList(mainInstrumentationName, additionalInstrumentationNames));
    }

    protected InstrumentationModule(List<String> instrumentationNames) {
        if (instrumentationNames.isEmpty()) {
            throw new IllegalArgumentException("InstrumentationModules must be named");
        }
        this.instrumentationNames = new LinkedHashSet<String>(instrumentationNames);
    }

    private static List<String> toList(String first, String[] rest) {
        ArrayList<String> instrumentationNames = new ArrayList<String>(rest.length + 1);
        instrumentationNames.add(first);
        instrumentationNames.addAll(Arrays.asList(rest));
        return instrumentationNames;
    }

    public final String instrumentationName() {
        return this.instrumentationNames.iterator().next();
    }

    public final boolean isEnabled() {
        return Config.get().isInstrumentationEnabled(this.instrumentationNames, this.defaultEnabled());
    }

    protected boolean defaultEnabled() {
        return DEFAULT_ENABLED;
    }

    public boolean isHelperClass(String className) {
        return false;
    }

    public void registerHelperResources(HelperResourceBuilder helperResourceBuilder) {
    }

    public ElementMatcher.Junction<ClassLoader> classLoaderMatcher() {
        return ElementMatchers.any();
    }

    public abstract List<TypeInstrumentation> typeInstrumentations();

    public List<String> getAdditionalHelperClassNames() {
        return Collections.emptyList();
    }
}

