/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.methods;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.instrumentation.methods.MethodInstrumentation;
import io.opentelemetry.javaagent.tooling.config.MethodsConfigurationParser;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappingsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@AutoService(value={InstrumentationModule.class})
public class MethodInstrumentationModule
extends InstrumentationModule
implements InstrumentationModuleMuzzle {
    private static final String TRACE_METHODS_CONFIG = "otel.instrumentation.methods.include";
    private final List<TypeInstrumentation> typeInstrumentations;

    public MethodInstrumentationModule() {
        super("methods", new String[0]);
        Map classMethodsToTrace = MethodsConfigurationParser.parse((String)InstrumentationConfig.get().getString(TRACE_METHODS_CONFIG));
        this.typeInstrumentations = classMethodsToTrace.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).map(e -> new MethodInstrumentation((String)e.getKey(), (Set)e.getValue())).collect(Collectors.toList());
    }

    public List<String> getAdditionalHelperClassNames() {
        return this.typeInstrumentations.isEmpty() ? Collections.emptyList() : Collections.singletonList("io.opentelemetry.javaagent.instrumentation.methods.MethodSingletons");
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        return this.typeInstrumentations;
    }

    public Map getMuzzleReferences() {
        HashMap hashMap = new HashMap(1, 0.75f);
        return hashMap;
    }

    public List getMuzzleHelperClassNames() {
        ArrayList arrayList = new ArrayList(0);
        return arrayList;
    }

    public void registerMuzzleVirtualFields(VirtualFieldMappingsBuilder virtualFieldMappingsBuilder) {
    }
}

