/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.methods;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndSupport;
import io.opentelemetry.instrumentation.api.instrumenter.util.ClassAndMethod;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.methods.MethodSingletons;
import java.lang.reflect.Method;
import java.util.Set;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodInstrumentation
implements TypeInstrumentation {
    private final String className;
    private final Set<String> methodNames;

    public MethodInstrumentation(String className, Set<String> methodNames) {
        this.className = className;
        this.methodNames = methodNames;
    }

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{this.className});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)this.className));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.namedOneOf((String[])this.methodNames.toArray(new String[0])), MethodInstrumentation.class.getName() + "$MethodAdvice");
    }

    public static class MethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Origin(value="#t") Class<?> declaringClass, @Advice.Origin(value="#m") String methodName, @Advice.Local(value="otelMethod") ClassAndMethod classAndMethod, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            classAndMethod = ClassAndMethod.create(declaringClass, (String)methodName);
            if (!MethodSingletons.instrumenter().shouldStart(parentContext, (Object)classAndMethod)) {
                return;
            }
            context = MethodSingletons.instrumenter().start(parentContext, (Object)classAndMethod);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Origin Method method, @Advice.Local(value="otelMethod") ClassAndMethod classAndMethod, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope, @Advice.Return(typing=Assigner.Typing.DYNAMIC, readOnly=false) Object returnValue, @Advice.Thrown Throwable throwable) {
            scope.close();
            returnValue = AsyncOperationEndSupport.create(MethodSingletons.instrumenter(), Void.class, method.getReturnType()).asyncEnd(context, (Object)classAndMethod, returnValue, throwable);
        }
    }
}

