/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0.ApacheHttpClientHelper;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0.ApacheHttpClientSingletons;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0.RequestWithHost;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0.WrappingStatusSettingResponseHandler;
import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class ApacheHttpClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.apache.hc.client5.http.classic.HttpClient"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"org.apache.hc.client5.http.classic.HttpClient"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))), this.getClass().getName() + "$RequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.protocol.HttpContext"))), this.getClass().getName() + "$RequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))), this.getClass().getName() + "$RequestWithHostAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.protocol.HttpContext"))), this.getClass().getName() + "$RequestWithHostAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.io.HttpClientResponseHandler"))), this.getClass().getName() + "$RequestWithHandlerAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.protocol.HttpContext"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.io.HttpClientResponseHandler"))), this.getClass().getName() + "$RequestWithContextAndHandlerAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.io.HttpClientResponseHandler"))), this.getClass().getName() + "$RequestWithHostAndHandlerAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)4)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.ClassicHttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.protocol.HttpContext"))).and((ElementMatcher)ElementMatchers.takesArgument((int)3, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.io.HttpClientResponseHandler"))), this.getClass().getName() + "$RequestWithHostAndContextAndHandlerAdvice");
    }

    public static class RequestWithHostAndContextAndHandlerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpHost host, @Advice.Argument(value=1) ClassicHttpRequest request, @Advice.Argument(value=3, readOnly=false) HttpClientResponseHandler<?> handler, @Advice.Local(value="otelFullRequest") ClassicHttpRequest fullRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            fullRequest = new RequestWithHost(host, request);
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)fullRequest)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)fullRequest);
            scope = context.makeCurrent();
            if (handler != null) {
                handler = new WrappingStatusSettingResponseHandler(context, parentContext, fullRequest, handler);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelFullRequest") ClassicHttpRequest fullRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, fullRequest, result, throwable);
        }
    }

    public static class RequestWithHostAndHandlerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpHost host, @Advice.Argument(value=1) ClassicHttpRequest request, @Advice.Argument(value=2, readOnly=false) HttpClientResponseHandler<?> handler, @Advice.Local(value="otelFullRequest") ClassicHttpRequest fullRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            fullRequest = new RequestWithHost(host, request);
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)fullRequest)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)fullRequest);
            scope = context.makeCurrent();
            if (handler != null) {
                handler = new WrappingStatusSettingResponseHandler(context, parentContext, fullRequest, handler);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelFullRequest") ClassicHttpRequest fullRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, fullRequest, result, throwable);
        }
    }

    public static class RequestWithHostAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpHost host, @Advice.Argument(value=1) ClassicHttpRequest request, @Advice.Local(value="otelFullRequest") ClassicHttpRequest fullRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            fullRequest = new RequestWithHost(host, request);
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)fullRequest)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)fullRequest);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelFullRequest") ClassicHttpRequest fullRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, fullRequest, result, throwable);
        }
    }

    public static class RequestWithContextAndHandlerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) ClassicHttpRequest request, @Advice.Argument(value=2, readOnly=false) HttpClientResponseHandler<?> handler, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
            if (handler != null) {
                handler = new WrappingStatusSettingResponseHandler(context, parentContext, request, handler);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) ClassicHttpRequest request, @Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, request, result, throwable);
        }
    }

    public static class RequestWithHandlerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) ClassicHttpRequest request, @Advice.Argument(value=1, readOnly=false) HttpClientResponseHandler<?> handler, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
            if (handler != null) {
                handler = new WrappingStatusSettingResponseHandler(context, parentContext, request, handler);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) ClassicHttpRequest request, @Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, request, result, throwable);
        }
    }

    public static class RequestAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) ClassicHttpRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) ClassicHttpRequest request, @Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, request, result, throwable);
        }
    }
}

