/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.net.URIAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApacheHttpClientHttpAttributesExtractor
extends HttpClientAttributesExtractor<ClassicHttpRequest, HttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClientHttpAttributesExtractor.class);

    ApacheHttpClientHttpAttributesExtractor() {
    }

    protected String method(ClassicHttpRequest request) {
        return request.getMethod();
    }

    protected String url(ClassicHttpRequest request) {
        String path;
        StringBuilder url = new StringBuilder();
        URIAuthority authority = request.getAuthority();
        if (authority != null) {
            String scheme = request.getScheme();
            if (scheme != null) {
                url.append(scheme);
                url.append("://");
            } else {
                url.append("http://");
            }
            url.append(authority.getHostName());
            int port = authority.getPort();
            if (port >= 0) {
                url.append(":");
                url.append(port);
            }
        }
        if ((path = request.getPath()) != null) {
            if (url.length() > 0 && !path.startsWith("/")) {
                url.append("/");
            }
            url.append(path);
        } else {
            url.append("/");
        }
        return url.toString();
    }

    protected List<String> requestHeader(ClassicHttpRequest request, String name) {
        return ApacheHttpClientHttpAttributesExtractor.headersToList(request.getHeaders(name));
    }

    @Nullable
    protected Long requestContentLength(ClassicHttpRequest request, @Nullable HttpResponse response) {
        return null;
    }

    @Nullable
    protected Long requestContentLengthUncompressed(ClassicHttpRequest request, @Nullable HttpResponse response) {
        return null;
    }

    protected Integer statusCode(ClassicHttpRequest request, HttpResponse response) {
        return response.getCode();
    }

    @Nullable
    protected String flavor(ClassicHttpRequest request, @Nullable HttpResponse response) {
        ProtocolVersion protocolVersion = request.getVersion();
        if (protocolVersion == null) {
            return "1.1";
        }
        String protocol = protocolVersion.getProtocol();
        if (!protocol.equals("HTTP")) {
            return null;
        }
        int major = protocolVersion.getMajor();
        int minor = protocolVersion.getMinor();
        if (major == 1 && minor == 0) {
            return "1.0";
        }
        if (major == 1 && minor == 1) {
            return "1.1";
        }
        if (major == 2 && minor == 0) {
            return "2.0";
        }
        logger.debug("unexpected http protocol version: " + protocolVersion);
        return null;
    }

    @Nullable
    protected Long responseContentLength(ClassicHttpRequest request, HttpResponse response) {
        return null;
    }

    @Nullable
    protected Long responseContentLengthUncompressed(ClassicHttpRequest request, HttpResponse response) {
        return null;
    }

    protected List<String> responseHeader(ClassicHttpRequest request, HttpResponse response, String name) {
        return ApacheHttpClientHttpAttributesExtractor.headersToList(response.getHeaders(name));
    }

    private static List<String> headersToList(Header[] headers) {
        if (headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> headersList = new ArrayList<String>(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            headersList.add(headers[i].getValue());
        }
        return headersList;
    }
}

