/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpAttributesExtractor;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.net.URIAuthority;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApacheHttpClientHttpAttributesExtractor
extends HttpAttributesExtractor<ClassicHttpRequest, HttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClientHttpAttributesExtractor.class);

    ApacheHttpClientHttpAttributesExtractor() {
    }

    protected String method(ClassicHttpRequest request) {
        return request.getMethod();
    }

    protected String url(ClassicHttpRequest request) {
        String path;
        StringBuilder url = new StringBuilder();
        URIAuthority authority = request.getAuthority();
        if (authority != null) {
            String scheme = request.getScheme();
            if (scheme != null) {
                url.append(scheme);
                url.append("://");
            } else {
                url.append("http://");
            }
            url.append(authority.getHostName());
            int port = authority.getPort();
            if (port >= 0) {
                url.append(":");
                url.append(port);
            }
        }
        if ((path = request.getPath()) != null) {
            if (url.length() > 0 && !path.startsWith("/")) {
                url.append("/");
            }
            url.append(path);
        } else {
            url.append("/");
        }
        return url.toString();
    }

    protected String target(ClassicHttpRequest request) {
        return request.getRequestUri();
    }

    protected @Nullable String host(ClassicHttpRequest request) {
        Header header = request.getFirstHeader("Host");
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    protected String scheme(ClassicHttpRequest request) {
        String scheme = request.getScheme();
        return scheme != null ? scheme : "http";
    }

    protected @Nullable String userAgent(ClassicHttpRequest request) {
        Header header = request.getFirstHeader("User-Agent");
        return header != null ? header.getValue() : null;
    }

    protected @Nullable Long requestContentLength(ClassicHttpRequest request, @Nullable HttpResponse response) {
        return null;
    }

    protected @Nullable Long requestContentLengthUncompressed(ClassicHttpRequest request, @Nullable HttpResponse response) {
        return null;
    }

    protected Integer statusCode(ClassicHttpRequest request, HttpResponse response) {
        return response.getCode();
    }

    protected @Nullable String flavor(ClassicHttpRequest request, @Nullable HttpResponse response) {
        ProtocolVersion protocolVersion = request.getVersion();
        if (protocolVersion == null) {
            return "1.1";
        }
        String protocol = protocolVersion.getProtocol();
        if (!protocol.equals("HTTP")) {
            return null;
        }
        int major = protocolVersion.getMajor();
        int minor = protocolVersion.getMinor();
        if (major == 1 && minor == 0) {
            return "1.0";
        }
        if (major == 1 && minor == 1) {
            return "1.1";
        }
        if (major == 2 && minor == 0) {
            return "2.0";
        }
        logger.debug("unexpected http protocol version: " + protocolVersion);
        return null;
    }

    protected @Nullable Long responseContentLength(ClassicHttpRequest request, HttpResponse response) {
        return null;
    }

    protected @Nullable Long responseContentLengthUncompressed(ClassicHttpRequest request, HttpResponse response) {
        return null;
    }

    protected @Nullable String serverName(ClassicHttpRequest request, @Nullable HttpResponse response) {
        return null;
    }

    protected @Nullable String route(ClassicHttpRequest request) {
        return null;
    }
}

