/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0.ApacheHttpClientHelper;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0.ApacheHttpClientRequest;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0.ApacheHttpClientSingletons;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0.WrappingStatusSettingResponseHandler;
import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;

public class ApacheHttpClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.apache.http.client.HttpClient"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.HttpClient"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.methods.HttpUriRequest"))), this.getClass().getName() + "$UriRequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.methods.HttpUriRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.protocol.HttpContext"))), this.getClass().getName() + "$UriRequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.methods.HttpUriRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.ResponseHandler"))), this.getClass().getName() + "$UriRequestWithHandlerAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.methods.HttpUriRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.ResponseHandler"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.protocol.HttpContext"))), this.getClass().getName() + "$UriRequestWithHandlerAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpRequest"))), this.getClass().getName() + "$RequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.protocol.HttpContext"))), this.getClass().getName() + "$RequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.ResponseHandler"))), this.getClass().getName() + "$RequestWithHandlerAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.takesArguments((int)4)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpHost"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.ResponseHandler"))).and((ElementMatcher)ElementMatchers.takesArgument((int)3, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.protocol.HttpContext"))), this.getClass().getName() + "$RequestWithHandlerAdvice");
    }

    public static class RequestWithHandlerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpHost host, @Advice.Argument(value=1) HttpRequest request, @Advice.Argument(value=2, readOnly=false) ResponseHandler<?> handler, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)otelRequest)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)otelRequest);
            scope = context.makeCurrent();
            if (handler != null) {
                handler = new WrappingStatusSettingResponseHandler(context, parentContext, otelRequest, handler);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, otelRequest, result, throwable);
        }
    }

    public static class RequestAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpHost host, @Advice.Argument(value=1) HttpRequest request, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            otelRequest = new ApacheHttpClientRequest(host, request);
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)otelRequest)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)otelRequest);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, otelRequest, result, throwable);
        }
    }

    public static class UriRequestWithHandlerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpUriRequest request, @Advice.Argument(value=1, readOnly=false) ResponseHandler<?> handler, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            otelRequest = new ApacheHttpClientRequest(request);
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)otelRequest)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)otelRequest);
            scope = context.makeCurrent();
            if (handler != null) {
                handler = new WrappingStatusSettingResponseHandler(context, parentContext, otelRequest, handler);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) HttpUriRequest request, @Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, otelRequest, result, throwable);
        }
    }

    public static class UriRequestAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpUriRequest request, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            otelRequest = new ApacheHttpClientRequest(request);
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)otelRequest)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)otelRequest);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) HttpUriRequest request, @Advice.Return Object result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelRequest") ApacheHttpClientRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientHelper.doMethodExit(context, otelRequest, result, throwable);
        }
    }
}

