/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;

public class HostAndRequestAsHttpUriRequest
extends AbstractHttpMessage
implements HttpUriRequest {
    private final String method;
    private final RequestLine requestLine;
    private final ProtocolVersion protocolVersion;
    private final URI uri;
    private final HttpRequest actualRequest;

    public HostAndRequestAsHttpUriRequest(HttpHost httpHost, HttpRequest httpRequest) {
        URI calculatedUri;
        this.method = httpRequest.getRequestLine().getMethod();
        this.requestLine = httpRequest.getRequestLine();
        this.protocolVersion = this.requestLine.getProtocolVersion();
        try {
            calculatedUri = new URI(httpHost.toURI() + httpRequest.getRequestLine().getUri());
        }
        catch (URISyntaxException e) {
            calculatedUri = null;
        }
        this.uri = calculatedUri;
        this.actualRequest = httpRequest;
    }

    public void abort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isAborted() {
        return false;
    }

    public void addHeader(String name, String value) {
        this.actualRequest.addHeader(name, value);
    }

    public String getMethod() {
        return this.method;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpRequest getActualRequest() {
        return this.actualRequest;
    }
}

