/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.tracer.HttpClientTracer;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0.HostAndRequestAsHttpUriRequest;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v4_0.HttpHeadersInjectAdapter;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApacheHttpClientTracer
extends HttpClientTracer<HttpUriRequest, HttpUriRequest, HttpResponse> {
    private static final ApacheHttpClientTracer TRACER = new ApacheHttpClientTracer();

    public static ApacheHttpClientTracer tracer() {
        return TRACER;
    }

    public Context startSpan(Context parentContext, HttpHost host, HttpRequest request) {
        Object httpUriRequest = request instanceof HttpUriRequest ? (HttpUriRequest)request : new HostAndRequestAsHttpUriRequest(host, request);
        return this.startSpan(parentContext, (HttpUriRequest)httpUriRequest);
    }

    public Context startSpan(Context parentContext, HttpUriRequest request) {
        return this.startSpan(parentContext, request, request);
    }

    protected String method(HttpUriRequest httpRequest) {
        return httpRequest.getMethod();
    }

    protected @Nullable String flavor(HttpUriRequest httpUriRequest) {
        return httpUriRequest.getProtocolVersion().toString();
    }

    protected URI url(HttpUriRequest request) {
        return request.getURI();
    }

    protected Integer status(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected String requestHeader(HttpUriRequest request, String name) {
        return ApacheHttpClientTracer.header((HttpMessage)request, name);
    }

    protected String responseHeader(HttpResponse response, String name) {
        return ApacheHttpClientTracer.header((HttpMessage)response, name);
    }

    protected TextMapPropagator.Setter<HttpUriRequest> getSetter() {
        return HttpHeadersInjectAdapter.SETTER;
    }

    private static String header(HttpMessage message, String name) {
        Header header = message.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.apache-httpclient";
    }
}

