/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.ApacheHttpClientSingletons;
import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.httpclient.HttpMethod;

public class ApacheHttpClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.apache.commons.httpclient.HttpClient"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"org.apache.commons.httpclient.HttpClient"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"executeMethod")).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.commons.httpclient.HttpMethod"))), this.getClass().getName() + "$ExecuteMethodAdvice");
    }

    public static class ExecuteMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=1) HttpMethod httpMethod, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!ApacheHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)httpMethod)) {
                return;
            }
            context = ApacheHttpClientSingletons.instrumenter().start(parentContext, (Object)httpMethod);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=1) HttpMethod httpMethod, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            ApacheHttpClientSingletons.instrumenter().end(context, (Object)httpMethod, (Object)httpMethod, throwable);
        }
    }
}

