/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpAttributesExtractor;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.StatusLine;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ApacheHttpClientHttpAttributesExtractor
extends HttpAttributesExtractor<HttpMethod, HttpMethod> {
    ApacheHttpClientHttpAttributesExtractor() {
    }

    protected String method(HttpMethod request) {
        return request.getName();
    }

    protected String url(HttpMethod request) {
        return ApacheHttpClientHttpAttributesExtractor.getUrl(request);
    }

    protected String target(HttpMethod request) {
        String queryString = request.getQueryString();
        return queryString != null ? request.getPath() + "?" + queryString : request.getPath();
    }

    protected @Nullable String host(HttpMethod request) {
        Header header = request.getRequestHeader("Host");
        if (header != null) {
            return header.getValue();
        }
        HostConfiguration hostConfiguration = request.getHostConfiguration();
        if (hostConfiguration != null) {
            return hostConfiguration.getVirtualHost();
        }
        return null;
    }

    protected @Nullable String scheme(HttpMethod request) {
        HostConfiguration hostConfiguration = request.getHostConfiguration();
        return hostConfiguration != null ? hostConfiguration.getProtocol().getScheme() : null;
    }

    protected @Nullable String userAgent(HttpMethod request) {
        Header header = request.getRequestHeader("User-Agent");
        return header != null ? header.getValue() : null;
    }

    protected @Nullable Long requestContentLength(HttpMethod request, @Nullable HttpMethod response) {
        return null;
    }

    protected @Nullable Long requestContentLengthUncompressed(HttpMethod request, @Nullable HttpMethod response) {
        return null;
    }

    protected @Nullable Integer statusCode(HttpMethod request, HttpMethod response) {
        StatusLine statusLine = response.getStatusLine();
        return statusLine == null ? null : Integer.valueOf(statusLine.getStatusCode());
    }

    protected @Nullable String flavor(HttpMethod request, @Nullable HttpMethod response) {
        if (request instanceof HttpMethodBase) {
            return ((HttpMethodBase)request).isHttp11() ? "1.1" : "1.0";
        }
        return null;
    }

    protected @Nullable Long responseContentLength(HttpMethod request, HttpMethod response) {
        return null;
    }

    protected @Nullable Long responseContentLengthUncompressed(HttpMethod request, HttpMethod response) {
        return null;
    }

    protected @Nullable String serverName(HttpMethod request, @Nullable HttpMethod response) {
        return null;
    }

    protected @Nullable String route(HttpMethod request) {
        return null;
    }

    private static String getUrl(HttpMethod request) {
        HostConfiguration hostConfiguration = request.getHostConfiguration();
        if (hostConfiguration == null) {
            String queryString = request.getQueryString();
            if (queryString == null) {
                return request.getPath();
            }
            return request.getPath() + "?" + request.getQueryString();
        }
        StringBuilder url = new StringBuilder();
        url.append(hostConfiguration.getProtocol().getScheme());
        url.append("://");
        url.append(hostConfiguration.getHost());
        int port = hostConfiguration.getPort();
        if (port != hostConfiguration.getProtocol().getDefaultPort()) {
            url.append(":");
            url.append(port);
        }
        url.append(request.getPath());
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append("?");
            url.append(request.getQueryString());
        }
        return url.toString();
    }
}

