/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0;

import com.google.auto.service.AutoService;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.extension.matcher.ClassLoaderMatcher;
import io.opentelemetry.javaagent.extension.muzzle.Reference;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer;
import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.httpclient.HttpMethod;

@AutoService(value={InstrumentationModule.class})
public class ApacheHttpClientInstrumentationModule
extends InstrumentationModule {
    private volatile Reference[] muzzleReferences = null;

    public ApacheHttpClientInstrumentationModule() {
        super("apache-httpclient", new String[]{"apache-httpclient-2.0"});
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        return Collections.singletonList(new HttpClientInstrumentation());
    }

    public synchronized Reference[] getMuzzleReferences() {
        if (null == this.muzzleReferences) {
            this.muzzleReferences = new Reference[]{new Reference.Builder("org.apache.commons.httpclient.HttpMethod").withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.ApacheHttpClientInstrumentationModule$ExecAdvice", 77).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 41).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 48).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 56).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 62).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 68).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 19).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.HttpHeadersInjectAdapter", 18).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.HttpHeadersInjectAdapter", 12).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 41)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getName", Type.getType((String)"Ljava/lang/String;"), new Type[0]).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 48)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getURI", Type.getType((String)"Lorg/apache/commons/httpclient/URI;"), new Type[0]).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 56)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getStatusLine", Type.getType((String)"Lorg/apache/commons/httpclient/StatusLine;"), new Type[0]).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 62)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRequestHeader", Type.getType((String)"Lorg/apache/commons/httpclient/Header;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 68)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getResponseHeader", Type.getType((String)"Lorg/apache/commons/httpclient/Header;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.HttpHeadersInjectAdapter", 18)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setRequestHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Lorg/apache/commons/httpclient/Header;")}).build(), new Reference.Builder("org.apache.commons.httpclient.URI").withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 48).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 48)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "toString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build(), new Reference.Builder("org.apache.commons.httpclient.URIException").withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 50).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_INTERFACE).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 50)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMessage", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build(), new Reference.Builder("org.apache.commons.httpclient.StatusLine").withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 56).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 57).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 57)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getStatusCode", Type.getType((String)"I"), new Type[0]).build(), new Reference.Builder("org.apache.commons.httpclient.Header").withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 62).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 63).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 68).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 69).withSource("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.HttpHeadersInjectAdapter", 18).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 63), new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", 69)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getValue", Type.getType((String)"Ljava/lang/String;"), new Type[0]).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.HttpHeadersInjectAdapter", 18)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "<init>", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).build()};
        }
        return this.muzzleReferences;
    }

    public String[] getMuzzleHelperClassNames() {
        return new String[]{"io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.CommonsHttpClientTracer", "io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0.HttpHeadersInjectAdapter"};
    }

    public Map getMuzzleContextStoreClasses() {
        HashMap hashMap = new HashMap(0);
        return hashMap;
    }

    public static class ExecAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=1) HttpMethod httpMethod, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!CommonsHttpClientTracer.tracer().shouldStartSpan(parentContext)) {
                return;
            }
            context = CommonsHttpClientTracer.tracer().startSpan(parentContext, httpMethod);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=1) HttpMethod httpMethod, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            CommonsHttpClientTracer.tracer().endMaybeExceptionally(context, httpMethod, throwable);
        }
    }

    public static class HttpClientInstrumentation
    implements TypeInstrumentation {
        public ElementMatcher<ClassLoader> classLoaderOptimization() {
            return ClassLoaderMatcher.hasClassesNamed((String[])new String[]{"org.apache.commons.httpclient.HttpClient"});
        }

        public ElementMatcher<TypeDescription> typeMatcher() {
            return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"org.apache.commons.httpclient.HttpClient"));
        }

        public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
            return Collections.singletonMap(ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"executeMethod")).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.commons.httpclient.HttpMethod"))), ApacheHttpClientInstrumentationModule.class.getName() + "$ExecAdvice");
        }
    }
}

