/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.idsync;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;
import io.objectbox.generator.IdUid;
import io.objectbox.generator.idsync.Entity;
import io.objectbox.generator.idsync.HasIdUid;
import io.objectbox.generator.idsync.IdSyncException;
import io.objectbox.generator.idsync.IdSyncModel;
import io.objectbox.generator.idsync.IdSyncModelJsonAdapter;
import io.objectbox.generator.idsync.IdSyncPrintUidException;
import io.objectbox.generator.idsync.Property;
import io.objectbox.generator.idsync.Relation;
import io.objectbox.generator.idsync.UidHelper;
import io.objectbox.generator.model.Index;
import io.objectbox.generator.model.Schema;
import io.objectbox.generator.model.ToManyStandalone;
import io.objectbox.logging.Logging;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.greenrobot.essentials.collections.LongHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 _2\u00020\u0001:\u0002_`B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u00101\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001003022\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b05H\u0002J\u001f\u00106\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u00109J'\u0010:\u001a\u0004\u0018\u00010)2\u0006\u0010;\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010<J)\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010;\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010?J\u000e\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020(J\b\u0010B\u001a\u00020CH\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010E\u001a\u00020\u0003J\u0017\u0010F\u001a\u00020\u00102\b\u0010G\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010HJ\u000e\u0010I\u001a\u00020C2\u0006\u0010J\u001a\u00020KJ\u001a\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\n2\b\u0010N\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010O\u001a\u0004\u0018\u00010\u000b2\u0006\u0010M\u001a\u00020\nH\u0002J(\u0010P\u001a\b\u0012\u0004\u0012\u00020)0+2\u0006\u0010M\u001a\u00020\n2\b\u0010N\u001a\u0004\u0018\u00010\u000b2\u0006\u0010Q\u001a\u00020\u0012H\u0002J*\u0010R\u001a\u00020)2\b\u0010N\u001a\u0004\u0018\u00010\u000b2\u0006\u0010M\u001a\u00020\n2\u0006\u0010S\u001a\u00020(2\u0006\u0010Q\u001a\u00020\u0012H\u0002J\"\u0010T\u001a\u00020>2\b\u0010N\u001a\u0004\u0018\u00010\u000b2\u0006\u0010M\u001a\u00020\n2\u0006\u0010U\u001a\u00020VH\u0002J \u0010W\u001a\b\u0012\u0004\u0012\u00020>0+2\u0006\u0010M\u001a\u00020\n2\b\u0010N\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010X\u001a\u00020C2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0YH\u0002J\u0010\u0010Z\u001a\u00020C2\u0006\u0010[\u001a\u00020\u001eH\u0002J\u0010\u0010\\\u001a\u00020C2\u0006\u0010[\u001a\u00020\u001eH\u0002J\u0010\u0010]\u001a\u00020C2\u0006\u0010[\u001a\u00020\u001eH\u0002J\u0016\u0010]\u001a\u00020C2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0YH\u0002J\f\u0010^\u001a\u00020\u000e*\u00020\nH\u0002R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lio/objectbox/generator/idsync/IdSync;", "", "jsonFile", "Ljava/io/File;", "(Ljava/io/File;)V", "backupFile", "getBackupFile", "()Ljava/io/File;", "entitiesBySchemaEntity", "Ljava/util/IdentityHashMap;", "Lio/objectbox/generator/model/Entity;", "Lio/objectbox/generator/idsync/Entity;", "entitiesReadByName", "Ljava/util/HashMap;", "", "entitiesReadByUid", "", "<set-?>", "Lio/objectbox/generator/IdUid;", "lastEntityId", "getLastEntityId", "()Lio/objectbox/generator/IdUid;", "lastIndexId", "getLastIndexId", "lastRelationId", "getLastRelationId", "lastSequenceId", "getLastSequenceId", "modelJsonAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lio/objectbox/generator/idsync/IdSyncModel;", "modelRead", "newUidPool", "", "getNewUidPool", "()Ljava/util/Set;", "noteSeeDocs", "parsedUids", "Lorg/greenrobot/essentials/collections/LongHashSet;", "propertiesBySchemaProperty", "Lio/objectbox/generator/model/Property;", "Lio/objectbox/generator/idsync/Property;", "retiredEntityUids", "Ljava/util/ArrayList;", "retiredIndexUids", "retiredPropertyUids", "retiredRelationUids", "uidHelper", "Lio/objectbox/generator/idsync/UidHelper;", "collectPropertyUids", "Lkotlin/Triple;", "", "entities", "", "findEntity", "name", "uid", "(Ljava/lang/String;Ljava/lang/Long;)Lio/objectbox/generator/idsync/Entity;", "findProperty", "entity", "(Lio/objectbox/generator/idsync/Entity;Ljava/lang/String;Ljava/lang/Long;)Lio/objectbox/generator/idsync/Property;", "findRelation", "Lio/objectbox/generator/idsync/Relation;", "(Lio/objectbox/generator/idsync/Entity;Ljava/lang/String;Ljava/lang/Long;)Lio/objectbox/generator/idsync/Relation;", "get", "property", "initModel", "", "justRead", "file", "newUid", "uidCandidate", "(Ljava/lang/Long;)J", "sync", "schema", "Lio/objectbox/generator/model/Schema;", "syncEntity", "schemaEntity", "existingEntity", "syncEntityIdUids", "syncProperties", "lastPropertyId", "syncProperty", "schemaProperty", "syncRelation", "schemaRelation", "Lio/objectbox/generator/model/ToManyStandalone;", "syncRelations", "updateRetiredUids", "", "validateBeforeWrite", "model", "validateIds", "writeModel", "getName", "Companion", "ModelIdAdapter", "objectbox-code-modifier"})
public final class IdSync {
    private final String noteSeeDocs;
    @NotNull
    private final File backupFile;
    private final JsonAdapter<IdSyncModel> modelJsonAdapter;
    private final UidHelper uidHelper;
    private final HashMap<Long, Entity> entitiesReadByUid;
    private final HashMap<String, Entity> entitiesReadByName;
    private final LongHashSet parsedUids;
    private IdSyncModel modelRead;
    @NotNull
    private IdUid lastEntityId;
    @NotNull
    private IdUid lastIndexId;
    @NotNull
    private IdUid lastRelationId;
    @NotNull
    private IdUid lastSequenceId;
    @NotNull
    private final Set<Long> newUidPool;
    private final ArrayList<Long> retiredEntityUids;
    private final ArrayList<Long> retiredPropertyUids;
    private final ArrayList<Long> retiredIndexUids;
    private final ArrayList<Long> retiredRelationUids;
    private final IdentityHashMap<io.objectbox.generator.model.Entity, Entity> entitiesBySchemaEntity;
    private final IdentityHashMap<io.objectbox.generator.model.Property, Property> propertiesBySchemaProperty;
    private final File jsonFile;
    public static final int MIN_VERSION = 2;
    public static final long MAX_VERSION = 5L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final File getBackupFile() {
        return this.backupFile;
    }

    @NotNull
    public final IdUid getLastEntityId() {
        return this.lastEntityId;
    }

    @NotNull
    public final IdUid getLastIndexId() {
        return this.lastIndexId;
    }

    @NotNull
    public final IdUid getLastRelationId() {
        return this.lastRelationId;
    }

    @NotNull
    public final IdUid getLastSequenceId() {
        return this.lastSequenceId;
    }

    @NotNull
    public final Set<Long> getNewUidPool() {
        return this.newUidPool;
    }

    private final void initModel() {
        try {
            IdSyncModel idSyncModel = IdSync.justRead$default(this, null, 1, null);
            if (idSyncModel != null) {
                if (idSyncModel.getModelVersion() < (long)2) {
                    throw (Throwable)new IdSyncException("The model version is too old: minimum version is 2, " + "but found " + idSyncModel.getModelVersion() + ". " + "The model files was generated by an old version that is not supported anymore.", null, 2, null);
                }
                if (idSyncModel.getModelVersion() > 5L) {
                    long parserMinimum;
                    Long l = idSyncModel.getModelVersionParserMinimum();
                    long l2 = parserMinimum = l != null ? l : 0L;
                    if (parserMinimum == 0L || parserMinimum > 5L) {
                        throw (Throwable)new IdSyncException("The model is too new: maximum supported version is 5, " + "but found " + idSyncModel.getModelVersion() + ". " + "The model files was generated by a newer version and has incompatible changes.", null, 2, null);
                    }
                }
                this.validateIds(idSyncModel);
                this.modelRead = idSyncModel;
                this.lastEntityId = idSyncModel.getLastEntityId();
                IdUid idUid = idSyncModel.getLastRelationId();
                if (idUid == null) {
                    idUid = new IdUid(0, 0L, 3, null);
                }
                this.lastRelationId = idUid;
                this.lastIndexId = idSyncModel.getLastIndexId();
                this.lastSequenceId = idSyncModel.getLastSequenceId();
                Collection parserMinimum = this.retiredEntityUids;
                List<Long> list = idSyncModel.getRetiredEntityUids();
                Iterable iterable = list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList();
                boolean bl = false;
                CollectionsKt.addAll((Collection)parserMinimum, (Iterable)iterable);
                parserMinimum = this.retiredPropertyUids;
                List<Long> list2 = idSyncModel.getRetiredPropertyUids();
                iterable = list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList();
                bl = false;
                CollectionsKt.addAll((Collection)parserMinimum, (Iterable)iterable);
                parserMinimum = this.retiredIndexUids;
                List<Long> list3 = idSyncModel.getRetiredIndexUids();
                iterable = list3 != null ? (Iterable)list3 : (Iterable)CollectionsKt.emptyList();
                bl = false;
                CollectionsKt.addAll((Collection)parserMinimum, (Iterable)iterable);
                parserMinimum = this.retiredRelationUids;
                List<Long> list4 = idSyncModel.getRetiredRelationUids();
                iterable = list4 != null ? (Iterable)list4 : (Iterable)CollectionsKt.emptyList();
                bl = false;
                CollectionsKt.addAll((Collection)parserMinimum, (Iterable)iterable);
                parserMinimum = this.newUidPool;
                List<Long> list5 = idSyncModel.getNewUidPool();
                iterable = list5 != null ? (Iterable)list5 : (Iterable)CollectionsKt.emptyList();
                bl = false;
                CollectionsKt.addAll((Collection)parserMinimum, (Iterable)iterable);
                this.uidHelper.addExistingIds((Collection<Long>)this.retiredEntityUids);
                this.uidHelper.addExistingIds((Collection<Long>)this.retiredPropertyUids);
                this.uidHelper.addExistingIds((Collection<Long>)this.retiredIndexUids);
                this.uidHelper.addExistingIds((Collection<Long>)this.retiredRelationUids);
                Iterable $this$forEach$iv = idSyncModel.getEntities();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity entity = (Entity)element$iv;
                    boolean bl2 = false;
                    this.uidHelper.addExistingId(entity.getUid());
                    Iterable $this$forEach$iv2 = entity.getProperties();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Property it = (Property)element$iv2;
                        boolean bl3 = false;
                        this.uidHelper.addExistingId(it.getUid());
                    }
                    ((Map)this.entitiesReadByUid).put(entity.getUid(), entity);
                    String string = entity.getName();
                    boolean bl4 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    if (this.entitiesReadByName.put(string3, entity) == null) continue;
                    throw (Throwable)new IdSyncException("Malformed model file \"" + this.jsonFile.getName() + "\": " + "duplicate entity name " + entity.getName() + " - please edit the file to resolve the issue", null, 2, null);
                }
            }
        }
        catch (Throwable e) {
            String message = "Could not load object model ID file \"" + this.jsonFile.getAbsolutePath() + "\": " + e.getMessage();
            throw (Throwable)new IdSyncException(message, e);
        }
    }

    private final void validateIds(IdSyncModel model) {
        boolean bl = false;
        Set entityIds = new LinkedHashSet();
        Iterable $this$forEach$iv = model.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl2 = false;
            if (!entityIds.add(entity.getId().getId())) {
                throw (Throwable)new IdSyncException("Duplicate ID " + entity.getId().getId() + " for entity " + entity.getName() + ". " + this.noteSeeDocs, null, 2, null);
            }
            if (entity.getModelId() == model.getLastEntityId().getId()) {
                if (entity.getUid() != model.getLastEntityId().getUid()) {
                    throw (Throwable)new IdSyncException("Entity " + entity.getName() + " ID " + entity.getId() + " does not match UID of lastEntityId " + model.getLastEntityId() + ". " + this.noteSeeDocs, null, 2, null);
                }
            } else if (entity.getModelId() > model.getLastEntityId().getId()) {
                throw (Throwable)new IdSyncException("Entity " + entity.getName() + " has an ID " + entity.getId() + " above lastEntityId " + model.getLastEntityId() + ". " + this.noteSeeDocs, null, 2, null);
            }
            boolean bl3 = false;
            Set propertyIds = new LinkedHashSet();
            Iterable $this$forEach$iv2 = entity.getProperties();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Property property = (Property)element$iv2;
                boolean bl4 = false;
                if (!propertyIds.add(property.getId().getId())) {
                    throw (Throwable)new IdSyncException("Duplicate ID " + property.getId().getId() + " for property " + entity.getName() + '.' + property.getName() + ". " + this.noteSeeDocs, null, 2, null);
                }
                if (property.getModelId() == entity.getLastPropertyId().getId()) {
                    if (property.getUid() == entity.getLastPropertyId().getUid()) continue;
                    throw (Throwable)new IdSyncException("Property " + entity.getName() + '.' + property.getName() + " ID " + property.getId() + " does not match UID of lastPropertyId " + entity.getLastPropertyId() + ". " + this.noteSeeDocs, null, 2, null);
                }
                if (property.getModelId() <= entity.getLastPropertyId().getId()) continue;
                throw (Throwable)new IdSyncException("Property " + entity.getName() + '.' + property.getName() + " has an ID " + property.getId() + " above " + "lastPropertyId " + entity.getLastPropertyId() + ". " + this.noteSeeDocs, null, 2, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sync(@NotNull Schema schema) {
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                if (!schema.isFinished()) {
                    throw (Throwable)new IllegalStateException("Must call schema.finish() first");
                }
                Map map = this.entitiesBySchemaEntity;
                boolean bl = false;
                if (!map.isEmpty()) break block13;
                map = this.propertiesBySchemaProperty;
                bl = false;
                if (!(!map.isEmpty())) break block14;
            }
            throw (Throwable)new IllegalStateException("May be called only once");
        }
        List schemaEntities = schema.getEntities();
        try {
            void $this$mapTo$iv$iv;
            Object object;
            io.objectbox.generator.model.Entity it;
            Object object2;
            Iterable $this$associateByTo$iv$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            List list = schemaEntities;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schemaEntities");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<Entity> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Entity entity;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                io.objectbox.generator.model.Entity it2 = (io.objectbox.generator.model.Entity)element$iv$iv;
                boolean bl2 = false;
                io.objectbox.generator.model.Entity entity2 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"it");
                if (this.syncEntityIdUids(entity2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Entity it$iv$iv = entity;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$associateBy$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                element$iv$iv$iv = (Entity)element$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                object = it.getUid();
                object2.put(object, element$iv$iv);
            }
            Map existingEntities = destination$iv$iv2;
            Iterable $this$map$iv = schemaEntities;
            boolean $i$f$map = false;
            $this$associateByTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (io.objectbox.generator.model.Entity)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                io.objectbox.generator.model.Entity entity = it;
                Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"it");
                object = this.syncEntity(entity, (Entity)existingEntities.get(it.getModelUid()));
                object2.add(object);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv2;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            List entities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Entity it = (Entity)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getId().getId());
                    it = (Entity)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getId().getId();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            this.updateRetiredUids(entities);
            this.writeModel(entities);
        }
        catch (Throwable e) {
            if (e instanceof IdSyncPrintUidException) {
                try {
                    IdSyncModel idSyncModel = IdSync.justRead$default(this, null, 1, null);
                    Intrinsics.checkNotNull((Object)idSyncModel);
                    IdSyncModel model = idSyncModel;
                    model.setNewUidPool(CollectionsKt.listOf((Object)((IdSyncPrintUidException)e).getRandomNewUid()));
                    this.writeModel(model);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw e;
            }
            String message = "Could not sync parsed model with ID model file \"" + this.jsonFile.getAbsolutePath() + "\": " + e.getMessage();
            throw (Throwable)new IdSyncException(message, e);
        }
        schema.setLastEntityId(this.lastEntityId);
        schema.setLastIndexId(this.lastIndexId);
        schema.setLastRelationId(this.lastRelationId);
    }

    private final Entity syncEntityIdUids(io.objectbox.generator.model.Entity schemaEntity) {
        boolean printUid;
        Long entityUid;
        String string = schemaEntity.getDbName();
        if (string == null) {
            string = schemaEntity.getClassName();
        }
        String entityName = string;
        Long l = entityUid = schemaEntity.getModelUid();
        boolean bl = printUid = l != null && l == -1L;
        if (entityUid != null && !printUid && !this.parsedUids.add(entityUid.longValue())) {
            throw (Throwable)new IdSyncException("Non-unique UID " + entityUid + " in parsed entity " + schemaEntity.getJavaPackage() + '.' + schemaEntity.getClassName(), null, 2, null);
        }
        String string2 = entityName;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entityName");
        Entity existingEntity = this.findEntity(string2, entityUid);
        if (printUid) {
            if (existingEntity != null) {
                throw (Throwable)new IdSyncPrintUidException("entity \"" + entityName + '\"', existingEntity.getUid(), this.uidHelper.create());
            }
            throw (Throwable)new IdSyncException("Cannot use @Uid without a value for a new entity: " + entityName, null, 2, null);
        }
        Entity entity = existingEntity;
        IdUid sourceId = (entity != null ? entity.getId() : null) == null ? this.lastEntityId.incId(this.newUid(entityUid)) : existingEntity.getId();
        schemaEntity.setModelId(Integer.valueOf(sourceId.getId()));
        schemaEntity.setModelUid(Long.valueOf(sourceId.getUid()));
        return existingEntity;
    }

    private final Entity syncEntity(io.objectbox.generator.model.Entity schemaEntity, Entity existingEntity) {
        if (existingEntity != null) {
            Integer n = existingEntity.getFlags();
            int oldFlags = n != null ? n : 0;
            Integer n2 = schemaEntity.getEntityFlagsForModelFile();
            if (n2 == null) {
                n2 = 0;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"schemaEntity.entityFlagsForModelFile ?: 0");
            int newFlags = n2;
            if (oldFlags != newFlags) {
                boolean newSyncSharedGlobalIds;
                boolean newSyncEnabled;
                boolean oldSyncEnabled = (oldFlags & 2) != 0;
                boolean bl = newSyncEnabled = (newFlags & 2) != 0;
                if (oldSyncEnabled != newSyncEnabled) {
                    throw (Throwable)new IdSyncException("Can't change Sync annotation for existing entity '" + this.getName(schemaEntity) + "'.", null, 2, null);
                }
                boolean oldSyncSharedGlobalIds = (oldFlags & 4) != 0;
                boolean bl2 = newSyncSharedGlobalIds = (newFlags & 4) != 0;
                if (oldSyncSharedGlobalIds != newSyncSharedGlobalIds) {
                    throw (Throwable)new IdSyncException("Can't change Sync.sharedGlobalIds setting for existing entity '" + this.getName(schemaEntity) + "'.", null, 2, null);
                }
            }
        }
        Entity entity = existingEntity;
        IdUid lastPropertyId = (entity != null ? entity.getLastPropertyId() : null) == null ? new IdUid(0, 0L, 3, null) : existingEntity.getLastPropertyId().clone();
        ArrayList<Property> properties = this.syncProperties(schemaEntity, existingEntity, lastPropertyId);
        ArrayList<Relation> relations = this.syncRelations(schemaEntity, existingEntity);
        String string = this.getName(schemaEntity);
        Integer n = schemaEntity.getModelId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"schemaEntity.modelId");
        int n3 = n;
        Long l = schemaEntity.getModelUid();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"schemaEntity.modelUid");
        IdUid idUid = lastPropertyId;
        List list = relations;
        List list2 = properties;
        Integer n4 = schemaEntity.getEntityFlagsForModelFile();
        IdUid idUid2 = new IdUid(n3, l.longValue());
        String string2 = string;
        Entity entity2 = new Entity(idUid2, idUid, string2, n4, list2, list);
        schemaEntity.setLastPropertyId(entity2.getLastPropertyId());
        ((Map)this.entitiesBySchemaEntity).put(schemaEntity, entity2);
        return entity2;
    }

    private final String getName(io.objectbox.generator.model.Entity $this$getName) {
        String string = $this$getName.getDbName();
        if (string == null) {
            String string2 = $this$getName.getClassName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className");
        }
        return string;
    }

    private final ArrayList<Property> syncProperties(io.objectbox.generator.model.Entity schemaEntity, Entity existingEntity, IdUid lastPropertyId) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Iterator iterator = schemaEntity.getProperties().iterator();
        while (iterator.hasNext()) {
            io.objectbox.generator.model.Property parsedProperty;
            io.objectbox.generator.model.Property property = parsedProperty = (io.objectbox.generator.model.Property)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"parsedProperty");
            Property property2 = this.syncProperty(existingEntity, schemaEntity, property, lastPropertyId);
            if (property2.getModelId() > lastPropertyId.getId()) {
                lastPropertyId.set(property2.getId());
            }
            properties.add(property2);
        }
        List $this$sortBy$iv = properties;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Property it = (Property)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getId().getId());
                    it = (Property)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getId().getId();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
        }
        return properties;
    }

    private final Property syncProperty(Entity existingEntity, io.objectbox.generator.model.Entity schemaEntity, io.objectbox.generator.model.Property schemaProperty, IdUid lastPropertyId) {
        Object v5;
        Object object;
        Object object2;
        Object object3;
        Object sourceIndexId;
        Property existingProperty;
        Long propertyUid;
        String name;
        block9: {
            String string = schemaProperty.getDbName();
            if (string == null) {
                string = schemaProperty.getPropertyName();
            }
            name = string;
            IdUid idUid = schemaProperty.getModelId();
            Long l = propertyUid = idUid != null ? Long.valueOf(idUid.getUid()) : null;
            boolean printUid = l != null && l == -1L;
            existingProperty = null;
            if (existingEntity != null) {
                if (propertyUid != null && !printUid && !this.parsedUids.add(propertyUid.longValue())) {
                    throw (Throwable)new IdSyncException("Non-unique UID " + propertyUid + " in parsed entity " + schemaEntity.getJavaPackage() + '.' + schemaEntity.getClassName() + ' ' + "for property " + schemaProperty.getPropertyName(), null, 2, null);
                }
                String string2 = name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                existingProperty = this.findProperty(existingEntity, string2, propertyUid);
            }
            if (printUid) {
                String propertyName = '\"' + schemaEntity.getClassName() + '.' + schemaProperty.getPropertyName() + '\"';
                if (existingProperty != null) {
                    throw (Throwable)new IdSyncPrintUidException("property " + propertyName, existingProperty.getUid(), this.uidHelper.create());
                }
                throw (Throwable)new IdSyncException("Cannot use @Uid without a value for a new property: " + propertyName, null, 2, null);
            }
            sourceIndexId = null;
            List list = schemaEntity.getIndexes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schemaEntity.indexes");
            Iterable iterable = list;
            boolean bl = false;
            object3 = iterable;
            boolean bl2 = false;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                Index it = (Index)object;
                boolean bl3 = false;
                if (!(it.getProperties().size() == 1 && Intrinsics.areEqual((Object)((io.objectbox.generator.model.Property)it.getProperties().get(0)), (Object)schemaProperty))) continue;
                v5 = object;
                break block9;
            }
            v5 = null;
        }
        Index index = v5;
        if (index != null) {
            Property property = existingProperty;
            if (property == null || (property = property.getIndexId()) == null) {
                property = this.lastIndexId.incId(this.uidHelper.create());
            }
            sourceIndexId = property;
        }
        Property property = existingProperty;
        IdUid sourceId = (property != null ? property.getId() : null) == null ? lastPropertyId.incId(this.newUid(propertyUid)) : existingProperty.getId();
        String string = name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        Object object4 = sourceIndexId;
        io.objectbox.generator.model.Entity entity = schemaProperty.getTargetEntity();
        object3 = entity != null ? entity.getDbName() : null;
        Integer n = schemaProperty.getPropertyFlagsForModelFile();
        object2 = (int)schemaProperty.getDbTypeId().shortValue();
        object = object4 != null ? object4.clone() : null;
        IdUid idUid = sourceId.clone();
        String string3 = string;
        Property property2 = new Property(idUid, string3, (IdUid)object, (Integer)object2, n, (String)object3);
        schemaProperty.setModelId(property2.getId());
        schemaProperty.setModelIndexId(property2.getIndexId());
        Property collision = this.propertiesBySchemaProperty.put(schemaProperty, property2);
        if (collision != null) {
            throw (Throwable)new IllegalStateException("Property collision: " + schemaProperty + " vs. " + collision);
        }
        return property2;
    }

    private final long newUid(Long uidCandidate) {
        if (uidCandidate != null && !this.newUidPool.remove(uidCandidate)) {
            throw (Throwable)new IdSyncException("Unexpected UID " + uidCandidate + " was not in newUidPool", null, 2, null);
        }
        Long l = uidCandidate;
        return l != null ? l.longValue() : this.uidHelper.create();
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<Relation> syncRelations(io.objectbox.generator.model.Entity schemaEntity, Entity existingEntity) {
        void $this$filterIsInstanceTo$iv$iv;
        ArrayList<Relation> relations = new ArrayList<Relation>();
        List list = schemaEntity.getToManyRelations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schemaEntity.toManyRelations");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ToManyStandalone)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ToManyStandalone schemaRelation : (List)destination$iv$iv) {
            Relation relation = this.syncRelation(existingEntity, schemaEntity, schemaRelation);
            if (relation.getModelId() > this.lastRelationId.getId()) {
                this.lastRelationId.set(relation.getId());
            }
            relations.add(relation);
        }
        List $this$sortBy$iv = relations;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Relation it = (Relation)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getId().getId());
                    it = (Relation)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getId().getId();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
        }
        return relations;
    }

    private final Relation syncRelation(Entity existingEntity, io.objectbox.generator.model.Entity schemaEntity, ToManyStandalone schemaRelation) {
        Long relationUid;
        String name = schemaRelation.getDbName();
        IdUid idUid = schemaRelation.getModelId();
        Long l = relationUid = idUid != null ? Long.valueOf(idUid.getUid()) : null;
        boolean printUid = l != null && l == -1L;
        Relation existingRelation = null;
        if (existingEntity != null) {
            if (relationUid != null && !printUid && !this.parsedUids.add(relationUid.longValue())) {
                throw (Throwable)new IdSyncException("Non-unique UID " + relationUid + " in parsed entity " + schemaEntity.getJavaPackage() + '.' + schemaEntity.getClassName() + ' ' + "for relation " + schemaRelation.getName(), null, 2, null);
            }
            existingRelation = this.findRelation(existingEntity, name, relationUid);
        }
        if (printUid) {
            String relationName = '\"' + schemaEntity.getClassName() + '.' + schemaRelation.getName() + '\"';
            if (existingRelation != null) {
                throw (Throwable)new IdSyncPrintUidException("relation " + relationName, existingRelation.getUid(), this.uidHelper.create());
            }
            throw (Throwable)new IdSyncException("Cannot use @Uid without a value for a new relation: " + relationName, null, 2, null);
        }
        Relation relation = existingRelation;
        IdUid sourceId = (relation != null ? relation.getId() : null) == null ? this.lastRelationId.incId(this.newUid(relationUid)) : existingRelation.getId();
        IdUid idUid2 = sourceId.clone();
        io.objectbox.generator.model.Entity entity = schemaRelation.getTargetEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"schemaRelation.targetEntity");
        Integer n = entity.getModelId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"schemaRelation.targetEntity.modelId");
        int n2 = n;
        io.objectbox.generator.model.Entity entity2 = schemaRelation.getTargetEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"schemaRelation.targetEntity");
        Long l2 = entity2.getModelUid();
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"schemaRelation.targetEntity.modelUid");
        IdUid idUid3 = new IdUid(n2, l2.longValue());
        IdUid idUid4 = idUid2;
        String string = name;
        Relation relation2 = new Relation(idUid4, string, idUid3);
        schemaRelation.setModelId(relation2.getId());
        return relation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IdSyncModel justRead(@NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.jsonFile.exists() || this.jsonFile.length() == 0L) {
            return null;
        }
        try {
            IdSyncModel idSyncModel;
            object = (Closeable)Okio.source((File)file);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Source it = (Source)object;
                boolean bl3 = false;
                idSyncModel = (IdSyncModel)this.modelJsonAdapter.fromJson(Okio.buffer((Source)it));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = idSyncModel;
        }
        catch (FileNotFoundException e) {
            object = null;
        }
        return object;
    }

    public static /* synthetic */ IdSyncModel justRead$default(IdSync idSync, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = idSync.jsonFile;
        }
        return idSync.justRead(file);
    }

    @Nullable
    public final Entity findEntity(@NotNull String name, @Nullable Long uid) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (uid != null && uid != 0L && uid != -1L) {
            Entity entity = this.entitiesReadByUid.get(uid);
            if (entity == null) {
                if (this.newUidPool.contains(uid)) {
                    return null;
                }
                throw (Throwable)new IdSyncException("No entity with UID " + uid + " found", null, 2, null);
            }
            return entity;
        }
        String string = name;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return this.entitiesReadByName.get(string2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Property findProperty(@NotNull Entity entity, @NotNull String name, @Nullable Long uid) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (uid != null && uid != 0L && uid != -1L) {
            void $this$filterTo$iv$iv222;
            Iterable $this$filter$iv22 = entity.getProperties();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv22;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv222) {
                Property it = (Property)element$iv$iv;
                boolean bl = false;
                Long l = uid;
                if (!(l != null && it.getUid() == l.longValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filtered = (List)destination$iv$iv;
            if (filtered.isEmpty()) {
                if (this.newUidPool.contains(uid)) {
                    return null;
                }
                throw (Throwable)new IdSyncException("In entity " + entity.getName() + ", no property with UID " + uid + " found", null, 2, null);
            }
            boolean $this$filter$iv22 = filtered.size() == 1;
            $i$f$filter = false;
            boolean $this$filterTo$iv$iv222 = false;
            if (!$this$filter$iv22) {
                boolean bl = false;
                String $this$filterTo$iv$iv222 = "property name: " + name + ", UID: " + uid;
                throw (Throwable)new IllegalStateException($this$filterTo$iv$iv222.toString());
            }
            return (Property)CollectionsKt.first((List)filtered);
        }
        String $this$filter$iv22 = name;
        boolean $i$f$filter = false;
        String string = $this$filter$iv22.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        String nameLowerCase = string;
        Iterable $this$filter$iv = entity.getProperties();
        boolean $i$f$filter2 = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Property it = (Property)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.getName();
            boolean bl3 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            if (!Intrinsics.areEqual((Object)string4, (Object)nameLowerCase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        boolean bl4 = filtered.size() <= 1;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string5 = "size: " + filtered.size() + " property name: " + name + ", UID: " + uid;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        Collection collection = filtered;
        bl5 = false;
        return !collection.isEmpty() ? (Property)CollectionsKt.first((List)filtered) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Relation findRelation(Entity entity, String name, Long uid) {
        void $this$filterTo$iv$iv;
        if (entity.getRelations() == null) {
            return null;
        }
        if (uid != null && uid != 0L && uid != -1L) {
            void $this$filterTo$iv$iv222;
            Iterable $this$filter$iv22 = entity.getRelations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv22;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv222) {
                Relation it = (Relation)element$iv$iv;
                boolean bl = false;
                Long l = uid;
                if (!(l != null && it.getUid() == l.longValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filtered = (List)destination$iv$iv;
            if (filtered.isEmpty()) {
                if (this.newUidPool.contains(uid)) {
                    return null;
                }
                throw (Throwable)new IdSyncException("In entity " + entity.getName() + ", no relation with UID " + uid + " found", null, 2, null);
            }
            boolean $this$filter$iv22 = filtered.size() == 1;
            $i$f$filter = false;
            boolean $this$filterTo$iv$iv222 = false;
            if (!$this$filter$iv22) {
                boolean bl = false;
                String $this$filterTo$iv$iv222 = "relation name: " + name + ", UID: " + uid;
                throw (Throwable)new IllegalStateException($this$filterTo$iv$iv222.toString());
            }
            return (Relation)CollectionsKt.first((List)filtered);
        }
        String $this$filter$iv22 = name;
        boolean $i$f$filter = false;
        String string = $this$filter$iv22;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String nameLowerCase = string2;
        Iterable $this$filter$iv = entity.getRelations();
        boolean $i$f$filter2 = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Relation it = (Relation)element$iv$iv;
            boolean bl2 = false;
            String string3 = it.getName();
            boolean bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            if (!Intrinsics.areEqual((Object)string5, (Object)nameLowerCase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        boolean bl4 = filtered.size() <= 1;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string6 = "size: " + filtered.size() + " relation name: " + name + ", UID: " + uid;
            throw (Throwable)new IllegalStateException(string6.toString());
        }
        Collection collection = filtered;
        bl5 = false;
        return !collection.isEmpty() ? (Relation)CollectionsKt.first((List)filtered) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateRetiredUids(List<Entity> entities) {
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set<Long> set = this.entitiesReadByUid.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"entitiesReadByUid.keys");
        List oldEntityUids = CollectionsKt.toMutableList((Collection)set);
        Iterable iterable = entities;
        List list = oldEntityUids;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entity entity = (Entity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getUid();
            collection.add(l);
        }
        collection = (List)destination$iv$iv;
        list.removeAll(collection);
        this.retiredEntityUids.addAll(oldEntityUids);
        Collection<Entity> collection2 = this.entitiesReadByUid.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"entitiesReadByUid.values");
        Triple<List<Long>, List<Long>, List<Long>> oldPropertyUids = this.collectPropertyUids(collection2);
        Triple<List<Long>, List<Long>, List<Long>> newPropertyUids = this.collectPropertyUids((Collection<Entity>)entities);
        ((List)oldPropertyUids.getFirst()).removeAll((Collection)newPropertyUids.getFirst());
        this.retiredPropertyUids.addAll((Collection)oldPropertyUids.getFirst());
        ((List)oldPropertyUids.getSecond()).removeAll((Collection)newPropertyUids.getSecond());
        this.retiredIndexUids.addAll((Collection)oldPropertyUids.getSecond());
        ((List)oldPropertyUids.getThird()).removeAll((Collection)newPropertyUids.getThird());
        this.retiredRelationUids.addAll((Collection)oldPropertyUids.getThird());
    }

    private final Triple<List<Long>, List<Long>, List<Long>> collectPropertyUids(Collection<Entity> entities) {
        ArrayList propertyUids = new ArrayList();
        ArrayList indexUids = new ArrayList();
        ArrayList relationUids = new ArrayList();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Long l;
            Collection collection;
            HasIdUid it;
            Entity entity = (Entity)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = entity.getProperties();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Property)element$iv2;
                boolean bl3 = false;
                collection = propertyUids;
                l = ((Property)it).getUid();
                bl = false;
                collection.add(l);
                if (((Property)it).getIndexId() == null) continue;
                collection = indexUids;
                l = ((Property)it).getIndexId().getUid();
                bl = false;
                collection.add(l);
            }
            List<Relation> list = entity.getRelations();
            if (list == null) continue;
            $this$forEach$iv2 = list;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Relation)element$iv2;
                boolean bl4 = false;
                collection = relationUids;
                l = ((Relation)it).getUid();
                bl = false;
                collection.add(l);
            }
        }
        return new Triple(propertyUids, indexUids, relationUids);
    }

    private final void writeModel(List<Entity> entities) {
        List list = this.retiredRelationUids;
        List list2 = this.retiredIndexUids;
        List list3 = this.retiredPropertyUids;
        List list4 = this.retiredEntityUids;
        List<Entity> list5 = entities;
        List list6 = null;
        IdUid idUid = this.lastSequenceId;
        IdUid idUid2 = this.lastRelationId;
        IdUid idUid3 = this.lastIndexId;
        IdUid idUid4 = this.lastEntityId;
        Long l = 5L;
        long l2 = 5L;
        long l3 = 1L;
        IdSyncModel model = new IdSyncModel(null, null, null, list5, idUid4, idUid3, idUid2, idUid, l2, l, list6, list4, list2, list3, list, l3, 7, null);
        this.writeModel(model);
        this.validateIds(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeModel(IdSyncModel model) {
        JsonWriter jsonWriter;
        this.validateBeforeWrite(model);
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter2 = jsonWriter = JsonWriter.of((BufferedSink)((BufferedSink)buffer));
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter2, (String)"jsonWriter");
        jsonWriter2.setIndent("  ");
        model.setModelVersion(5L);
        model.setModelVersionParserMinimum(5L);
        this.modelJsonAdapter.toJson(jsonWriter, (Object)model);
        if (this.jsonFile.exists()) {
            byte[] content;
            byte[] existingContent = FilesKt.readBytes((File)this.jsonFile);
            if (Arrays.equals(existingContent, content = buffer.snapshot().toByteArray())) {
                Logging.log("ID model file unchanged: " + this.jsonFile.getName());
                return;
            }
            Logging.log("ID model file changed: " + this.jsonFile.getName() + ", creating backup (.bak)");
            FilesKt.copyTo$default((File)this.jsonFile, (File)this.backupFile, (boolean)true, (int)0, (int)4, null);
        } else {
            Logging.log("ID model file created: " + this.jsonFile.getName());
        }
        Closeable closeable = (Closeable)Okio.sink((File)this.jsonFile);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Sink it = (Sink)closeable;
            boolean bl3 = false;
            long l = buffer.readAll(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void validateBeforeWrite(IdSyncModel model) {
        boolean bl = false;
        Set entityNames = new LinkedHashSet();
        for (Entity entity : model.getEntities()) {
            String string = entity.getName();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (!entityNames.add(string3)) {
                throw (Throwable)new IdSyncException("Could not write model file \"" + this.jsonFile.getName() + "\" - verification failed: " + "duplicate entity name \"" + entity.getName() + "\" (please report if you think this a bug)", null, 2, null);
            }
            bl2 = false;
            Set propertyNames = new LinkedHashSet();
            for (Property property : entity.getProperties()) {
                String string4 = property.getName();
                boolean bl3 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                if (propertyNames.add(string6)) continue;
                throw (Throwable)new IdSyncException("Could not write model file \"" + this.jsonFile.getName() + "\" - verification failed: " + "duplicate property name \"" + property.getName() + "\" in entity \"" + entity.getName() + "\" " + "(please report if you think this a bug)", null, 2, null);
            }
        }
    }

    @NotNull
    public final Property get(@NotNull io.objectbox.generator.model.Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Property property2 = this.propertiesBySchemaProperty.get(property);
        if (property2 == null) {
            throw (Throwable)new IllegalStateException("No ID model property available for schema property " + property.getPropertyName());
        }
        return property2;
    }

    public IdSync(@NotNull File jsonFile) {
        Moshi moshi;
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        this.jsonFile = jsonFile;
        this.noteSeeDocs = "Please read the docs how to resolve this.";
        this.backupFile = new File(this.jsonFile.getAbsolutePath() + ".bak");
        this.uidHelper = new UidHelper(null, 1, null);
        this.entitiesReadByUid = new HashMap();
        this.entitiesReadByName = new HashMap();
        this.parsedUids = new LongHashSet();
        this.lastEntityId = new IdUid(0, 0L, 3, null);
        this.lastIndexId = new IdUid(0, 0L, 3, null);
        this.lastRelationId = new IdUid(0, 0L, 3, null);
        this.lastSequenceId = new IdUid(0, 0L, 3, null);
        boolean bl = false;
        this.newUidPool = new LinkedHashSet();
        this.retiredEntityUids = new ArrayList();
        this.retiredPropertyUids = new ArrayList();
        this.retiredIndexUids = new ArrayList();
        this.retiredRelationUids = new ArrayList();
        this.entitiesBySchemaEntity = new IdentityHashMap();
        this.propertiesBySchemaProperty = new IdentityHashMap();
        Moshi moshi2 = moshi = new Moshi.Builder().add((Object)new ModelIdAdapter()).build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"moshi");
        this.modelJsonAdapter = new IdSyncModelJsonAdapter(moshi2);
        this.initModel();
    }

    public /* synthetic */ IdSync(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = new File("objectmodel.json");
        }
        this(file);
    }

    public IdSync() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lio/objectbox/generator/idsync/IdSync$ModelIdAdapter;", "", "()V", "fromJson", "Lio/objectbox/generator/IdUid;", "id", "", "toJson", "modelId", "objectbox-code-modifier"})
    public static final class ModelIdAdapter {
        @ToJson
        @NotNull
        public final String toJson(@NotNull IdUid modelId) {
            Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
            return modelId.toString();
        }

        @FromJson
        @NotNull
        public final IdUid fromJson(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new IdUid(id);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/objectbox/generator/idsync/IdSync$Companion;", "", "()V", "MAX_VERSION", "", "MIN_VERSION", "", "objectbox-code-modifier"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

