/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.haproxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyConstants;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.codec.haproxy.HAProxySSLTLV;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HaProxyMessageEncoderTest {
    private static final int V2_HEADER_BYTES_LENGTH = 16;
    private static final int IPv4_ADDRESS_BYTES_LENGTH = 12;
    private static final int IPv6_ADDRESS_BYTES_LENGTH = 36;

    @Test
    public void testIPV4EncodeProxyV1() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((Object)"PROXY TCP4 192.168.0.1 192.168.0.11 56324 443\r\n", (Object)byteBuf.toString(CharsetUtil.US_ASCII));
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testIPV6EncodeProxyV1() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, "2001:0db8:85a3:0000:0000:8a2e:0370:7334", "1050:0:0:0:5:600:300c:326b", 56324, 443);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((Object)"PROXY TCP6 2001:0db8:85a3:0000:0000:8a2e:0370:7334 1050:0:0:0:5:600:300c:326b 56324 443\r\n", (Object)byteBuf.toString(CharsetUtil.US_ASCII));
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testIPv4EncodeProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)0, (int)12);
        Assertions.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.getByte(12);
        Assertions.assertEquals((int)2, (int)((commandByte & 0xF0) >> 4));
        Assertions.assertEquals((int)1, (int)(commandByte & 0xF));
        byte transportByte = byteBuf.getByte(13);
        Assertions.assertEquals((int)1, (int)((transportByte & 0xF0) >> 4));
        Assertions.assertEquals((int)1, (int)(transportByte & 0xF));
        int sourceAddrLength = byteBuf.getUnsignedShort(14);
        Assertions.assertEquals((int)12, (int)sourceAddrLength);
        byte[] sourceAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)16, (int)4);
        Assertions.assertArrayEquals((byte[])new byte[]{-64, -88, 0, 1}, (byte[])sourceAddr);
        byte[] destAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)20, (int)4);
        Assertions.assertArrayEquals((byte[])new byte[]{-64, -88, 0, 11}, (byte[])destAddr);
        int sourcePort = byteBuf.getUnsignedShort(24);
        Assertions.assertEquals((int)56324, (int)sourcePort);
        int destPort = byteBuf.getUnsignedShort(26);
        Assertions.assertEquals((int)443, (int)destPort);
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testIPv6EncodeProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, "2001:0db8:85a3:0000:0000:8a2e:0370:7334", "1050:0:0:0:5:600:300c:326b", 56324, 443);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)0, (int)12);
        Assertions.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.getByte(12);
        Assertions.assertEquals((int)2, (int)((commandByte & 0xF0) >> 4));
        Assertions.assertEquals((int)1, (int)(commandByte & 0xF));
        byte transportByte = byteBuf.getByte(13);
        Assertions.assertEquals((int)2, (int)((transportByte & 0xF0) >> 4));
        Assertions.assertEquals((int)1, (int)(transportByte & 0xF));
        int sourceAddrLength = byteBuf.getUnsignedShort(14);
        Assertions.assertEquals((int)36, (int)sourceAddrLength);
        byte[] sourceAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)16, (int)16);
        Assertions.assertArrayEquals((byte[])new byte[]{32, 1, 13, -72, -123, -93, 0, 0, 0, 0, -118, 46, 3, 112, 115, 52}, (byte[])sourceAddr);
        byte[] destAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)32, (int)16);
        Assertions.assertArrayEquals((byte[])new byte[]{16, 80, 0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 48, 12, 50, 107}, (byte[])destAddr);
        int sourcePort = byteBuf.getUnsignedShort(48);
        Assertions.assertEquals((int)56324, (int)sourcePort);
        int destPort = byteBuf.getUnsignedShort(50);
        Assertions.assertEquals((int)443, (int)destPort);
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testUnixEncodeProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, "/var/run/src.sock", "/var/run/dst.sock", 0, 0);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)0, (int)12);
        Assertions.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.getByte(12);
        Assertions.assertEquals((int)2, (int)((commandByte & 0xF0) >> 4));
        Assertions.assertEquals((int)1, (int)(commandByte & 0xF));
        byte transportByte = byteBuf.getByte(13);
        Assertions.assertEquals((int)3, (int)((transportByte & 0xF0) >> 4));
        Assertions.assertEquals((int)1, (int)(transportByte & 0xF));
        int addrLength = byteBuf.getUnsignedShort(14);
        Assertions.assertEquals((int)216, (int)addrLength);
        int srcAddrEnd = byteBuf.forEachByte(16, 108, ByteProcessor.FIND_NUL);
        Assertions.assertEquals((Object)"/var/run/src.sock", (Object)byteBuf.slice(16, srcAddrEnd - 16).toString(CharsetUtil.US_ASCII));
        int dstAddrEnd = byteBuf.forEachByte(124, 108, ByteProcessor.FIND_NUL);
        Assertions.assertEquals((Object)"/var/run/dst.sock", (Object)byteBuf.slice(124, dstAddrEnd - 124).toString(CharsetUtil.US_ASCII));
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testTLVEncodeProxy() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        ArrayList<HAProxyTLV> tlvs = new ArrayList<HAProxyTLV>();
        ByteBuf helloWorld = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV alpnTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_ALPN, 1, helloWorld.copy());
        tlvs.add(alpnTlv);
        ByteBuf arbitrary = Unpooled.copiedBuffer((CharSequence)"an arbitrary string", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV authorityTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_AUTHORITY, 1, arbitrary.copy());
        tlvs.add(authorityTlv);
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443, tlvs);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((int)byteBuf.getUnsignedShort(14), (int)(byteBuf.readableBytes() - 16));
        ByteBuf tlv = byteBuf.skipBytes(28);
        Assertions.assertEquals((byte)alpnTlv.typeByteValue(), (byte)tlv.readByte());
        short bufLength = tlv.readShort();
        Assertions.assertEquals((int)helloWorld.array().length, (int)bufLength);
        Assertions.assertEquals((Object)helloWorld, (Object)tlv.readSlice((int)bufLength));
        Assertions.assertEquals((byte)authorityTlv.typeByteValue(), (byte)tlv.readByte());
        bufLength = tlv.readShort();
        Assertions.assertEquals((int)arbitrary.array().length, (int)bufLength);
        Assertions.assertEquals((Object)arbitrary, (Object)tlv.readSlice((int)bufLength));
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testSslTLVEncodeProxy() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        ArrayList<HAProxyTLV> tlvs = new ArrayList<HAProxyTLV>();
        ByteBuf helloWorld = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV alpnTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_ALPN, 1, helloWorld.copy());
        tlvs.add(alpnTlv);
        ByteBuf arbitrary = Unpooled.copiedBuffer((CharSequence)"an arbitrary string", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV authorityTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_AUTHORITY, 1, arbitrary.copy());
        tlvs.add(authorityTlv);
        ByteBuf sslContent = Unpooled.copiedBuffer((CharSequence)"some ssl content", (Charset)CharsetUtil.US_ASCII);
        HAProxySSLTLV haProxySSLTLV = new HAProxySSLTLV(1, 1, tlvs, sslContent.copy());
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443, Collections.singletonList(haProxySSLTLV));
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((int)byteBuf.getUnsignedShort(14), (int)(byteBuf.readableBytes() - 16));
        ByteBuf tlv = byteBuf.skipBytes(28);
        Assertions.assertEquals((byte)haProxySSLTLV.typeByteValue(), (byte)tlv.readByte());
        int bufLength = tlv.readUnsignedShort();
        Assertions.assertEquals((int)bufLength, (int)tlv.readableBytes());
        Assertions.assertEquals((int)1, (int)byteBuf.readByte());
        Assertions.assertEquals((int)1, (int)byteBuf.readInt());
        Assertions.assertEquals((byte)alpnTlv.typeByteValue(), (byte)tlv.readByte());
        bufLength = tlv.readShort();
        Assertions.assertEquals((int)helloWorld.array().length, (int)bufLength);
        Assertions.assertEquals((Object)helloWorld, (Object)tlv.readSlice(bufLength));
        Assertions.assertEquals((byte)authorityTlv.typeByteValue(), (byte)tlv.readByte());
        bufLength = tlv.readShort();
        Assertions.assertEquals((int)arbitrary.array().length, (int)bufLength);
        Assertions.assertEquals((Object)arbitrary, (Object)tlv.readSlice(bufLength));
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testEncodeLocalProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.LOCAL, HAProxyProxiedProtocol.UNKNOWN, null, null, 0, 0);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = new byte[12];
        byteBuf.readBytes(headerBytes);
        Assertions.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.readByte();
        Assertions.assertEquals((int)2, (int)((commandByte & 0xF0) >> 4));
        Assertions.assertEquals((int)0, (int)(commandByte & 0xF));
        byte transportByte = byteBuf.readByte();
        Assertions.assertEquals((int)0, (int)transportByte);
        int sourceAddrLength = byteBuf.readUnsignedShort();
        Assertions.assertEquals((int)0, (int)sourceAddrLength);
        Assertions.assertFalse((boolean)byteBuf.isReadable());
        byteBuf.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testInvalidIpV4Address() {
        String invalidIpv4Address = "192.168.0.1234";
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1234", "192.168.0.11", 56324, 443);
            }
        });
    }

    @Test
    public void testInvalidIpV6Address() {
        String invalidIpv6Address = "2001:0db8:85a3:0000:0000:8a2e:0370:73345";
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, "2001:0db8:85a3:0000:0000:8a2e:0370:73345", "1050:0:0:0:5:600:300c:326b", 56324, 443);
            }
        });
    }

    @Test
    public void testInvalidUnixAddress() {
        final String invalidUnixAddress = new String(new byte[109]);
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, invalidUnixAddress, "/var/run/dst.sock", 0, 0);
            }
        });
    }

    @Test
    public void testNullUnixAddress() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, null, null, 0, 0);
            }
        });
    }

    @Test
    public void testLongUnixAddress() {
        final String longUnixAddress = new String(new char[109]).replace("\u0000", "a");
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, "source", longUnixAddress, 0, 0);
            }
        });
    }

    @Test
    public void testInvalidUnixPort() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, "/var/run/src.sock", "/var/run/dst.sock", 80, 443);
            }
        });
    }
}

