/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.haproxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.ProtocolDetectionResult;
import io.netty.handler.codec.ProtocolDetectionState;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.codec.haproxy.HAProxySSLTLV;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HAProxyMessageDecoderTest {
    private EmbeddedChannel ch;

    @BeforeEach
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new HAProxyMessageDecoder()});
    }

    @Test
    public void testIPV4Decode() {
        int startChannels = this.ch.pipeline().names().size();
        String header = "PROXY TCP4 192.168.0.1 192.168.0.11 56324 443\r\n";
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)header, (Charset)CharsetUtil.US_ASCII)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V1, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TCP4, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"192.168.0.1", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"192.168.0.11", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)56324, (int)msg.sourcePort());
        Assertions.assertEquals((int)443, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testIPV6Decode() {
        int startChannels = this.ch.pipeline().names().size();
        String header = "PROXY TCP6 2001:0db8:85a3:0000:0000:8a2e:0370:7334 1050:0:0:0:5:600:300c:326b 56324 443\r\n";
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)header, (Charset)CharsetUtil.US_ASCII)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V1, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TCP6, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"2001:0db8:85a3:0000:0000:8a2e:0370:7334", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"1050:0:0:0:5:600:300c:326b", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)56324, (int)msg.sourcePort());
        Assertions.assertEquals((int)443, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testUnknownProtocolDecode() {
        int startChannels = this.ch.pipeline().names().size();
        String header = "PROXY UNKNOWN 192.168.0.1 192.168.0.11 56324 443\r\n";
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)header, (Charset)CharsetUtil.US_ASCII)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V1, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.UNKNOWN, (Object)msg.proxiedProtocol());
        Assertions.assertNull((Object)msg.sourceAddress());
        Assertions.assertNull((Object)msg.destinationAddress());
        Assertions.assertEquals((int)0, (int)msg.sourcePort());
        Assertions.assertEquals((int)0, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testV1NoUDP() {
        String header = "PROXY UDP4 192.168.0.1 192.168.0.11 56324 443\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY UDP4 192.168.0.1 192.168.0.11 56324 443\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testInvalidPort() {
        String header = "PROXY TCP4 192.168.0.1 192.168.0.11 80000 443\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 192.168.0.1 192.168.0.11 80000 443\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testInvalidIPV4Address() {
        String header = "PROXY TCP4 299.168.0.1 192.168.0.11 56324 443\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 299.168.0.1 192.168.0.11 56324 443\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testInvalidIPV6Address() {
        String header = "PROXY TCP6 r001:0db8:85a3:0000:0000:8a2e:0370:7334 1050:0:0:0:5:600:300c:326b 56324 443\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP6 r001:0db8:85a3:0000:0000:8a2e:0370:7334 1050:0:0:0:5:600:300c:326b 56324 443\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testInvalidProtocol() {
        String header = "PROXY TCP7 192.168.0.1 192.168.0.11 56324 443\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP7 192.168.0.1 192.168.0.11 56324 443\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testMissingParams() {
        String header = "PROXY TCP4 192.168.0.1 192.168.0.11 56324\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 192.168.0.1 192.168.0.11 56324\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testTooManyParams() {
        String header = "PROXY TCP4 192.168.0.1 192.168.0.11 56324 443 123\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 192.168.0.1 192.168.0.11 56324 443 123\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testInvalidCommand() {
        String header = "PING TCP4 192.168.0.1 192.168.0.11 56324 443\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PING TCP4 192.168.0.1 192.168.0.11 56324 443\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testInvalidEOL() {
        String header = "PROXY TCP4 192.168.0.1 192.168.0.11 56324 443\nGET / HTTP/1.1\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 192.168.0.1 192.168.0.11 56324 443\nGET / HTTP/1.1\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    @Test
    public void testHeaderTooLong() {
        String header = "PROXY TCP4 192.168.0.1 192.168.0.11 56324 00000000000000000000000000000000000000000000000000000000000000000443\r\n";
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 192.168.0.1 192.168.0.11 56324 00000000000000000000000000000000000000000000000000000000000000000443\r\n", (Charset)CharsetUtil.US_ASCII)});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailSlowHeaderTooLong() {
        final EmbeddedChannel slowFailCh = new EmbeddedChannel(new ChannelHandler[]{new HAProxyMessageDecoder(false)});
        try {
            String headerPart1 = "PROXY TCP4 192.168.0.1 192.168.0.11 56324 000000000000000000000000000000000000000000000000000000000000000000000443";
            Assertions.assertFalse((boolean)slowFailCh.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)headerPart1, (Charset)CharsetUtil.US_ASCII)}));
            String headerPart2 = "more header data";
            Assertions.assertFalse((boolean)slowFailCh.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)headerPart2, (Charset)CharsetUtil.US_ASCII)}));
            String headerPart3 = "end of header\r\n";
            int discarded = headerPart1.length() + headerPart2.length() + "end of header\r\n".length() - 2;
            Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

                public void execute() {
                    slowFailCh.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"end of header\r\n", (Charset)CharsetUtil.US_ASCII)});
                }
            }, (String)("over " + discarded));
        }
        finally {
            Assertions.assertFalse((boolean)slowFailCh.finishAndReleaseAll());
        }
    }

    @Test
    public void testFailFastHeaderTooLong() {
        final EmbeddedChannel fastFailCh = new EmbeddedChannel(new ChannelHandler[]{new HAProxyMessageDecoder(true)});
        try {
            String headerPart1 = "PROXY TCP4 192.168.0.1 192.168.0.11 56324 000000000000000000000000000000000000000000000000000000000000000000000443";
            Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

                public void execute() {
                    fastFailCh.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 192.168.0.1 192.168.0.11 56324 000000000000000000000000000000000000000000000000000000000000000000000443", (Charset)CharsetUtil.US_ASCII)});
                }
            }, (String)("over " + "PROXY TCP4 192.168.0.1 192.168.0.11 56324 000000000000000000000000000000000000000000000000000000000000000000000443".length()));
        }
        finally {
            Assertions.assertFalse((boolean)fastFailCh.finishAndReleaseAll());
        }
    }

    @Test
    public void testIncompleteHeader() {
        String header = "PROXY TCP4 192.168.0.1 192.168.0.11 56324";
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)header, (Charset)CharsetUtil.US_ASCII)});
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
    }

    @Test
    public void testCloseOnInvalid() {
        ChannelFuture closeFuture = this.ch.closeFuture();
        String header = "GET / HTTP/1.1\r\n";
        try {
            this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)header, (Charset)CharsetUtil.US_ASCII)});
        }
        catch (HAProxyProtocolException hAProxyProtocolException) {
            // empty catch block
        }
        boolean isComplete = closeFuture.awaitUninterruptibly(5000L);
        if (!(isComplete && closeFuture.isDone() && closeFuture.isSuccess())) {
            Assertions.fail((String)"Expected channel close");
        }
    }

    @Test
    public void testTransportProtocolAndAddressFamily() {
        byte unknown = HAProxyProxiedProtocol.UNKNOWN.byteValue();
        byte tcp4 = HAProxyProxiedProtocol.TCP4.byteValue();
        byte tcp6 = HAProxyProxiedProtocol.TCP6.byteValue();
        byte udp4 = HAProxyProxiedProtocol.UDP4.byteValue();
        byte udp6 = HAProxyProxiedProtocol.UDP6.byteValue();
        byte unix_stream = HAProxyProxiedProtocol.UNIX_STREAM.byteValue();
        byte unix_dgram = HAProxyProxiedProtocol.UNIX_DGRAM.byteValue();
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TransportProtocol.UNSPEC, (Object)HAProxyProxiedProtocol.TransportProtocol.valueOf((byte)unknown));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TransportProtocol.STREAM, (Object)HAProxyProxiedProtocol.TransportProtocol.valueOf((byte)tcp4));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TransportProtocol.STREAM, (Object)HAProxyProxiedProtocol.TransportProtocol.valueOf((byte)tcp6));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TransportProtocol.STREAM, (Object)HAProxyProxiedProtocol.TransportProtocol.valueOf((byte)unix_stream));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TransportProtocol.DGRAM, (Object)HAProxyProxiedProtocol.TransportProtocol.valueOf((byte)udp4));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TransportProtocol.DGRAM, (Object)HAProxyProxiedProtocol.TransportProtocol.valueOf((byte)udp6));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TransportProtocol.DGRAM, (Object)HAProxyProxiedProtocol.TransportProtocol.valueOf((byte)unix_dgram));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.AddressFamily.AF_UNSPEC, (Object)HAProxyProxiedProtocol.AddressFamily.valueOf((byte)unknown));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.AddressFamily.AF_IPv4, (Object)HAProxyProxiedProtocol.AddressFamily.valueOf((byte)tcp4));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.AddressFamily.AF_IPv4, (Object)HAProxyProxiedProtocol.AddressFamily.valueOf((byte)udp4));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.AddressFamily.AF_IPv6, (Object)HAProxyProxiedProtocol.AddressFamily.valueOf((byte)tcp6));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.AddressFamily.AF_IPv6, (Object)HAProxyProxiedProtocol.AddressFamily.valueOf((byte)udp6));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.AddressFamily.AF_UNIX, (Object)HAProxyProxiedProtocol.AddressFamily.valueOf((byte)unix_stream));
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.AddressFamily.AF_UNIX, (Object)HAProxyProxiedProtocol.AddressFamily.valueOf((byte)unix_dgram));
    }

    @Test
    public void testV2IPV4Decode() {
        byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 17, 0, 12, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4, 1, -69};
        int startChannels = this.ch.pipeline().names().size();
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TCP4, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"192.168.0.1", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"192.168.0.11", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)56324, (int)msg.sourcePort());
        Assertions.assertEquals((int)443, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testV2UDPDecode() {
        byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 18, 0, 12, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4, 1, -69};
        int startChannels = this.ch.pipeline().names().size();
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.UDP4, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"192.168.0.1", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"192.168.0.11", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)56324, (int)msg.sourcePort());
        Assertions.assertEquals((int)443, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testv2IPV6Decode() {
        byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 33, 0, 36, 32, 1, 13, -72, -123, -93, 0, 0, 0, 0, -118, 46, 3, 112, 115, 52, 16, 80, 0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 48, 12, 50, 107, -36, 4, 1, -69};
        int startChannels = this.ch.pipeline().names().size();
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TCP6, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"2001:db8:85a3:0:0:8a2e:370:7334", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"1050:0:0:0:5:600:300c:326b", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)56324, (int)msg.sourcePort());
        Assertions.assertEquals((int)443, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testv2UnixDecode() {
        byte[] header = new byte[232];
        header[0] = 13;
        header[1] = 10;
        header[2] = 13;
        header[3] = 10;
        header[4] = 0;
        header[5] = 13;
        header[6] = 10;
        header[7] = 81;
        header[8] = 85;
        header[9] = 73;
        header[10] = 84;
        header[11] = 10;
        header[12] = 33;
        header[13] = 49;
        header[14] = 0;
        header[15] = -40;
        header[16] = 47;
        header[17] = 118;
        header[18] = 97;
        header[19] = 114;
        header[20] = 47;
        header[21] = 114;
        header[22] = 117;
        header[23] = 110;
        header[24] = 47;
        header[25] = 115;
        header[26] = 114;
        header[27] = 99;
        header[28] = 46;
        header[29] = 115;
        header[30] = 111;
        header[31] = 99;
        header[32] = 107;
        header[33] = 0;
        header[124] = 47;
        header[125] = 118;
        header[126] = 97;
        header[127] = 114;
        header[128] = 47;
        header[129] = 114;
        header[130] = 117;
        header[131] = 110;
        header[132] = 47;
        header[133] = 100;
        header[134] = 101;
        header[135] = 115;
        header[136] = 116;
        header[137] = 46;
        header[138] = 115;
        header[139] = 111;
        header[140] = 99;
        header[141] = 107;
        header[142] = 0;
        int startChannels = this.ch.pipeline().names().size();
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.UNIX_STREAM, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"/var/run/src.sock", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"/var/run/dest.sock", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)0, (int)msg.sourcePort());
        Assertions.assertEquals((int)0, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testV2LocalProtocolDecode() {
        byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 32, 0, 0, 12, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4, 1, -69};
        int startChannels = this.ch.pipeline().names().size();
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.LOCAL, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.UNKNOWN, (Object)msg.proxiedProtocol());
        Assertions.assertNull((Object)msg.sourceAddress());
        Assertions.assertNull((Object)msg.destinationAddress());
        Assertions.assertEquals((int)0, (int)msg.sourcePort());
        Assertions.assertEquals((int)0, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testV2UnknownProtocolDecode() {
        byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 0, 0, 12, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4, 1, -69};
        int startChannels = this.ch.pipeline().names().size();
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.UNKNOWN, (Object)msg.proxiedProtocol());
        Assertions.assertNull((Object)msg.sourceAddress());
        Assertions.assertNull((Object)msg.destinationAddress());
        Assertions.assertEquals((int)0, (int)msg.sourcePort());
        Assertions.assertEquals((int)0, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testV2WithSslTLVs() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new HAProxyMessageDecoder()});
        byte[] bytes = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 17, 0, 35, 127, 0, 0, 1, 127, 0, 0, 1, -55, -90, 7, 89, 32, 0, 20, 5, 0, 0, 0, 0, 33, 0, 5, 84, 76, 83, 118, 49, 34, 0, 4, 76, 69, 65, 70};
        int startChannels = this.ch.pipeline().names().size();
        Assertions.assertTrue((boolean)this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.TCP4, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)51622, (int)msg.sourcePort());
        Assertions.assertEquals((int)1881, (int)msg.destinationPort());
        List tlvs = msg.tlvs();
        Assertions.assertEquals((int)3, (int)tlvs.size());
        HAProxyTLV firstTlv = (HAProxyTLV)tlvs.get(0);
        Assertions.assertEquals((Object)HAProxyTLV.Type.PP2_TYPE_SSL, (Object)firstTlv.type());
        HAProxySSLTLV sslTlv = (HAProxySSLTLV)firstTlv;
        Assertions.assertEquals((int)0, (int)sslTlv.verify());
        Assertions.assertTrue((boolean)sslTlv.isPP2ClientSSL());
        Assertions.assertTrue((boolean)sslTlv.isPP2ClientCertSess());
        Assertions.assertFalse((boolean)sslTlv.isPP2ClientCertConn());
        HAProxyTLV secondTlv = (HAProxyTLV)tlvs.get(1);
        Assertions.assertEquals((Object)HAProxyTLV.Type.PP2_TYPE_SSL_VERSION, (Object)secondTlv.type());
        ByteBuf secondContentBuf = secondTlv.content();
        byte[] secondContent = new byte[secondContentBuf.readableBytes()];
        secondContentBuf.readBytes(secondContent);
        Assertions.assertArrayEquals((byte[])"TLSv1".getBytes(CharsetUtil.US_ASCII), (byte[])secondContent);
        HAProxyTLV thirdTLV = (HAProxyTLV)tlvs.get(2);
        Assertions.assertEquals((Object)HAProxyTLV.Type.PP2_TYPE_SSL_CN, (Object)thirdTLV.type());
        ByteBuf thirdContentBuf = thirdTLV.content();
        byte[] thirdContent = new byte[thirdContentBuf.readableBytes()];
        thirdContentBuf.readBytes(thirdContent);
        Assertions.assertArrayEquals((byte[])"LEAF".getBytes(CharsetUtil.US_ASCII), (byte[])thirdContent);
        Assertions.assertTrue((boolean)sslTlv.encapsulatedTLVs().contains(secondTlv));
        Assertions.assertTrue((boolean)sslTlv.encapsulatedTLVs().contains(thirdTLV));
        Assertions.assertTrue((0 < firstTlv.refCnt() ? 1 : 0) != 0);
        Assertions.assertTrue((0 < secondTlv.refCnt() ? 1 : 0) != 0);
        Assertions.assertTrue((0 < thirdTLV.refCnt() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)msg.release());
        Assertions.assertEquals((int)0, (int)firstTlv.refCnt());
        Assertions.assertEquals((int)0, (int)secondTlv.refCnt());
        Assertions.assertEquals((int)0, (int)thirdTLV.refCnt());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
    }

    @Test
    public void testReleaseHAProxyMessage() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new HAProxyMessageDecoder()});
        byte[] bytes = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 17, 0, 35, 127, 0, 0, 1, 127, 0, 0, 1, -55, -90, 7, 89, 32, 0, 20, 5, 0, 0, 0, 0, 33, 0, 5, 84, 76, 83, 118, 49, 34, 0, 4, 76, 69, 65, 70};
        int startChannels = this.ch.pipeline().names().size();
        Assertions.assertTrue((boolean)this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        List tlvs = msg.tlvs();
        Assertions.assertEquals((int)3, (int)tlvs.size());
        Assertions.assertEquals((int)1, (int)msg.refCnt());
        for (HAProxyTLV tlv : tlvs) {
            Assertions.assertEquals((int)3, (int)tlv.refCnt());
        }
        msg.retain();
        Assertions.assertEquals((int)2, (int)msg.refCnt());
        for (HAProxyTLV tlv : tlvs) {
            Assertions.assertEquals((int)3, (int)tlv.refCnt());
        }
        msg.release();
        Assertions.assertEquals((int)1, (int)msg.refCnt());
        for (HAProxyTLV tlv : tlvs) {
            Assertions.assertEquals((int)3, (int)tlv.refCnt());
        }
        msg.release();
        Assertions.assertEquals((int)0, (int)msg.refCnt());
        for (HAProxyTLV tlv : tlvs) {
            Assertions.assertEquals((int)0, (int)tlv.refCnt());
        }
    }

    @Test
    public void testV2WithTLV() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new HAProxyMessageDecoder(4)});
        byte[] header = new byte[236];
        header[0] = 13;
        header[1] = 10;
        header[2] = 13;
        header[3] = 10;
        header[4] = 0;
        header[5] = 13;
        header[6] = 10;
        header[7] = 81;
        header[8] = 85;
        header[9] = 73;
        header[10] = 84;
        header[11] = 10;
        header[12] = 33;
        header[13] = 49;
        header[14] = 0;
        header[15] = -36;
        header[16] = 47;
        header[17] = 118;
        header[18] = 97;
        header[19] = 114;
        header[20] = 47;
        header[21] = 114;
        header[22] = 117;
        header[23] = 110;
        header[24] = 47;
        header[25] = 115;
        header[26] = 114;
        header[27] = 99;
        header[28] = 46;
        header[29] = 115;
        header[30] = 111;
        header[31] = 99;
        header[32] = 107;
        header[33] = 0;
        header[124] = 47;
        header[125] = 118;
        header[126] = 97;
        header[127] = 114;
        header[128] = 47;
        header[129] = 114;
        header[130] = 117;
        header[131] = 110;
        header[132] = 47;
        header[133] = 100;
        header[134] = 101;
        header[135] = 115;
        header[136] = 116;
        header[137] = 46;
        header[138] = 115;
        header[139] = 111;
        header[140] = 99;
        header[141] = 107;
        header[142] = 0;
        header[232] = 1;
        header[233] = 0;
        header[234] = 1;
        header[235] = 1;
        int startChannels = this.ch.pipeline().names().size();
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Object msgObj = this.ch.readInbound();
        Assertions.assertEquals((int)(startChannels - 1), (int)this.ch.pipeline().names().size());
        Assertions.assertTrue((boolean)(msgObj instanceof HAProxyMessage));
        HAProxyMessage msg = (HAProxyMessage)msgObj;
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)msg.protocolVersion());
        Assertions.assertEquals((Object)HAProxyCommand.PROXY, (Object)msg.command());
        Assertions.assertEquals((Object)HAProxyProxiedProtocol.UNIX_STREAM, (Object)msg.proxiedProtocol());
        Assertions.assertEquals((Object)"/var/run/src.sock", (Object)msg.sourceAddress());
        Assertions.assertEquals((Object)"/var/run/dest.sock", (Object)msg.destinationAddress());
        Assertions.assertEquals((int)0, (int)msg.sourcePort());
        Assertions.assertEquals((int)0, (int)msg.destinationPort());
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
        Assertions.assertTrue((boolean)msg.release());
    }

    @Test
    public void testV2InvalidProtocol() {
        final byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 65, 0, 12, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4, 1, -69};
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
            }
        });
    }

    @Test
    public void testV2MissingParams() {
        final byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, 17, 0, 10, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4};
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
            }
        });
    }

    @Test
    public void testV2InvalidCommand() {
        final byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 34, 17, 0, 12, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4, 1, -69};
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
            }
        });
    }

    @Test
    public void testV2InvalidVersion() {
        final byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 49, 17, 0, 12, -64, -88, 0, 1, -64, -88, 0, 11, -36, 4, 1, -69};
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
            }
        });
    }

    @Test
    public void testV2HeaderTooLong() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new HAProxyMessageDecoder(0)});
        final byte[] header = new byte[248];
        header[0] = 13;
        header[1] = 10;
        header[2] = 13;
        header[3] = 10;
        header[4] = 0;
        header[5] = 13;
        header[6] = 10;
        header[7] = 81;
        header[8] = 85;
        header[9] = 73;
        header[10] = 84;
        header[11] = 10;
        header[12] = 33;
        header[13] = 17;
        header[14] = 0;
        header[15] = -24;
        header[16] = -64;
        header[17] = -88;
        header[18] = 0;
        header[19] = 1;
        header[20] = -64;
        header[21] = -88;
        header[22] = 0;
        header[23] = 11;
        header[24] = -36;
        header[25] = 4;
        header[26] = 1;
        header[27] = -69;
        Assertions.assertThrows(HAProxyProtocolException.class, (Executable)new Executable(){

            public void execute() {
                HAProxyMessageDecoderTest.this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
            }
        });
    }

    @Test
    public void testV2IncompleteHeader() {
        byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33};
        this.ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header)});
        Assertions.assertNull((Object)this.ch.readInbound());
        Assertions.assertFalse((boolean)this.ch.finish());
    }

    @Test
    public void testDetectProtocol() {
        ByteBuf validHeaderV1 = Unpooled.copiedBuffer((CharSequence)"PROXY TCP4 192.168.0.1 192.168.0.11 56324 443\r\n", (Charset)CharsetUtil.US_ASCII);
        ProtocolDetectionResult result = HAProxyMessageDecoder.detectProtocol((ByteBuf)validHeaderV1);
        Assertions.assertEquals((Object)ProtocolDetectionState.DETECTED, (Object)result.state());
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V1, (Object)result.detectedProtocol());
        validHeaderV1.release();
        ByteBuf invalidHeader = Unpooled.copiedBuffer((CharSequence)"Invalid header", (Charset)CharsetUtil.US_ASCII);
        result = HAProxyMessageDecoder.detectProtocol((ByteBuf)invalidHeader);
        Assertions.assertEquals((Object)ProtocolDetectionState.INVALID, (Object)result.state());
        Assertions.assertNull((Object)result.detectedProtocol());
        invalidHeader.release();
        ByteBuf validHeaderV2 = Unpooled.buffer();
        validHeaderV2.writeByte(13);
        validHeaderV2.writeByte(10);
        validHeaderV2.writeByte(13);
        validHeaderV2.writeByte(10);
        validHeaderV2.writeByte(0);
        validHeaderV2.writeByte(13);
        validHeaderV2.writeByte(10);
        validHeaderV2.writeByte(81);
        validHeaderV2.writeByte(85);
        validHeaderV2.writeByte(73);
        validHeaderV2.writeByte(84);
        validHeaderV2.writeByte(10);
        result = HAProxyMessageDecoder.detectProtocol((ByteBuf)validHeaderV2);
        Assertions.assertEquals((Object)ProtocolDetectionState.DETECTED, (Object)result.state());
        Assertions.assertEquals((Object)HAProxyProtocolVersion.V2, (Object)result.detectedProtocol());
        validHeaderV2.release();
        ByteBuf incompleteHeader = Unpooled.buffer();
        incompleteHeader.writeByte(13);
        incompleteHeader.writeByte(10);
        incompleteHeader.writeByte(13);
        incompleteHeader.writeByte(10);
        incompleteHeader.writeByte(0);
        incompleteHeader.writeByte(13);
        incompleteHeader.writeByte(10);
        result = HAProxyMessageDecoder.detectProtocol((ByteBuf)incompleteHeader);
        Assertions.assertEquals((Object)ProtocolDetectionState.NEEDS_MORE_DATA, (Object)result.state());
        Assertions.assertNull((Object)result.detectedProtocol());
        incompleteHeader.release();
    }
}

