/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.haproxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HAProxyIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicCase() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference msgHolder = new AtomicReference();
        LocalAddress localAddress = new LocalAddress("HAProxyIntegrationTest");
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.channel(LocalServerChannel.class)).group((EventLoopGroup)group).childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HAProxyMessage>(){

                    protected void channelRead0(ChannelHandlerContext ctx, HAProxyMessage msg) throws Exception {
                        msgHolder.set(msg.retain());
                        latch.countDown();
                    }
                }});
            }
        });
        Channel serverChannel = sb.bind((SocketAddress)localAddress).sync().channel();
        Bootstrap b = new Bootstrap();
        Channel clientChannel = ((Bootstrap)((Bootstrap)((Bootstrap)b.channel(LocalChannel.class)).handler((ChannelHandler)HAProxyMessageEncoder.INSTANCE)).group((EventLoopGroup)group)).connect((SocketAddress)localAddress).sync().channel();
        try {
            HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443);
            clientChannel.writeAndFlush((Object)message).sync();
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            HAProxyMessage readMessage = (HAProxyMessage)msgHolder.get();
            Assertions.assertEquals((Object)message.protocolVersion(), (Object)readMessage.protocolVersion());
            Assertions.assertEquals((Object)message.command(), (Object)readMessage.command());
            Assertions.assertEquals((Object)message.proxiedProtocol(), (Object)readMessage.proxiedProtocol());
            Assertions.assertEquals((Object)message.sourceAddress(), (Object)readMessage.sourceAddress());
            Assertions.assertEquals((Object)message.destinationAddress(), (Object)readMessage.destinationAddress());
            Assertions.assertEquals((int)message.sourcePort(), (int)readMessage.sourcePort());
            Assertions.assertEquals((int)message.destinationPort(), (int)readMessage.destinationPort());
            readMessage.release();
        }
        finally {
            clientChannel.close().sync();
            serverChannel.close().sync();
            group.shutdownGracefully().sync();
        }
    }
}

