/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.util;

import com.amazonaws.services.lambda.runtime.api.client.util.EnvReader;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class EnvWriter
implements AutoCloseable {
    private Map<String, String> envMap;
    private final Field field;

    public EnvWriter(EnvReader envReader) {
        Map<String, String> env = envReader.getEnv();
        try {
            Map map;
            this.field = env.getClass().getDeclaredField("m");
            this.field.setAccessible(true);
            this.envMap = map = (Map)this.field.get(env);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.field != null) {
            this.field.setAccessible(false);
        }
    }

    public void modifyEnv(Consumer<Map<String, String>> modifier) {
        modifier.accept(this.envMap);
    }

    public void unsetLambdaInternalEnv() {
        this.modifyEnv(env -> env.remove("_LAMBDA_TELEMETRY_LOG_FD"));
    }

    public void setupEnvironmentCredentials() {
        this.modifyEnv(env -> {
            this.removeIfEmpty((Map<String, String>)env, "AWS_ACCESS_KEY_ID");
            this.removeIfEmpty((Map<String, String>)env, "AWS_SECRET_ACCESS_KEY");
            this.removeIfEmpty((Map<String, String>)env, "AWS_SESSION_TOKEN");
            this.addIfNotNull((Map<String, String>)env, "AWS_ACCESS_KEY", (String)env.get("AWS_ACCESS_KEY_ID"));
            this.addIfNotNull((Map<String, String>)env, "AWS_SECRET_KEY", (String)env.get("AWS_SECRET_ACCESS_KEY"));
        });
    }

    public void setupAwsExecutionEnv() {
        this.executionEnvironmentForJavaVersion().ifPresent(val -> this.modifyEnv(env -> env.put("AWS_EXECUTION_ENV", val)));
    }

    private Optional<String> executionEnvironmentForJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.8")) {
            return Optional.of("AWS_Lambda_java8");
        }
        if (version.startsWith("11")) {
            return Optional.of("AWS_Lambda_java11");
        }
        return Optional.empty();
    }

    private void addIfNotNull(Map<String, String> env, String key, String value) {
        if (value != null && !value.isEmpty()) {
            env.put(key, value);
        }
    }

    private void removeIfEmpty(Map<String, String> env, String key) {
        env.computeIfPresent(key, (k, v) -> v.isEmpty() ? null : v);
    }
}

