/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

class CustomerClassLoader
extends URLClassLoader {
    private static final Comparator<String> LEXICAL_SORT_ORDER = Comparator.comparing(String::toString);

    CustomerClassLoader(String taskRoot, String optRoot, ClassLoader parent) throws IOException {
        super(CustomerClassLoader.getUrls(taskRoot, optRoot), parent);
    }

    private static URL[] getUrls(String taskRoot, String optRoot) throws MalformedURLException {
        File taskDir = new File(taskRoot + "/");
        ArrayList<URL> res = new ArrayList<URL>();
        res.add(CustomerClassLoader.newURL(taskDir, ""));
        CustomerClassLoader.appendJars(new File(taskRoot + "/lib"), res);
        CustomerClassLoader.appendJars(new File(optRoot + "/lib"), res);
        return res.toArray(new URL[res.size()]);
    }

    private static void appendJars(File dir, List<URL> result) throws MalformedURLException {
        if (!dir.isDirectory()) {
            return;
        }
        String[] names = dir.list();
        if (names == null) {
            return;
        }
        Arrays.sort(names, LEXICAL_SORT_ORDER);
        for (String path : names) {
            if (!path.endsWith(".jar")) continue;
            result.add(CustomerClassLoader.newURL(dir, path));
        }
    }

    private static URL newURL(File parent, String path) throws MalformedURLException {
        return new URL("file", null, -1, parent.getPath() + "/" + path);
    }
}

