/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.plugin.scripts.AbstractScript;
import io.kestra.plugin.scripts.ScriptEngineService;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Optional;
import javax.script.Bindings;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Transform ion format file from kestra with a groovy script.", description="This allow you to transform the data previouly loaded by kestra as you need.\n\nTake a ion format file from kestra and iterate row per row.\nEach row will populate a `row` global variable, you need to alter this variable that will be saved on output file.\nif you set the `row` to `null`, the row will be skipped\n")
public abstract class FileTransform
extends AbstractScript
implements RunnableTask<Output> {
    @NotNull
    @Schema(title="Source file URI", description="The file must an ion file generated by kestra")
    @PluginProperty(dynamic=true)
    private String from;

    protected Output run(RunContext runContext, String engineName) throws Exception {
        URI from = new URI(runContext.render(this.from));
        File tempFile = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + "_", ".trs");
        ScriptEngineService.CompiledScript scripts = ScriptEngineService.scripts(runContext, engineName, this.generateScript(runContext));
        try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(runContext.uriToInputStream(from)));
             FileOutputStream output = new FileOutputStream(tempFile);){
            Flowable flowable = Flowable.create((FlowableOnSubscribe)FileSerde.reader((BufferedReader)inputStream), (BackpressureStrategy)BackpressureStrategy.BUFFER).map(this.convert(scripts)).filter(Optional::isPresent).map(Optional::get).doOnNext(row -> FileSerde.write((OutputStream)output, (Object)row));
            Single count = flowable.count();
            Long lineCount = (Long)count.blockingGet();
            runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)lineCount, (String[])new String[0]));
            output.flush();
        }
        return Output.builder().uri(runContext.putTempFile(tempFile)).build();
    }

    protected Function<Object, Optional<Object>> convert(ScriptEngineService.CompiledScript script) {
        return row -> {
            Bindings bindings = script.getBindings();
            bindings.put("row", row);
            script.getScript().eval(bindings);
            return Optional.ofNullable(script.getBindings().get("row"));
        };
    }

    @Generated
    protected FileTransform(FileTransformBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
    }

    @Override
    @Generated
    public String toString() {
        return "FileTransform(super=" + super.toString() + ", from=" + this.getFrom() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileTransform)) {
            return false;
        }
        FileTransform other = (FileTransform)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileTransform;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public FileTransform() {
    }

    @Generated
    public static abstract class FileTransformBuilder<C extends FileTransform, B extends FileTransformBuilder<C, B>>
    extends AbstractScript.AbstractScriptBuilder<C, B> {
        @Generated
        private String from;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "FileTransform.FileTransformBuilder(super=" + super.toString() + ", from=" + this.from + ")";
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="URI of a temporary result file", description="The file will be serialized as ion file.")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "FileTransform.Output.OutputBuilder(uri=" + this.uri + ")";
            }
        }
    }
}

