/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.postgresql;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.postgresql.AbstractCopy;
import io.kestra.plugin.jdbc.postgresql.PostgresConnectionInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.net.URI;
import java.nio.file.Path;
import java.sql.Connection;
import lombok.Generated;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;

@Schema(title="Copy from a file to PostgreSQL table")
@Plugin(examples={@Example(title="Export a csv or tsv from a postgres table or query", code={"url: jdbc:postgresql://127.0.0.1:56982/", "username: postgres", "password: pg_passwd", "format: CSV", "sql: SELECT 1 AS int, 't'::bool AS bool UNION SELECT 2 AS int, 'f'::bool AS bool", "header: true", "delimiter: \"\t\""})})
public class CopyOut
extends AbstractCopy
implements RunnableTask<Output>,
PostgresConnectionInterface {
    @Schema(title="A SELECT, VALUES, INSERT, UPDATE or DELETE command whose results are to be copied.", description="For INSERT, UPDATE and DELETE queries a RETURNING clause must be provided, and the target relation must not have a conditional rule, nor an ALSO rule, nor an INSTEAD rule that expands to multiple statements.")
    @PluginProperty(dynamic=true)
    protected String sql;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        Path path = runContext.tempFile();
        try (Connection connection = this.connection(runContext);){
            Output output;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(path.toFile()));){
                BaseConnection pgConnection = connection.unwrap(BaseConnection.class);
                CopyManager copyManager = new CopyManager(pgConnection);
                String sql = this.query(runContext, this.sql, "TO STDOUT");
                logger.debug("Starting query: {}", (Object)sql);
                long rowsAffected = copyManager.copyOut(sql, bufferedWriter);
                runContext.metric((AbstractMetricEntry)Counter.of((String)"rows", (Long)rowsAffected, (String[])new String[0]));
                bufferedWriter.flush();
                output = Output.builder().uri(runContext.putTempFile(path.toFile())).rowCount(rowsAffected).build();
            }
            return output;
        }
    }

    @Generated
    protected CopyOut(CopyOutBuilder<?, ?> b) {
        super((AbstractCopy.AbstractCopyBuilder<?, ?>)b);
        this.sql = b.sql;
    }

    @Generated
    public static CopyOutBuilder<?, ?> builder() {
        return new CopyOutBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "CopyOut(super=" + super.toString() + ", sql=" + this.getSql() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyOut)) {
            return false;
        }
        CopyOut other = (CopyOut)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CopyOut;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public CopyOut() {
    }

    @Generated
    private static final class CopyOutBuilderImpl
    extends CopyOutBuilder<CopyOut, CopyOutBuilderImpl> {
        @Generated
        private CopyOutBuilderImpl() {
        }

        @Override
        @Generated
        protected CopyOutBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CopyOut build() {
            return new CopyOut(this);
        }
    }

    @Generated
    public static abstract class CopyOutBuilder<C extends CopyOut, B extends CopyOutBuilder<C, B>>
    extends AbstractCopy.AbstractCopyBuilder<C, B> {
        @Generated
        private String sql;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "CopyOut.CopyOutBuilder(super=" + super.toString() + ", sql=" + this.sql + ")";
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The url of the result file on kestra storage")
        private final URI uri;
        @Schema(title="The rows count from this `COPY`")
        private final Long rowCount;

        @ConstructorProperties(value={"uri", "rowCount"})
        @Generated
        Output(URI uri, Long rowCount) {
            this.uri = uri;
            this.rowCount = rowCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Long getRowCount() {
            return this.rowCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;
            @Generated
            private Long rowCount;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder rowCount(Long rowCount) {
                this.rowCount = rowCount;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri, this.rowCount);
            }

            @Generated
            public String toString() {
                return "CopyOut.Output.OutputBuilder(uri=" + this.uri + ", rowCount=" + this.rowCount + ")";
            }
        }
    }
}

