/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.postgresql;

import io.kestra.core.models.annotations.PluginProperty;
import io.swagger.v3.oas.annotations.media.Schema;

public interface PostgresConnectionInterface {
    @Schema(title="Is the connection ssl")
    @PluginProperty(dynamic=false)
    public Boolean getSsl();

    @Schema(title="The ssl mode")
    @PluginProperty(dynamic=false)
    public SslMode getSslMode();

    @Schema(title="The ssl root cert", description="Must be a PEM encoded certificate")
    @PluginProperty(dynamic=true)
    public String getSslRootCert();

    @Schema(title="The ssl cert", description="Must be a PEM encoded certificate")
    @PluginProperty(dynamic=true)
    public String getSslCert();

    @Schema(title="The ssl key", description="Must be a PEM encoded key")
    @PluginProperty(dynamic=true)
    public String getSslKey();

    @Schema(title="The ssl key password")
    @PluginProperty(dynamic=true)
    public String getSslKeyPassword();

    public static enum SslMode {
        DISABLE,
        ALLOW,
        PREFER,
        REQUIRE,
        VERIFY_CA,
        VERIFY_FULL;

    }
}

