/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.postgresql;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.postgresql.PostgresCellConverter;
import io.kestra.plugin.jdbc.postgresql.PostgresConnectionInterface;
import io.kestra.plugin.jdbc.postgresql.PostgresService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Properties;
import lombok.Generated;
import org.postgresql.Driver;

@Schema(title="PostgresSQL Query Task", description="Currently supported types are the following ones : \n - serial\n - boolean\n - char(4)\n - varchar(n)\n - text\n - smallint\n - bigint\n - float(n)\n - double precision\n - real\n - numeric\n - date\n - time\n - timez / time with time zone (avoid this type as it can lead to some gap. See <a href=\"https://www.postgresql.org/message-id/4C968069.4050801@opencloud.com/\">this PostgreSQL issue</a>)\n - timestamp\n - timestampz / timestamp with time zone\n - interval\n - integer[]\n - text[][] (ie. array of array ... it may be of another supported type)\n - json\n - bytea")
@Plugin(examples={@Example(full=true, title="Execute a query and fetch results on another task to update another table", code={"tasks:", "- id: update", "  type: io.kestra.plugin.jdbc.postgresql.Query", "  url: jdbc:postgresql://127.0.0.1:56982/", "  username: postgres", "  password: pg_passwd", "  sql: select concert_id, available, a, b, c, d, play_time, library_record, floatn_test, double_test, real_test, numeric_test, date_type, time_type, timez_type, timestamp_type, timestampz_type, interval_type, pay_by_quarter, schedule, json_type, blob_type from pgsql_types", "  fetch: true", "- id: use-fetched-data", "  type: io.kestra.plugin.jdbc.postgresql.Query", "  url: jdbc:postgresql://127.0.0.1:56982/", "  username: postgres", "  password: pg_passwd", "  sql:  \"{{#each outputs.update.rows}} INSERT INTO pl_store_distribute (year_month,store_code, update_date) values ({{this.play_time}}, {{this.concert_id}}, TO_TIMESTAMP('{{this.timestamp_type}}', 'YYYY/MM/DDTHH24:MI:SS.US') ); {{/each}}\""})})
public class Query
extends AbstractJdbcQuery
implements RunnableTask<AbstractJdbcQuery.Output>,
PostgresConnectionInterface {
    protected Boolean ssl;
    protected PostgresConnectionInterface.SslMode sslMode;
    protected String sslRootCert;
    protected String sslCert;
    protected String sslKey;
    protected String sslKeyPassword;

    @Override
    protected Properties connectionProperties(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        Properties properties = super.connectionProperties(runContext);
        PostgresService.handleSsl(properties, runContext, this, this);
        return properties;
    }

    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new PostgresCellConverter(zoneId);
    }

    @Override
    protected void registerDriver() throws SQLException {
        DriverManager.registerDriver(new Driver());
    }

    @Override
    public AbstractJdbcQuery.Output run(RunContext runContext) throws Exception {
        return super.run(runContext);
    }

    @Generated
    private static Boolean $default$ssl() {
        return false;
    }

    @Generated
    protected Query(QueryBuilder<?, ?> b) {
        super((AbstractJdbcQuery.AbstractJdbcQueryBuilder<?, ?>)b);
        this.ssl = b.ssl$set ? b.ssl$value : Query.$default$ssl();
        this.sslMode = b.sslMode;
        this.sslRootCert = b.sslRootCert;
        this.sslCert = b.sslCert;
        this.sslKey = b.sslKey;
        this.sslKeyPassword = b.sslKeyPassword;
    }

    @Generated
    public static QueryBuilder<?, ?> builder() {
        return new QueryBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Query(super=" + super.toString() + ", ssl=" + this.getSsl() + ", sslMode=" + this.getSslMode() + ", sslRootCert=" + this.getSslRootCert() + ", sslCert=" + this.getSslCert() + ", sslKey=" + this.getSslKey() + ", sslKeyPassword=" + this.getSslKeyPassword() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ssl = this.getSsl();
        Boolean other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        PostgresConnectionInterface.SslMode this$sslMode = this.getSslMode();
        PostgresConnectionInterface.SslMode other$sslMode = other.getSslMode();
        if (this$sslMode == null ? other$sslMode != null : !((Object)((Object)this$sslMode)).equals((Object)other$sslMode)) {
            return false;
        }
        String this$sslRootCert = this.getSslRootCert();
        String other$sslRootCert = other.getSslRootCert();
        if (this$sslRootCert == null ? other$sslRootCert != null : !this$sslRootCert.equals(other$sslRootCert)) {
            return false;
        }
        String this$sslCert = this.getSslCert();
        String other$sslCert = other.getSslCert();
        if (this$sslCert == null ? other$sslCert != null : !this$sslCert.equals(other$sslCert)) {
            return false;
        }
        String this$sslKey = this.getSslKey();
        String other$sslKey = other.getSslKey();
        if (this$sslKey == null ? other$sslKey != null : !this$sslKey.equals(other$sslKey)) {
            return false;
        }
        String this$sslKeyPassword = this.getSslKeyPassword();
        String other$sslKeyPassword = other.getSslKeyPassword();
        return !(this$sslKeyPassword == null ? other$sslKeyPassword != null : !this$sslKeyPassword.equals(other$sslKeyPassword));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        PostgresConnectionInterface.SslMode $sslMode = this.getSslMode();
        result = result * 59 + ($sslMode == null ? 43 : ((Object)((Object)$sslMode)).hashCode());
        String $sslRootCert = this.getSslRootCert();
        result = result * 59 + ($sslRootCert == null ? 43 : $sslRootCert.hashCode());
        String $sslCert = this.getSslCert();
        result = result * 59 + ($sslCert == null ? 43 : $sslCert.hashCode());
        String $sslKey = this.getSslKey();
        result = result * 59 + ($sslKey == null ? 43 : $sslKey.hashCode());
        String $sslKeyPassword = this.getSslKeyPassword();
        result = result * 59 + ($sslKeyPassword == null ? 43 : $sslKeyPassword.hashCode());
        return result;
    }

    @Override
    @Generated
    public Boolean getSsl() {
        return this.ssl;
    }

    @Override
    @Generated
    public PostgresConnectionInterface.SslMode getSslMode() {
        return this.sslMode;
    }

    @Override
    @Generated
    public String getSslRootCert() {
        return this.sslRootCert;
    }

    @Override
    @Generated
    public String getSslCert() {
        return this.sslCert;
    }

    @Override
    @Generated
    public String getSslKey() {
        return this.sslKey;
    }

    @Override
    @Generated
    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    @Generated
    public Query() {
        this.ssl = Query.$default$ssl();
    }

    @Generated
    private static final class QueryBuilderImpl
    extends QueryBuilder<Query, QueryBuilderImpl> {
        @Generated
        private QueryBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Query build() {
            return new Query(this);
        }
    }

    @Generated
    public static abstract class QueryBuilder<C extends Query, B extends QueryBuilder<C, B>>
    extends AbstractJdbcQuery.AbstractJdbcQueryBuilder<C, B> {
        @Generated
        private boolean ssl$set;
        @Generated
        private Boolean ssl$value;
        @Generated
        private PostgresConnectionInterface.SslMode sslMode;
        @Generated
        private String sslRootCert;
        @Generated
        private String sslCert;
        @Generated
        private String sslKey;
        @Generated
        private String sslKeyPassword;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B ssl(Boolean ssl) {
            this.ssl$value = ssl;
            this.ssl$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslMode(PostgresConnectionInterface.SslMode sslMode) {
            this.sslMode = sslMode;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslRootCert(String sslRootCert) {
            this.sslRootCert = sslRootCert;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslCert(String sslCert) {
            this.sslCert = sslCert;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslKey(String sslKey) {
            this.sslKey = sslKey;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslKeyPassword(String sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "Query.QueryBuilder(super=" + super.toString() + ", ssl$value=" + this.ssl$value + ", sslMode=" + this.sslMode + ", sslRootCert=" + this.sslRootCert + ", sslCert=" + this.sslCert + ", sslKey=" + this.sslKey + ", sslKeyPassword=" + this.sslKeyPassword + ")";
        }
    }
}

