/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.postgresql;

import io.kestra.plugin.jdbc.AbstractCellConverter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalTime;
import java.time.ZoneId;
import org.postgresql.jdbc.PgArray;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGobject;

public class PostgresCellConverter
extends AbstractCellConverter {
    public PostgresCellConverter(ZoneId zoneId) {
        super(zoneId);
    }

    @Override
    public Object convertCell(int columnIndex, ResultSet rs, Connection connection) throws SQLException {
        Object data = rs.getObject(columnIndex);
        if (data == null) {
            return null;
        }
        String pgColumnType = rs.getMetaData().getColumnTypeName(columnIndex);
        switch (pgColumnType.toLowerCase()) {
            case "time": {
                return LocalTime.parse(rs.getTime(columnIndex).toString());
            }
            case "timetz": 
            case "time with time zone": {
                return LocalTime.from(rs.getTimestamp(columnIndex).toInstant().atZone(this.zoneId));
            }
            case "timestamp": {
                return rs.getTimestamp(columnIndex).toLocalDateTime();
            }
            case "timestamptz": 
            case "timestamp with time zone": {
                return rs.getTimestamp(columnIndex).toInstant().atZone(this.zoneId);
            }
            case "interval": {
                PGInterval interval = (PGInterval)data;
                return this.getISO8601Interval(interval.getYears(), interval.getMonths(), interval.getDays(), interval.getHours(), interval.getMinutes(), (int)interval.getSeconds());
            }
        }
        Class<?> clazz = data.getClass();
        if (clazz.equals(PgArray.class)) {
            return ((PgArray)data).getArray();
        }
        if (clazz.equals(PGobject.class)) {
            PGobject o = (PGobject)data;
            String type = o.getType();
            switch (type.toLowerCase()) {
                case "json": {
                    return o.getValue();
                }
            }
            throw new IllegalArgumentException("PGobject of type [" + type + "] is not supported");
        }
        return super.convert(columnIndex, rs);
    }

    private String getISO8601Interval(int years, int months, int days, int hours, int minutes, int seconds) {
        return "P" + years + "Y" + months + "M" + days + "DT" + hours + "H" + minutes + "M" + seconds + "S";
    }
}

