/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.postgresql;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.postgresql.AbstractCopy;
import io.kestra.plugin.jdbc.postgresql.PostgresConnectionInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.Connection;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;

@Schema(title="Copy a PostgreSQL table or a query to a file", description="Moves data between PostgreSQL tables or query to a file")
@Plugin(examples={@Example(title="Load csv from a postgres table", code={"url: jdbc:postgresql://127.0.0.1:56982/", "username: postgres", "password: pg_passwd", "format: CSV", "from: {{ outputs.export.uri }}", "table: my_destination_table", "header: true", "delimiter: \"\t\""})})
public class CopyIn
extends AbstractCopy
implements RunnableTask<Output>,
PostgresConnectionInterface {
    @NotNull
    @Schema(title="Source file URI")
    @PluginProperty(dynamic=true)
    private String from;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        URI from = new URI(runContext.render(this.from));
        try (Connection connection = this.connection(runContext);){
            Output output;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(runContext.uriToInputStream(from)));){
                BaseConnection pgConnection = connection.unwrap(BaseConnection.class);
                CopyManager copyManager = new CopyManager(pgConnection);
                String sql = this.query(runContext, null, "FROM STDIN");
                logger.debug("Starting query: {}", (Object)sql);
                long rowsAffected = copyManager.copyIn(sql, bufferedReader);
                runContext.metric((AbstractMetricEntry)Counter.of((String)"rows", (Long)rowsAffected, (String[])new String[0]));
                output = Output.builder().rowCount(rowsAffected).build();
            }
            return output;
        }
    }

    @Generated
    protected CopyIn(CopyInBuilder<?, ?> b) {
        super((AbstractCopy.AbstractCopyBuilder<?, ?>)b);
        this.from = b.from;
    }

    @Generated
    public static CopyInBuilder<?, ?> builder() {
        return new CopyInBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "CopyIn(super=" + super.toString() + ", from=" + this.getFrom() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyIn)) {
            return false;
        }
        CopyIn other = (CopyIn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CopyIn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public CopyIn() {
    }

    @Generated
    private static final class CopyInBuilderImpl
    extends CopyInBuilder<CopyIn, CopyInBuilderImpl> {
        @Generated
        private CopyInBuilderImpl() {
        }

        @Override
        @Generated
        protected CopyInBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CopyIn build() {
            return new CopyIn(this);
        }
    }

    @Generated
    public static abstract class CopyInBuilder<C extends CopyIn, B extends CopyInBuilder<C, B>>
    extends AbstractCopy.AbstractCopyBuilder<C, B> {
        @Generated
        private String from;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "CopyIn.CopyInBuilder(super=" + super.toString() + ", from=" + this.from + ")";
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The rows count from this `COPY`")
        private final Long rowCount;

        @ConstructorProperties(value={"rowCount"})
        @Generated
        Output(Long rowCount) {
            this.rowCount = rowCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getRowCount() {
            return this.rowCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long rowCount;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder rowCount(Long rowCount) {
                this.rowCount = rowCount;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.rowCount);
            }

            @Generated
            public String toString() {
                return "CopyIn.Output.OutputBuilder(rowCount=" + this.rowCount + ")";
            }
        }
    }
}

