/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.postgresql;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractJdbcConnection;
import io.kestra.plugin.jdbc.postgresql.PostgresConnectionInterface;
import io.kestra.plugin.jdbc.postgresql.PostgresService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.postgresql.Driver;

public abstract class AbstractCopy
extends AbstractJdbcConnection
implements PostgresConnectionInterface {
    protected Boolean ssl;
    protected PostgresConnectionInterface.SslMode sslMode;
    protected String sslRootCert;
    protected String sslCert;
    protected String sslKey;
    protected String sslKeyPassword;
    @Schema(title="The name (optionally schema-qualified) of an existing table.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String table;
    @Schema(title="An optional list of columns to be copied", description="If no column list is specified, all columns of the table will be copied.")
    @PluginProperty(dynamic=false)
    protected List<String> columns;
    @Schema(title="Selects the data format to be read or written")
    @PluginProperty(dynamic=false)
    protected Format format;
    @Schema(title="Specifies copying the OID for each row", description="An error is raised if OIDS is specified for a table that does not have OIDs, or in the case of copying a query.")
    @PluginProperty(dynamic=false)
    protected Boolean oids;
    @Schema(title="Requests copying the data with rows already frozen, just as they would be after running the VACUUM FREEZE command", description="This is intended as a performance option for initial data loading. Rows will be frozen only if the table being loaded has been created or truncated in the current subtransaction, there are no cursors open and there are no older snapshots held by this transaction. It is currently not possible to perform a COPY FREEZE on a partitioned table.\n\nNote that all other sessions will immediately be able to see the data once it has been successfully loaded. This violates the normal rules of MVCC visibility and users specifying should be aware of the potential problems this might cause.")
    @PluginProperty(dynamic=false)
    protected Boolean freeze;
    @Schema(title="Specifies the character that separates columns within each row (line) of the file", description="The default is a tab character in text format, a comma in CSV format. This must be a single one-byte character. This option is not allowed when using binary")
    @PluginProperty(dynamic=false)
    protected Character delimiter;
    @Schema(title="Specifies the string that represents a null value", description="The default is \\N (backslash-N) in text format, and an unquoted empty string in CSV format. You might prefer an empty string even in text format for cases where you don't want to distinguish nulls from empty strings. This option is not allowed when using binary format.")
    @PluginProperty(dynamic=false)
    protected String nullString;
    @Schema(title="Specifies that the file contains a header line with the names of each column in the file", description="On output, the first line contains the column names from the table, and on input, the first line is ignored. This option is allowed only when using CSV.")
    @PluginProperty(dynamic=false)
    protected Boolean header;
    @Schema(title="Specifies the quoting character to be used when a data value is quoted.", description="The default is double-quote. This must be a single one-byte character. This option is allowed only when using CSV format.")
    @PluginProperty(dynamic=false)
    protected Character quote;
    @Schema(title="Specifies the character that should appear before a data character that matches the QUOTE value.", description="The default is the same as the QUOTE value (so that the quoting character is doubled if it appears in the data). This must be a single one-byte character. This option is allowed only when using CSV format.")
    @PluginProperty(dynamic=false)
    protected Character escape;
    @Schema(title="Forces quoting to be used for all non-NULL values in each specified column", description="NULL output is never quoted. If * is specified, non-NULL values will be quoted in all columns. This option is allowed only in COPY TO, and only when using CSV format.")
    @PluginProperty(dynamic=false)
    protected List<String> forceQuote;
    @Schema(title="Do not match the specified columns' values against the null string", description="In the default case where the null string is empty, this means that empty values will be read as zero-length strings rather than nulls, even when they are not quoted. This option is allowed only in COPY FROM, and only when using CSV format.")
    @PluginProperty(dynamic=false)
    protected List<String> forceNotNull;
    @Schema(title="Match the specified columns' values against the null string, even if it has been quoted, and if a match is found set the value to NULL", description="In the default case where the null string is empty, this converts a quoted empty string into NULL. This option is allowed only in COPY FROM, and only when using CSV format.")
    @PluginProperty(dynamic=false)
    protected List<String> forceNull;
    @Schema(title="Specifies that the file is encoded in the encoding_name", description="If this option is omitted, the current client encoding is used. See the Notes below for more details.")
    @PluginProperty(dynamic=false)
    protected String encoding;

    @Override
    protected Properties connectionProperties(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        Properties properties = super.connectionProperties(runContext);
        PostgresService.handleSsl(properties, runContext, this, this);
        return properties;
    }

    @Override
    protected void registerDriver() throws SQLException {
        DriverManager.registerDriver(new Driver());
    }

    protected String query(RunContext runContext, String query, String dest) throws IllegalVariableEvaluationException {
        ArrayList<Object> sql = new ArrayList<Object>();
        ArrayList<Object> options = new ArrayList<Object>();
        sql.add("COPY");
        if (query == null) {
            sql.add(runContext.render(this.table));
            if (this.columns != null) {
                sql.add("(" + String.join((CharSequence)", ", this.columns) + ")");
            }
        } else {
            sql.add("(" + query + ")");
        }
        sql.add(dest);
        if (this.format != Format.TEXT) {
            options.add("FORMAT " + this.format.name());
        }
        if (this.oids != null && this.oids.booleanValue()) {
            options.add("OIDS");
        }
        if (this.freeze != null && this.freeze.booleanValue()) {
            options.add("FREEZE");
        }
        if (this.delimiter != null) {
            options.add("DELIMITER '" + this.delimiter + "'");
        }
        if (this.nullString != null) {
            options.add("NULL '" + this.nullString + "'");
        }
        if (this.header != null) {
            options.add("HEADER " + (this.header != false ? "TRUE" : "FALSE"));
        }
        if (this.quote != null) {
            options.add("QUOTE '" + this.quote + "'");
        }
        if (this.escape != null) {
            options.add("ESCAPE '" + this.escape + "'");
        }
        if (this.forceQuote != null) {
            options.add("FORCE_QUOTE " + (String)(this.forceQuote.size() == 1 && this.forceQuote.get(0).equals("*") ? "*" : "(" + String.join((CharSequence)", ", this.forceQuote) + ")"));
        }
        if (this.forceNotNull != null) {
            options.add("FORCE_NOT_NULL (" + String.join((CharSequence)", ", this.forceNotNull) + ")");
        }
        if (this.forceNull != null) {
            options.add("FORCE_NULL (" + String.join((CharSequence)", ", this.forceNull) + ")");
        }
        if (this.encoding != null) {
            options.add("ENCODING '" + this.encoding + "'");
        }
        if (options.size() > 0) {
            sql.add("WITH (" + String.join((CharSequence)", ", options) + ")");
        }
        return String.join((CharSequence)" ", sql);
    }

    @Generated
    private static Boolean $default$ssl() {
        return false;
    }

    @Generated
    private static Format $default$format() {
        return Format.TEXT;
    }

    @Generated
    protected AbstractCopy(AbstractCopyBuilder<?, ?> b) {
        super(b);
        this.ssl = b.ssl$set ? b.ssl$value : AbstractCopy.$default$ssl();
        this.sslMode = b.sslMode;
        this.sslRootCert = b.sslRootCert;
        this.sslCert = b.sslCert;
        this.sslKey = b.sslKey;
        this.sslKeyPassword = b.sslKeyPassword;
        this.table = b.table;
        this.columns = b.columns;
        this.format = b.format$set ? b.format$value : AbstractCopy.$default$format();
        this.oids = b.oids;
        this.freeze = b.freeze;
        this.delimiter = b.delimiter;
        this.nullString = b.nullString;
        this.header = b.header;
        this.quote = b.quote;
        this.escape = b.escape;
        this.forceQuote = b.forceQuote;
        this.forceNotNull = b.forceNotNull;
        this.forceNull = b.forceNull;
        this.encoding = b.encoding;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractCopy(super=" + super.toString() + ", ssl=" + this.getSsl() + ", sslMode=" + this.getSslMode() + ", sslRootCert=" + this.getSslRootCert() + ", sslCert=" + this.getSslCert() + ", sslKey=" + this.getSslKey() + ", sslKeyPassword=" + this.getSslKeyPassword() + ", table=" + this.getTable() + ", columns=" + this.getColumns() + ", format=" + this.getFormat() + ", oids=" + this.getOids() + ", freeze=" + this.getFreeze() + ", delimiter=" + this.getDelimiter() + ", nullString=" + this.getNullString() + ", header=" + this.getHeader() + ", quote=" + this.getQuote() + ", escape=" + this.getEscape() + ", forceQuote=" + this.getForceQuote() + ", forceNotNull=" + this.getForceNotNull() + ", forceNull=" + this.getForceNull() + ", encoding=" + this.getEncoding() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCopy)) {
            return false;
        }
        AbstractCopy other = (AbstractCopy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ssl = this.getSsl();
        Boolean other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        Boolean this$oids = this.getOids();
        Boolean other$oids = other.getOids();
        if (this$oids == null ? other$oids != null : !((Object)this$oids).equals(other$oids)) {
            return false;
        }
        Boolean this$freeze = this.getFreeze();
        Boolean other$freeze = other.getFreeze();
        if (this$freeze == null ? other$freeze != null : !((Object)this$freeze).equals(other$freeze)) {
            return false;
        }
        Character this$delimiter = this.getDelimiter();
        Character other$delimiter = other.getDelimiter();
        if (this$delimiter == null ? other$delimiter != null : !((Object)this$delimiter).equals(other$delimiter)) {
            return false;
        }
        Boolean this$header = this.getHeader();
        Boolean other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Character this$quote = this.getQuote();
        Character other$quote = other.getQuote();
        if (this$quote == null ? other$quote != null : !((Object)this$quote).equals(other$quote)) {
            return false;
        }
        Character this$escape = this.getEscape();
        Character other$escape = other.getEscape();
        if (this$escape == null ? other$escape != null : !((Object)this$escape).equals(other$escape)) {
            return false;
        }
        PostgresConnectionInterface.SslMode this$sslMode = this.getSslMode();
        PostgresConnectionInterface.SslMode other$sslMode = other.getSslMode();
        if (this$sslMode == null ? other$sslMode != null : !((Object)((Object)this$sslMode)).equals((Object)other$sslMode)) {
            return false;
        }
        String this$sslRootCert = this.getSslRootCert();
        String other$sslRootCert = other.getSslRootCert();
        if (this$sslRootCert == null ? other$sslRootCert != null : !this$sslRootCert.equals(other$sslRootCert)) {
            return false;
        }
        String this$sslCert = this.getSslCert();
        String other$sslCert = other.getSslCert();
        if (this$sslCert == null ? other$sslCert != null : !this$sslCert.equals(other$sslCert)) {
            return false;
        }
        String this$sslKey = this.getSslKey();
        String other$sslKey = other.getSslKey();
        if (this$sslKey == null ? other$sslKey != null : !this$sslKey.equals(other$sslKey)) {
            return false;
        }
        String this$sslKeyPassword = this.getSslKeyPassword();
        String other$sslKeyPassword = other.getSslKeyPassword();
        if (this$sslKeyPassword == null ? other$sslKeyPassword != null : !this$sslKeyPassword.equals(other$sslKeyPassword)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        List<String> this$columns = this.getColumns();
        List<String> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
            return false;
        }
        String this$nullString = this.getNullString();
        String other$nullString = other.getNullString();
        if (this$nullString == null ? other$nullString != null : !this$nullString.equals(other$nullString)) {
            return false;
        }
        List<String> this$forceQuote = this.getForceQuote();
        List<String> other$forceQuote = other.getForceQuote();
        if (this$forceQuote == null ? other$forceQuote != null : !((Object)this$forceQuote).equals(other$forceQuote)) {
            return false;
        }
        List<String> this$forceNotNull = this.getForceNotNull();
        List<String> other$forceNotNull = other.getForceNotNull();
        if (this$forceNotNull == null ? other$forceNotNull != null : !((Object)this$forceNotNull).equals(other$forceNotNull)) {
            return false;
        }
        List<String> this$forceNull = this.getForceNull();
        List<String> other$forceNull = other.getForceNull();
        if (this$forceNull == null ? other$forceNull != null : !((Object)this$forceNull).equals(other$forceNull)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        return !(this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractCopy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        Boolean $oids = this.getOids();
        result = result * 59 + ($oids == null ? 43 : ((Object)$oids).hashCode());
        Boolean $freeze = this.getFreeze();
        result = result * 59 + ($freeze == null ? 43 : ((Object)$freeze).hashCode());
        Character $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : ((Object)$delimiter).hashCode());
        Boolean $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Character $quote = this.getQuote();
        result = result * 59 + ($quote == null ? 43 : ((Object)$quote).hashCode());
        Character $escape = this.getEscape();
        result = result * 59 + ($escape == null ? 43 : ((Object)$escape).hashCode());
        PostgresConnectionInterface.SslMode $sslMode = this.getSslMode();
        result = result * 59 + ($sslMode == null ? 43 : ((Object)((Object)$sslMode)).hashCode());
        String $sslRootCert = this.getSslRootCert();
        result = result * 59 + ($sslRootCert == null ? 43 : $sslRootCert.hashCode());
        String $sslCert = this.getSslCert();
        result = result * 59 + ($sslCert == null ? 43 : $sslCert.hashCode());
        String $sslKey = this.getSslKey();
        result = result * 59 + ($sslKey == null ? 43 : $sslKey.hashCode());
        String $sslKeyPassword = this.getSslKeyPassword();
        result = result * 59 + ($sslKeyPassword == null ? 43 : $sslKeyPassword.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        List<String> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        String $nullString = this.getNullString();
        result = result * 59 + ($nullString == null ? 43 : $nullString.hashCode());
        List<String> $forceQuote = this.getForceQuote();
        result = result * 59 + ($forceQuote == null ? 43 : ((Object)$forceQuote).hashCode());
        List<String> $forceNotNull = this.getForceNotNull();
        result = result * 59 + ($forceNotNull == null ? 43 : ((Object)$forceNotNull).hashCode());
        List<String> $forceNull = this.getForceNull();
        result = result * 59 + ($forceNull == null ? 43 : ((Object)$forceNull).hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        return result;
    }

    @Override
    @Generated
    public Boolean getSsl() {
        return this.ssl;
    }

    @Override
    @Generated
    public PostgresConnectionInterface.SslMode getSslMode() {
        return this.sslMode;
    }

    @Override
    @Generated
    public String getSslRootCert() {
        return this.sslRootCert;
    }

    @Override
    @Generated
    public String getSslCert() {
        return this.sslCert;
    }

    @Override
    @Generated
    public String getSslKey() {
        return this.sslKey;
    }

    @Override
    @Generated
    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public List<String> getColumns() {
        return this.columns;
    }

    @Generated
    public Format getFormat() {
        return this.format;
    }

    @Generated
    public Boolean getOids() {
        return this.oids;
    }

    @Generated
    public Boolean getFreeze() {
        return this.freeze;
    }

    @Generated
    public Character getDelimiter() {
        return this.delimiter;
    }

    @Generated
    public String getNullString() {
        return this.nullString;
    }

    @Generated
    public Boolean getHeader() {
        return this.header;
    }

    @Generated
    public Character getQuote() {
        return this.quote;
    }

    @Generated
    public Character getEscape() {
        return this.escape;
    }

    @Generated
    public List<String> getForceQuote() {
        return this.forceQuote;
    }

    @Generated
    public List<String> getForceNotNull() {
        return this.forceNotNull;
    }

    @Generated
    public List<String> getForceNull() {
        return this.forceNull;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public AbstractCopy() {
        this.ssl = AbstractCopy.$default$ssl();
        this.format = AbstractCopy.$default$format();
    }

    @Generated
    public static abstract class AbstractCopyBuilder<C extends AbstractCopy, B extends AbstractCopyBuilder<C, B>>
    extends AbstractJdbcConnection.AbstractJdbcConnectionBuilder<C, B> {
        @Generated
        private boolean ssl$set;
        @Generated
        private Boolean ssl$value;
        @Generated
        private PostgresConnectionInterface.SslMode sslMode;
        @Generated
        private String sslRootCert;
        @Generated
        private String sslCert;
        @Generated
        private String sslKey;
        @Generated
        private String sslKeyPassword;
        @Generated
        private String table;
        @Generated
        private List<String> columns;
        @Generated
        private boolean format$set;
        @Generated
        private Format format$value;
        @Generated
        private Boolean oids;
        @Generated
        private Boolean freeze;
        @Generated
        private Character delimiter;
        @Generated
        private String nullString;
        @Generated
        private Boolean header;
        @Generated
        private Character quote;
        @Generated
        private Character escape;
        @Generated
        private List<String> forceQuote;
        @Generated
        private List<String> forceNotNull;
        @Generated
        private List<String> forceNull;
        @Generated
        private String encoding;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B ssl(Boolean ssl) {
            this.ssl$value = ssl;
            this.ssl$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslMode(PostgresConnectionInterface.SslMode sslMode) {
            this.sslMode = sslMode;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslRootCert(String sslRootCert) {
            this.sslRootCert = sslRootCert;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslCert(String sslCert) {
            this.sslCert = sslCert;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslKey(String sslKey) {
            this.sslKey = sslKey;
            return (B)((Object)this.self());
        }

        @Generated
        public B sslKeyPassword(String sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
            return (B)((Object)this.self());
        }

        @Generated
        public B table(String table) {
            this.table = table;
            return (B)((Object)this.self());
        }

        @Generated
        public B columns(List<String> columns) {
            this.columns = columns;
            return (B)((Object)this.self());
        }

        @Generated
        public B format(Format format) {
            this.format$value = format;
            this.format$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B oids(Boolean oids) {
            this.oids = oids;
            return (B)((Object)this.self());
        }

        @Generated
        public B freeze(Boolean freeze) {
            this.freeze = freeze;
            return (B)((Object)this.self());
        }

        @Generated
        public B delimiter(Character delimiter) {
            this.delimiter = delimiter;
            return (B)((Object)this.self());
        }

        @Generated
        public B nullString(String nullString) {
            this.nullString = nullString;
            return (B)((Object)this.self());
        }

        @Generated
        public B header(Boolean header) {
            this.header = header;
            return (B)((Object)this.self());
        }

        @Generated
        public B quote(Character quote) {
            this.quote = quote;
            return (B)((Object)this.self());
        }

        @Generated
        public B escape(Character escape) {
            this.escape = escape;
            return (B)((Object)this.self());
        }

        @Generated
        public B forceQuote(List<String> forceQuote) {
            this.forceQuote = forceQuote;
            return (B)((Object)this.self());
        }

        @Generated
        public B forceNotNull(List<String> forceNotNull) {
            this.forceNotNull = forceNotNull;
            return (B)((Object)this.self());
        }

        @Generated
        public B forceNull(List<String> forceNull) {
            this.forceNull = forceNull;
            return (B)((Object)this.self());
        }

        @Generated
        public B encoding(String encoding) {
            this.encoding = encoding;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "AbstractCopy.AbstractCopyBuilder(super=" + super.toString() + ", ssl$value=" + this.ssl$value + ", sslMode=" + this.sslMode + ", sslRootCert=" + this.sslRootCert + ", sslCert=" + this.sslCert + ", sslKey=" + this.sslKey + ", sslKeyPassword=" + this.sslKeyPassword + ", table=" + this.table + ", columns=" + this.columns + ", format$value=" + this.format$value + ", oids=" + this.oids + ", freeze=" + this.freeze + ", delimiter=" + this.delimiter + ", nullString=" + this.nullString + ", header=" + this.header + ", quote=" + this.quote + ", escape=" + this.escape + ", forceQuote=" + this.forceQuote + ", forceNotNull=" + this.forceNotNull + ", forceNull=" + this.forceNull + ", encoding=" + this.encoding + ")";
        }
    }

    public static enum Format {
        TEXT,
        CSV,
        BINARY;

    }
}

