/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcConnection;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;

public abstract class AbstractJdbcQuery
extends AbstractJdbcConnection {
    @Schema(title="The sql query to run")
    @PluginProperty(dynamic=true)
    private String sql;
    @Schema(title="Whether to fetch data row from the query result to a file in internal storage. File will be saved as Amazon Ion (text format). \n See <a href=\"http://amzn.github.io/ion-docs/\">Amazon Ion documentation</a> This parameter is evaluated after 'fetchOne' but before 'fetch'.")
    @PluginProperty(dynamic=true)
    private final Boolean store;
    @Schema(title="Whether to fetch only one data row from the query result to the task output. This parameter is evaluated before 'store' and 'fetch'.")
    private final Boolean fetchOne;
    @Schema(title="Whether to fetch the data from the query result to the task output This parameter is evaluated after 'fetchOne' and 'store'.")
    private final Boolean fetch;
    @Schema(title="The time zone id to use for date/time manipulation. Default value is the worker default zone id.")
    private String timeZoneId;
    @Schema(title="Number of rows that should be fetched", description="Gives the JDBC driver a hint as to the number of rows that should be fetched from the database when more rows are needed for this ResultSet object. If the fetch size specified is zero, the JDBC driver ignores the value and is free to make its own best guess as to what the fetch size should be. Ignored if `autoCommit` is false.")
    @PluginProperty(dynamic=false)
    private final Integer fetchSize;
    private static final ObjectMapper MAPPER = JacksonMapper.ofIon();

    protected abstract AbstractCellConverter getCellConverter(ZoneId var1);

    /*
     * Exception decompiling
     */
    public Output run(RunContext runContext) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] tags() {
        return new String[]{"fetch", this.fetch != false || this.fetchOne != false ? "true" : "false", "store", this.store != false ? "true" : "false"};
    }

    protected Map<String, Object> fetchResult(ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        rs.next();
        return this.mapResultSetToMap(rs, cellConverter, connection);
    }

    protected long fetchResults(Statement stmt, ResultSet rs, List<Map<String, Object>> maps, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        return this.fetch(stmt, rs, Rethrow.throwConsumer(maps::add), cellConverter, connection);
    }

    protected long fetchToFile(Statement stmt, ResultSet rs, BufferedWriter writer, AbstractCellConverter cellConverter, Connection connection) throws SQLException, IOException {
        return this.fetch(stmt, rs, Rethrow.throwConsumer(map -> {
            String s2 = MAPPER.writeValueAsString(map);
            writer.write(s2);
            writer.write("\n");
        }), cellConverter, connection);
    }

    private long fetch(Statement stmt, ResultSet rs, Consumer<Map<String, Object>> c, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        long count = 0L;
        while (true) {
            if (rs.next()) {
                Map<String, Object> map = this.mapResultSetToMap(rs, cellConverter, connection);
                c.accept(map);
                ++count;
                continue;
            }
            boolean isResult = stmt.getMoreResults();
            if (!isResult) break;
        }
        return count;
    }

    private Map<String, Object> mapResultSetToMap(ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        int columnsCount = rs.getMetaData().getColumnCount();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 1; i <= columnsCount; ++i) {
            map.put(rs.getMetaData().getColumnName(i), this.convertCell(i, rs, cellConverter, connection));
        }
        return map;
    }

    private Object convertCell(int columnIndex, ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        return cellConverter.convertCell(columnIndex, rs, connection);
    }

    @Generated
    private static Boolean $default$store() {
        return false;
    }

    @Generated
    private static Boolean $default$fetchOne() {
        return false;
    }

    @Generated
    private static Boolean $default$fetch() {
        return false;
    }

    @Generated
    private static Integer $default$fetchSize() {
        return 10000;
    }

    @Generated
    protected AbstractJdbcQuery(AbstractJdbcQueryBuilder<?, ?> b) {
        super(b);
        this.sql = b.sql;
        this.store = b.store$set ? b.store$value : AbstractJdbcQuery.$default$store();
        this.fetchOne = b.fetchOne$set ? b.fetchOne$value : AbstractJdbcQuery.$default$fetchOne();
        this.fetch = b.fetch$set ? b.fetch$value : AbstractJdbcQuery.$default$fetch();
        this.timeZoneId = b.timeZoneId;
        this.fetchSize = b.fetchSize$set ? b.fetchSize$value : AbstractJdbcQuery.$default$fetchSize();
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractJdbcQuery(super=" + super.toString() + ", sql=" + this.getSql() + ", store=" + this.getStore() + ", fetchOne=" + this.getFetchOne() + ", fetch=" + this.getFetch() + ", timeZoneId=" + this.getTimeZoneId() + ", fetchSize=" + this.getFetchSize() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcQuery)) {
            return false;
        }
        AbstractJdbcQuery other = (AbstractJdbcQuery)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$store = this.getStore();
        Boolean other$store = other.getStore();
        if (this$store == null ? other$store != null : !((Object)this$store).equals(other$store)) {
            return false;
        }
        Boolean this$fetchOne = this.getFetchOne();
        Boolean other$fetchOne = other.getFetchOne();
        if (this$fetchOne == null ? other$fetchOne != null : !((Object)this$fetchOne).equals(other$fetchOne)) {
            return false;
        }
        Boolean this$fetch = this.getFetch();
        Boolean other$fetch = other.getFetch();
        if (this$fetch == null ? other$fetch != null : !((Object)this$fetch).equals(other$fetch)) {
            return false;
        }
        Integer this$fetchSize = this.getFetchSize();
        Integer other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !((Object)this$fetchSize).equals(other$fetchSize)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$timeZoneId = this.getTimeZoneId();
        String other$timeZoneId = other.getTimeZoneId();
        return !(this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : ((Object)$store).hashCode());
        Boolean $fetchOne = this.getFetchOne();
        result = result * 59 + ($fetchOne == null ? 43 : ((Object)$fetchOne).hashCode());
        Boolean $fetch = this.getFetch();
        result = result * 59 + ($fetch == null ? 43 : ((Object)$fetch).hashCode());
        Integer $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : ((Object)$fetchSize).hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        return result;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public Boolean getStore() {
        return this.store;
    }

    @Generated
    public Boolean getFetchOne() {
        return this.fetchOne;
    }

    @Generated
    public Boolean getFetch() {
        return this.fetch;
    }

    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Generated
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Generated
    public AbstractJdbcQuery() {
        this.store = AbstractJdbcQuery.$default$store();
        this.fetchOne = AbstractJdbcQuery.$default$fetchOne();
        this.fetch = AbstractJdbcQuery.$default$fetch();
        this.fetchSize = AbstractJdbcQuery.$default$fetchSize();
    }

    @Generated
    public static abstract class AbstractJdbcQueryBuilder<C extends AbstractJdbcQuery, B extends AbstractJdbcQueryBuilder<C, B>>
    extends AbstractJdbcConnection.AbstractJdbcConnectionBuilder<C, B> {
        @Generated
        private String sql;
        @Generated
        private boolean store$set;
        @Generated
        private Boolean store$value;
        @Generated
        private boolean fetchOne$set;
        @Generated
        private Boolean fetchOne$value;
        @Generated
        private boolean fetch$set;
        @Generated
        private Boolean fetch$value;
        @Generated
        private String timeZoneId;
        @Generated
        private boolean fetchSize$set;
        @Generated
        private Integer fetchSize$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)((Object)this.self());
        }

        @Generated
        public B store(Boolean store) {
            this.store$value = store;
            this.store$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B fetchOne(Boolean fetchOne) {
            this.fetchOne$value = fetchOne;
            this.fetchOne$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B fetch(Boolean fetch) {
            this.fetch$value = fetch;
            this.fetch$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)((Object)this.self());
        }

        @Generated
        public B fetchSize(Integer fetchSize) {
            this.fetchSize$value = fetchSize;
            this.fetchSize$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "AbstractJdbcQuery.AbstractJdbcQueryBuilder(super=" + super.toString() + ", sql=" + this.sql + ", store$value=" + this.store$value + ", fetchOne$value=" + this.fetchOne$value + ", fetch$value=" + this.fetch$value + ", timeZoneId=" + this.timeZoneId + ", fetchSize$value=" + this.fetchSize$value + ")";
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Map containing the first row of fetched data", description="Only populated if 'fetchOne' parameter is set to true.")
        private final Map<String, Object> row;
        @Schema(title="Lit of map containing rows of fetched data", description="Only populated if 'fetch' parameter is set to true.")
        private final List<Map<String, Object>> rows;
        @Schema(title="The url of the result file on kestra storage (.ion file / Amazon Ion text format)", description="Only populated if 'store' is set to true.")
        private final URI uri;
        @Schema(title="The size of the fetched rows", description="Only populated if 'store' or 'fetch' parameter is set to true.")
        private final Long size;

        @ConstructorProperties(value={"row", "rows", "uri", "size"})
        @Generated
        Output(Map<String, Object> row, List<Map<String, Object>> rows, URI uri, Long size) {
            this.row = row;
            this.rows = rows;
            this.uri = uri;
            this.size = size;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, Object> getRow() {
            return this.row;
        }

        @Generated
        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, Object> row;
            @Generated
            private List<Map<String, Object>> rows;
            @Generated
            private URI uri;
            @Generated
            private Long size;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder row(Map<String, Object> row) {
                this.row = row;
                return this;
            }

            @Generated
            public OutputBuilder rows(List<Map<String, Object>> rows) {
                this.rows = rows;
                return this;
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.row, this.rows, this.uri, this.size);
            }

            @Generated
            public String toString() {
                return "AbstractJdbcQuery.Output.OutputBuilder(row=" + this.row + ", rows=" + this.rows + ", uri=" + this.uri + ", size=" + this.size + ")";
            }
        }
    }
}

