/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public abstract class AbstractJdbcConnection
extends Task {
    @Schema(title="The jdbc url to connect to the database")
    @PluginProperty(dynamic=true)
    protected String url;
    @Schema(title="The database user")
    @PluginProperty(dynamic=true)
    protected String username;
    @Schema(title="The database user's password")
    @PluginProperty(dynamic=true)
    protected String password;
    @Schema(title="If autocommit is enabled", description="Sets this connection's auto-commit mode to the given state. If a connection is in auto-commit mode, then all its SQL statements will be executed and committed as individual transactions. Otherwise, its SQL statements are grouped into transactions that are terminated by a call to either the method commitor the method rollback. By default, new connections are in auto-commit mode except if you are using a `store` properties that will disabled autocommit whenever this properties values.")
    @PluginProperty(dynamic=false)
    protected final Boolean autoCommit = true;
    private transient Path cleanupDirectory;

    protected abstract void registerDriver() throws SQLException;

    protected Properties connectionProperties(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        Properties props = new Properties();
        props.put("jdbc.url", runContext.render(this.url));
        if (this.username != null) {
            props.put("user", runContext.render(this.username));
        }
        if (this.username != null) {
            props.put("password", runContext.render(this.password));
        }
        return props;
    }

    protected Connection connection(RunContext runContext) throws IllegalVariableEvaluationException, SQLException, IOException {
        this.registerDriver();
        Properties props = this.connectionProperties(runContext);
        return DriverManager.getConnection(props.getProperty("jdbc.url"), props);
    }

    private Path tempDir() throws IOException {
        if (this.cleanupDirectory == null) {
            this.cleanupDirectory = Files.createTempDirectory("working-dir", new FileAttribute[0]);
        }
        return this.cleanupDirectory;
    }

    protected void cleanup() throws IOException {
        if (this.cleanupDirectory != null) {
            FileUtils.deleteDirectory((File)this.cleanupDirectory.toFile());
        }
    }

    public Path tempFile() throws IOException {
        return this.tempFile(null);
    }

    public Path tempFile(String content) throws IOException {
        Path tempFile = Files.createTempFile(this.tempDir(), null, null, new FileAttribute[0]);
        if (content != null) {
            Files.write(tempFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return tempFile;
    }

    @Generated
    protected AbstractJdbcConnection(AbstractJdbcConnectionBuilder<?, ?> b) {
        super(b);
        this.url = b.url;
        this.username = b.username;
        this.password = b.password;
        this.cleanupDirectory = b.cleanupDirectory;
    }

    @Generated
    public String toString() {
        return "AbstractJdbcConnection(super=" + super.toString() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", autoCommit=" + this.getAutoCommit() + ", cleanupDirectory=" + this.cleanupDirectory + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcConnection)) {
            return false;
        }
        AbstractJdbcConnection other = (AbstractJdbcConnection)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$autoCommit = this.getAutoCommit();
        Boolean other$autoCommit = other.getAutoCommit();
        if (this$autoCommit == null ? other$autoCommit != null : !((Object)this$autoCommit).equals(other$autoCommit)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcConnection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : ((Object)$autoCommit).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public AbstractJdbcConnection() {
    }

    @Generated
    public static abstract class AbstractJdbcConnectionBuilder<C extends AbstractJdbcConnection, B extends AbstractJdbcConnectionBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String url;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private Path cleanupDirectory;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B cleanupDirectory(Path cleanupDirectory) {
            this.cleanupDirectory = cleanupDirectory;
            return (B)this.self();
        }

        @Generated
        public String toString() {
            return "AbstractJdbcConnection.AbstractJdbcConnectionBuilder(super=" + super.toString() + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", cleanupDirectory=" + this.cleanupDirectory + ")";
        }
    }
}

