/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.plugin.debezium.models.Envelope;
import io.kestra.plugin.debezium.models.Message;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class MapConverter {
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();

    public static Pair<Message, Message> convert(SourceRecord record) {
        Object key = record.keySchema() == null ? MapConverter.convert(record.keySchema(), record.key()) : null;
        Object value = MapConverter.convert(record.valueSchema(), record.value());
        return Pair.of(key != null ? MAPPER.convertValue(key, Message.class) : null, value instanceof Envelope ? (Envelope)value : MAPPER.convertValue(value, Message.class));
    }

    /*
     * Unable to fully structure code
     */
    public static Object convert(Schema schema, Object value) {
        if (value == null) {
            if (schema == null) {
                return null;
            }
            if (schema.defaultValue() != null) {
                return MapConverter.convert(schema, schema.defaultValue());
            }
            if (schema.isOptional()) {
                return null;
            }
            throw new IllegalArgumentException("Conversion error: null value for field that is required and has no default value");
        }
        try {
            if (schema != null && schema.name() != null) {
                var2_2 = schema.name();
                var3_4 = -1;
                switch (var2_2.hashCode()) {
                    case 1032372852: {
                        if (!var2_2.equals("io.debezium.time.Date")) break;
                        var3_4 = 0;
                        break;
                    }
                    case -1526274933: {
                        if (!var2_2.equals("io.debezium.time.Interval")) break;
                        var3_4 = 1;
                        break;
                    }
                    case -805906318: {
                        if (!var2_2.equals("io.debezium.time.MicroDuration")) break;
                        var3_4 = 2;
                        break;
                    }
                    case -668140373: {
                        if (!var2_2.equals("io.debezium.time.MicroTime")) break;
                        var3_4 = 3;
                        break;
                    }
                    case -1830290952: {
                        if (!var2_2.equals("io.debezium.time.MicroTimestamp")) break;
                        var3_4 = 4;
                        break;
                    }
                    case 732685614: {
                        if (!var2_2.equals("io.debezium.time.NanoDuration")) break;
                        var3_4 = 5;
                        break;
                    }
                    case -218249369: {
                        if (!var2_2.equals("io.debezium.time.NanoTime")) break;
                        var3_4 = 6;
                        break;
                    }
                    case -1378581316: {
                        if (!var2_2.equals("io.debezium.time.NanoTimestamp")) break;
                        var3_4 = 7;
                        break;
                    }
                    case 1032856979: {
                        if (!var2_2.equals("io.debezium.time.Time")) break;
                        var3_4 = 8;
                        break;
                    }
                    case -517856752: {
                        if (!var2_2.equals("io.debezium.time.Timestamp")) break;
                        var3_4 = 9;
                        break;
                    }
                    case 1033001731: {
                        if (!var2_2.equals("io.debezium.time.Year")) break;
                        var3_4 = 10;
                        break;
                    }
                    case -33016289: {
                        if (!var2_2.equals("io.debezium.time.ZonedTime")) break;
                        var3_4 = 11;
                        break;
                    }
                    case -400914172: {
                        if (!var2_2.equals("io.debezium.time.ZonedTimestamp")) break;
                        var3_4 = 12;
                        break;
                    }
                    case 1010727247: {
                        if (!var2_2.equals("org.apache.kafka.connect.data.Decimal")) break;
                        var3_4 = 13;
                    }
                }
                switch (var3_4) {
                    case 0: {
                        if (!(value instanceof Integer)) {
                            throw new IllegalArgumentException("Invalid type for Date, expected Integer but was " + value.getClass() + " for '" + value + "'");
                        }
                        return LocalDate.ofEpochDay(((Integer)value).intValue());
                    }
                    case 1: {
                        if (!(value instanceof String)) {
                            throw new IllegalArgumentException("Invalid type for Interval, expected String but was " + value.getClass() + " for '" + value + "'");
                        }
                        return Period.parse((String)value);
                    }
                    case 2: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for MicroDuration, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return Duration.ofMillis((Long)value * 1000L);
                    }
                    case 3: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for MicroTime, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return LocalTime.ofNanoOfDay((Long)value * 1000L);
                    }
                    case 4: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for MicroTimestamp, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return Instant.ofEpochSecond(0L, (Long)value * 1000L);
                    }
                    case 5: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for NanoDuration, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return Duration.ofNanos((Long)value);
                    }
                    case 6: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for NanoTime, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return LocalTime.ofNanoOfDay((Long)value);
                    }
                    case 7: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for NanoTimestamp, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return Instant.ofEpochSecond(0L, (Long)value);
                    }
                    case 8: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for Timestamp, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return LocalTime.ofNanoOfDay((Long)value * 1000L * 1000L);
                    }
                    case 9: {
                        if (!(value instanceof Long)) {
                            throw new IllegalArgumentException("Invalid type for Timestamp, expected Long but was " + value.getClass() + " for '" + value + "'");
                        }
                        return Instant.ofEpochMilli((Long)value);
                    }
                    case 10: {
                        if (!(value instanceof Integer)) {
                            throw new IllegalArgumentException("Invalid type for Year, expected Integer but was " + value.getClass() + " for '" + value + "'");
                        }
                        return LocalDate.of((int)((Integer)value), 1, 1);
                    }
                    case 11: {
                        if (!(value instanceof String)) {
                            throw new IllegalArgumentException("Invalid type for ZonedTime, expected String but was " + value.getClass() + " for '" + value + "'");
                        }
                        return OffsetTime.parse((String)value);
                    }
                    case 12: {
                        if (!(value instanceof String)) {
                            throw new IllegalArgumentException("Invalid type for ZonedTimestamp, expected String but was " + value.getClass() + " for '" + value + "'");
                        }
                        return ZonedDateTime.parse((String)value);
                    }
                    case 13: {
                        if (!(value instanceof BigDecimal)) {
                            throw new IllegalArgumentException("Invalid type for Decimal, expected BigDecimal but was " + value.getClass() + " for '" + value + "'");
                        }
                        return (BigDecimal)value;
                    }
                }
            }
            if (schema == null) {
                schemaType = ConnectSchema.schemaType(value.getClass());
                if (schemaType == null) {
                    throw new IllegalArgumentException("Java class " + value.getClass() + " does not have corresponding schema type.");
                }
            } else {
                schemaType = schema.type();
            }
            switch (1.$SwitchMap$org$apache$kafka$connect$data$Schema$Type[schemaType.ordinal()]) {
                case 1: {
                    return (Byte)value;
                }
                case 2: {
                    return (Short)value;
                }
                case 3: {
                    return (Integer)value;
                }
                case 4: {
                    return (Long)value;
                }
                case 5: {
                    return (Float)value;
                }
                case 6: {
                    return (Double)value;
                }
                case 7: {
                    return (Boolean)value;
                }
                case 8: {
                    return (CharSequence)value;
                }
                case 9: {
                    if (value instanceof byte[]) {
                        return (byte[])value;
                    }
                    if (value instanceof ByteBuffer) {
                        return ((ByteBuffer)value).array();
                    }
                    throw new IllegalArgumentException("Invalid type for bytes type: " + value.getClass());
                }
                case 10: {
                    collection = (Collection)value;
                    list = new ArrayList<Object>();
                    for (E elem : collection) {
                        valueSchema = schema == null ? null : schema.valueSchema();
                        fieldValue = MapConverter.convert(valueSchema, elem);
                        list.add(fieldValue);
                    }
                    return list;
                }
                case 11: {
                    map = (Map)value;
                    if (schema != null) ** GOTO lbl174
                    objectMode = true;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        if (entry.getKey() instanceof String) continue;
                        objectMode = false;
                        ** GOTO lbl175
                    }
                    ** GOTO lbl175
lbl174:
                    // 1 sources

                    objectMode = schema.keySchema().type() == Schema.Type.STRING;
lbl175:
                    // 3 sources

                    obj = null;
                    list = null;
                    if (objectMode) {
                        obj = new LinkedHashMap<String, Object>();
                    } else {
                        list = new ArrayList<List<Object>>();
                    }
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        keySchema = schema == null ? null : schema.keySchema();
                        valueSchema = schema == null ? null : schema.valueSchema();
                        mapKey = MapConverter.convert(keySchema, entry.getKey());
                        mapValue = MapConverter.convert(valueSchema, entry.getValue());
                        if (objectMode) {
                            obj.put((String)mapKey, mapValue);
                            continue;
                        }
                        list.add(List.of(mapKey, mapValue));
                    }
                    return objectMode != false ? obj : list;
                }
                case 12: {
                    struct = (Struct)value;
                    if (!struct.schema().equals(schema)) {
                        throw new IllegalArgumentException("Mismatching schema.");
                    }
                    obj = new LinkedHashMap<String, Object>();
                    for (Field field : schema.fields()) {
                        obj.put(field.name(), MapConverter.convert(field.schema(), struct.get(field)));
                    }
                    if (schema.name() != null && io.debezium.data.Envelope.isEnvelopeSchema(schema)) {
                        return MapConverter.MAPPER.convertValue(obj, Envelope.class);
                    }
                    return obj;
                }
            }
            throw new IllegalArgumentException("Couldn't convert " + value + " to JSON.");
        }
        catch (ClassCastException e) {
            schemaTypeStr = schema != null ? schema.type().toString() : "unknown schema";
            throw new IllegalArgumentException("Invalid type for " + schemaTypeStr + ": " + value.getClass() + ", value:" + value, e);
        }
    }
}

