/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;

public class SchemaBuilderUtil {
    public static Schema jsonNodeToSchema(JsonNode document) {
        return SchemaBuilderUtil.jsonNodeToSchemaBuilder(document).build();
    }

    private static SchemaBuilder jsonNodeToSchemaBuilder(JsonNode document) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().optional();
        if (document != null) {
            Iterator<Map.Entry<String, JsonNode>> fieldsEntries = document.fields();
            while (fieldsEntries.hasNext()) {
                Map.Entry<String, JsonNode> fieldEntry = fieldsEntries.next();
                SchemaBuilderUtil.addFieldSchema(fieldEntry, schemaBuilder);
            }
        }
        return schemaBuilder;
    }

    private static void addFieldSchema(Map.Entry<String, JsonNode> fieldEntry, SchemaBuilder builder) {
        String fieldName = fieldEntry.getKey();
        JsonNode fieldValue = fieldEntry.getValue();
        Schema fieldSchema = SchemaBuilderUtil.jsonValueToSchema(fieldValue);
        if (fieldSchema != null && !SchemaBuilderUtil.hasField(builder, fieldName)) {
            builder.field(fieldName, fieldSchema);
        }
    }

    private static Schema jsonValueToSchema(JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case NUMBER: {
                if (node.isInt()) {
                    return Schema.OPTIONAL_INT32_SCHEMA;
                }
                if (node.isLong()) {
                    return Schema.OPTIONAL_INT64_SCHEMA;
                }
                if (node.isFloat()) {
                    return Schema.OPTIONAL_FLOAT64_SCHEMA;
                }
                if (node.isDouble()) {
                    return Schema.OPTIONAL_FLOAT64_SCHEMA;
                }
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)node;
                return arrayNode.isEmpty() ? null : SchemaBuilder.array(SchemaBuilderUtil.findArrayMemberSchema(arrayNode)).optional().build();
            }
            case OBJECT: {
                return SchemaBuilderUtil.jsonNodeToSchema(node);
            }
        }
        return null;
    }

    private static JsonNode getFirstArrayElement(ArrayNode array) throws ConnectException {
        JsonNode refNode = NullNode.getInstance();
        JsonNodeType refType = null;
        Iterator<JsonNode> elements = array.elements();
        while (elements.hasNext()) {
            JsonNode element = elements.next();
            if (refType == null) {
                refType = element.isNull() ? null : element.getNodeType();
                refNode = element;
                continue;
            }
            if (element.isNull() || element.getNodeType() == refType) continue;
            throw new ConnectException(String.format("Field is not a homogenous array (%s x %s).", refNode.asText(), element.getNodeType().toString()));
        }
        return refNode;
    }

    private static Schema findArrayMemberSchema(ArrayNode array) throws ConnectException {
        JsonNode sample = SchemaBuilderUtil.getFirstArrayElement(array);
        if (sample.isObject()) {
            return SchemaBuilderUtil.buildDocumentUnionSchema(array);
        }
        Schema schema = SchemaBuilderUtil.jsonValueToSchema(sample);
        if (schema == null) {
            throw new ConnectException(String.format("Array '%s' has unrecognized member schema.", array.asText()));
        }
        return schema;
    }

    private static Schema buildDocumentUnionSchema(ArrayNode array) {
        SchemaBuilder builder = null;
        Iterator<JsonNode> elements = array.elements();
        while (elements.hasNext()) {
            JsonNode element = elements.next();
            if (!element.isObject()) continue;
            if (builder == null) {
                builder = SchemaBuilderUtil.jsonNodeToSchemaBuilder(element);
                continue;
            }
            Iterator<Map.Entry<String, JsonNode>> fieldsEntries = element.fields();
            while (fieldsEntries.hasNext()) {
                Map.Entry<String, JsonNode> fieldEntry = fieldsEntries.next();
                SchemaBuilderUtil.addFieldSchema(fieldEntry, builder);
            }
        }
        return builder.build();
    }

    private static boolean hasField(SchemaBuilder builder, String fieldName) {
        return builder.field(fieldName) != null;
    }
}

