/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class VerifiableLog4jAppender {
    Logger logger = Logger.getLogger(VerifiableLog4jAppender.class);
    private long maxMessages = -1L;
    private volatile boolean stopLogging = false;

    private static ArgumentParser argParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser("verifiable-log4j-appender").defaultHelp(true).description("This tool produces increasing integers to the specified topic using KafkaLog4jAppender.");
        parser.addArgument("--topic").action(Arguments.store()).required(true).type(String.class).metavar("TOPIC").help("Produce messages to this topic.");
        parser.addArgument("--broker-list").action(Arguments.store()).required(true).type(String.class).metavar("HOST1:PORT1[,HOST2:PORT2[...]]").dest("brokerList").help("Comma-separated list of Kafka brokers in the form HOST1:PORT1,HOST2:PORT2,...");
        parser.addArgument("--max-messages").action(Arguments.store()).required(false).setDefault((Object)-1).type(Integer.class).metavar("MAX-MESSAGES").dest("maxMessages").help("Produce this many messages. If -1, produce messages until the process is killed externally.");
        parser.addArgument("--acks").action(Arguments.store()).required(false).setDefault("-1").type(String.class).choices("0", "1", "-1").metavar("ACKS").help("Acks required on each produced message. See Kafka docs on request.required.acks for details.");
        parser.addArgument("--security-protocol").action(Arguments.store()).required(false).setDefault("PLAINTEXT").type(String.class).choices("PLAINTEXT", "SSL", "SASL_PLAINTEXT", "SASL_SSL").metavar("SECURITY-PROTOCOL").dest("securityProtocol").help("Security protocol to be used while communicating with Kafka brokers.");
        parser.addArgument("--ssl-truststore-location").action(Arguments.store()).required(false).type(String.class).metavar("SSL-TRUSTSTORE-LOCATION").dest("sslTruststoreLocation").help("Location of SSL truststore to use.");
        parser.addArgument("--ssl-truststore-password").action(Arguments.store()).required(false).type(String.class).metavar("SSL-TRUSTSTORE-PASSWORD").dest("sslTruststorePassword").help("Password for SSL truststore to use.");
        parser.addArgument("--appender.config").action(Arguments.store()).required(false).type(String.class).metavar("CONFIG_FILE").help("Log4jAppender config properties file.");
        parser.addArgument("--sasl-kerberos-service-name").action(Arguments.store()).required(false).type(String.class).metavar("SASL-KERBEROS-SERVICE-NAME").dest("saslKerberosServiceName").help("Name of sasl kerberos service.");
        parser.addArgument("--client-jaas-conf-path").action(Arguments.store()).required(false).type(String.class).metavar("CLIENT-JAAS-CONF-PATH").dest("clientJaasConfPath").help("Path of JAAS config file of Kafka client.");
        parser.addArgument("--kerb5-conf-path").action(Arguments.store()).required(false).type(String.class).metavar("KERB5-CONF-PATH").dest("kerb5ConfPath").help("Path of Kerb5 config file.");
        return parser;
    }

    public static Properties loadProps(String filename) throws IOException {
        Properties props = new Properties();
        try (InputStream propStream = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            props.load(propStream);
        }
        return props;
    }

    public static VerifiableLog4jAppender createFromArgs(String[] args) {
        ArgumentParser parser = VerifiableLog4jAppender.argParser();
        VerifiableLog4jAppender producer = null;
        try {
            Namespace res = parser.parseArgs(args);
            int maxMessages = res.getInt("maxMessages");
            String topic = res.getString("topic");
            String configFile = res.getString("appender.config");
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "INFO, KAFKA");
            props.setProperty("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
            props.setProperty("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
            props.setProperty("log4j.appender.KAFKA.BrokerList", res.getString("brokerList"));
            props.setProperty("log4j.appender.KAFKA.Topic", topic);
            props.setProperty("log4j.appender.KAFKA.RequiredNumAcks", res.getString("acks"));
            props.setProperty("log4j.appender.KAFKA.SyncSend", "true");
            String securityProtocol = res.getString("securityProtocol");
            if (securityProtocol != null && !securityProtocol.equals(SecurityProtocol.PLAINTEXT.toString())) {
                props.setProperty("log4j.appender.KAFKA.SecurityProtocol", securityProtocol);
            }
            if (securityProtocol != null && securityProtocol.contains("SSL")) {
                props.setProperty("log4j.appender.KAFKA.SslTruststoreLocation", res.getString("sslTruststoreLocation"));
                props.setProperty("log4j.appender.KAFKA.SslTruststorePassword", res.getString("sslTruststorePassword"));
            }
            if (securityProtocol != null && securityProtocol.contains("SASL")) {
                props.setProperty("log4j.appender.KAFKA.SaslKerberosServiceName", res.getString("saslKerberosServiceName"));
                props.setProperty("log4j.appender.KAFKA.clientJaasConfPath", res.getString("clientJaasConfPath"));
                props.setProperty("log4j.appender.KAFKA.kerb5ConfPath", res.getString("kerb5ConfPath"));
            }
            props.setProperty("log4j.logger.kafka.log4j", "INFO, KAFKA");
            props.setProperty("log4j.logger.org.apache.kafka.clients.Metadata", "WARN, KAFKA");
            if (configFile != null) {
                try {
                    props.putAll((Map<?, ?>)VerifiableLog4jAppender.loadProps(configFile));
                }
                catch (IOException e) {
                    throw new ArgumentParserException(e.getMessage(), parser);
                }
            }
            producer = new VerifiableLog4jAppender(props, maxMessages);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit(0);
            }
            parser.handleError(e);
            Exit.exit(1);
        }
        return producer;
    }

    public VerifiableLog4jAppender(Properties props, int maxMessages) {
        this.maxMessages = maxMessages;
        PropertyConfigurator.configure((Properties)props);
    }

    public static void main(String[] args) {
        VerifiableLog4jAppender appender = VerifiableLog4jAppender.createFromArgs(args);
        boolean infinite = appender.maxMessages < 0L;
        Exit.addShutdownHook("verifiable-log4j-appender-shutdown-hook", () -> {
            appender.stopLogging = true;
        });
        long maxMessages = infinite ? Long.MAX_VALUE : appender.maxMessages;
        for (long i = 0L; i < maxMessages && !appender.stopLogging; ++i) {
            appender.append(String.format("%d", i));
        }
    }

    private void append(String msg) {
        this.logger.info((Object)msg);
    }
}

