/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import io.debezium.embedded.Connect;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.ExecutorsUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.debezium.AbstractDebeziumInterface;
import io.kestra.plugin.debezium.ChangeConsumer;
import io.kestra.plugin.debezium.CompletionCallback;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDebeziumTask
extends Task
implements RunnableTask<Output>,
AbstractDebeziumInterface {
    protected Format format;
    protected Deleted deleted;
    protected String deletedFieldName;
    protected Key key;
    protected Metadata metadata;
    protected String metadataFieldName;
    protected SplitTable splitTable;
    protected Boolean ignoreDdl;
    protected String hostname;
    protected String port;
    protected String username;
    protected String password;
    private Object includedDatabases;
    private Object excludedDatabases;
    private Object includedTables;
    private Object excludedTables;
    private Object includedColumns;
    private Object excludedColumns;
    private Map<String, String> properties;
    protected String stateName;
    private Integer maxRecords;
    private Duration maxDuration;
    private Duration maxWait;

    protected abstract boolean needDatabaseHistory();

    public Output run(RunContext runContext) throws Exception {
        ExecutorService executorService = ((ExecutorsUtils)runContext.getApplicationContext().getBean(ExecutorsUtils.class)).singleThreadExecutor(this.getClass().getSimpleName());
        AtomicInteger count = new AtomicInteger();
        ZonedDateTime started = ZonedDateTime.now();
        ZonedDateTime lastRecord = ZonedDateTime.now();
        Path offsetFile = runContext.tempDir().resolve("offsets.dat");
        this.restoreState(runContext, offsetFile);
        Path historyFile = runContext.tempDir().resolve("dbhistory.dat");
        if (this.needDatabaseHistory()) {
            this.restoreState(runContext, historyFile);
        }
        Properties props = this.properties(runContext, offsetFile, historyFile);
        CompletionCallback completionCallback = new CompletionCallback(runContext, executorService);
        ChangeConsumer changeConsumer = new ChangeConsumer(this, runContext, count, lastRecord);
        try (DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>> engine = DebeziumEngine.create(Connect.class).using(props).notifying(changeConsumer).using(completionCallback).using(this.getClass().getClassLoader()).build();){
            executorService.execute(engine);
            Await.until(() -> this.ended(executorService, count, started, lastRecord), (Duration)Duration.ofSeconds(1L));
        }
        this.shutdown(runContext.logger(), executorService);
        if (completionCallback.getError() != null) {
            throw new Exception(completionCallback.getError());
        }
        Output.OutputBuilder outputBuilder = Output.builder();
        if (offsetFile.toFile().exists()) {
            outputBuilder.stateOffset(runContext.putTaskStateFile(offsetFile.toFile(), this.stateName, offsetFile.getFileName().toFile().toString()));
        }
        if (this.needDatabaseHistory()) {
            outputBuilder.stateHistory(runContext.putTaskStateFile(historyFile.toFile(), this.stateName, historyFile.getFileName().toFile().toString()));
        }
        outputBuilder.uris(changeConsumer.getRecords().entrySet().stream().map(Rethrow.throwFunction(e -> {
            ((OutputStream)((Pair)e.getValue()).getRight()).flush();
            ((OutputStream)((Pair)e.getValue()).getRight()).close();
            return new AbstractMap.SimpleEntry<String, URI>((String)e.getKey(), runContext.putTempFile((File)((Pair)e.getValue()).getLeft()));
        })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        changeConsumer.getRecordsCount().forEach((s, atomicInteger) -> runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Integer)atomicInteger.get(), (String[])new String[]{"source", s})));
        runContext.logger().info("Ended after receiving {} records: {}", (Object)changeConsumer.getRecordsCount().values().stream().mapToLong(AtomicInteger::get).sum(), (Object)changeConsumer.getRecordsCount());
        return outputBuilder.size(count.get()).build();
    }

    protected Properties properties(RunContext runContext, Path offsetFile, Path historyFile) throws Exception {
        Properties props = new Properties();
        props.setProperty("name", "engine");
        props.setProperty("offset.storage", "org.apache.kafka.connect.storage.FileOffsetBackingStore");
        props.setProperty("offset.storage.file.filename", offsetFile.toAbsolutePath().toString());
        props.setProperty("offset.flush.interval.ms", "1000");
        props.setProperty("database.server.name", "kestra");
        if (this.needDatabaseHistory()) {
            props.setProperty("database.history", "io.debezium.relational.history.FileDatabaseHistory");
            props.setProperty("database.history.file.filename", historyFile.toAbsolutePath().toString());
        }
        props.setProperty("database.hostname", runContext.render(this.hostname));
        props.setProperty("database.port", runContext.render(this.port));
        if (this.username != null) {
            props.setProperty("database.user", runContext.render(this.username));
        }
        if (this.password != null) {
            props.setProperty("database.password", runContext.render(this.password));
        }
        props.setProperty("key.converter.schemas.enable", "false");
        props.setProperty("value.converter.schemas.enable", "false");
        props.setProperty("tombstones.on.delete", "false");
        if (this.includedDatabases != null) {
            props.setProperty("database.include.list", AbstractDebeziumTask.joinProperties(runContext, this.includedDatabases));
        }
        if (this.excludedDatabases != null) {
            props.setProperty("database.exclude.list", AbstractDebeziumTask.joinProperties(runContext, this.excludedDatabases));
        }
        if (this.includedTables != null) {
            props.setProperty("table.include.list", AbstractDebeziumTask.joinProperties(runContext, this.includedTables));
        }
        if (this.excludedTables != null) {
            props.setProperty("table.exclude.list", AbstractDebeziumTask.joinProperties(runContext, this.excludedTables));
        }
        if (this.includedColumns != null) {
            props.setProperty("column.include.list", AbstractDebeziumTask.joinProperties(runContext, this.includedColumns));
        }
        if (this.excludedColumns != null) {
            props.setProperty("column.exclude.list", AbstractDebeziumTask.joinProperties(runContext, this.excludedColumns));
        }
        if (this.properties != null) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                props.setProperty(runContext.render(entry.getKey()), runContext.render(entry.getValue()));
            }
        }
        return props;
    }

    protected static String joinProperties(RunContext runContext, Object raw) {
        List<String> value = raw instanceof Collection ? (List<String>)raw : List.of((String)raw);
        return value.stream().map(x -> x.replaceAll(",", "\\,")).collect(Collectors.joining(","));
    }

    private boolean ended(ExecutorService executorService, AtomicInteger count, ZonedDateTime start, ZonedDateTime lastRecord) {
        if (executorService.isShutdown()) {
            return true;
        }
        if (this.maxRecords != null && count.get() >= this.maxRecords) {
            return true;
        }
        if (this.maxDuration != null && ZonedDateTime.now().toEpochSecond() > start.plus(this.maxDuration).toEpochSecond()) {
            return true;
        }
        return this.maxWait != null && ZonedDateTime.now().toEpochSecond() > lastRecord.plus(this.maxWait).toEpochSecond();
    }

    private void restoreState(RunContext runContext, Path path) throws IOException {
        try {
            InputStream taskStateFile = runContext.getTaskStateFile(this.stateName, path.getFileName().toString());
            FileUtils.copyInputStreamToFile((InputStream)taskStateFile, (File)path.toFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void shutdown(Logger logger, ExecutorService executorService) {
        try {
            executorService.shutdown();
            while (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                logger.trace("Waiting another 5 seconds for the embedded engine to shut down");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    private static Format $default$format() {
        return Format.INLINE;
    }

    @Generated
    private static Deleted $default$deleted() {
        return Deleted.ADD_FIELD;
    }

    @Generated
    private static String $default$deletedFieldName() {
        return "deleted";
    }

    @Generated
    private static Key $default$key() {
        return Key.ADD_FIELD;
    }

    @Generated
    private static Metadata $default$metadata() {
        return Metadata.ADD_FIELD;
    }

    @Generated
    private static String $default$metadataFieldName() {
        return "metadata";
    }

    @Generated
    private static SplitTable $default$splitTable() {
        return SplitTable.TABLE;
    }

    @Generated
    private static Boolean $default$ignoreDdl() {
        return true;
    }

    @Generated
    private static String $default$stateName() {
        return "debezium-state";
    }

    @Generated
    private static Duration $default$maxWait() {
        return Duration.ofSeconds(10L);
    }

    @Generated
    protected AbstractDebeziumTask(AbstractDebeziumTaskBuilder<?, ?> b) {
        super(b);
        this.format = b.format$set ? b.format$value : AbstractDebeziumTask.$default$format();
        this.deleted = b.deleted$set ? b.deleted$value : AbstractDebeziumTask.$default$deleted();
        this.deletedFieldName = b.deletedFieldName$set ? b.deletedFieldName$value : AbstractDebeziumTask.$default$deletedFieldName();
        this.key = b.key$set ? b.key$value : AbstractDebeziumTask.$default$key();
        this.metadata = b.metadata$set ? b.metadata$value : AbstractDebeziumTask.$default$metadata();
        this.metadataFieldName = b.metadataFieldName$set ? b.metadataFieldName$value : AbstractDebeziumTask.$default$metadataFieldName();
        this.splitTable = b.splitTable$set ? b.splitTable$value : AbstractDebeziumTask.$default$splitTable();
        this.ignoreDdl = b.ignoreDdl$set ? b.ignoreDdl$value : AbstractDebeziumTask.$default$ignoreDdl();
        this.hostname = b.hostname;
        this.port = b.port;
        this.username = b.username;
        this.password = b.password;
        this.includedDatabases = b.includedDatabases;
        this.excludedDatabases = b.excludedDatabases;
        this.includedTables = b.includedTables;
        this.excludedTables = b.excludedTables;
        this.includedColumns = b.includedColumns;
        this.excludedColumns = b.excludedColumns;
        this.properties = b.properties;
        this.stateName = b.stateName$set ? b.stateName$value : AbstractDebeziumTask.$default$stateName();
        this.maxRecords = b.maxRecords;
        this.maxDuration = b.maxDuration;
        this.maxWait = b.maxWait$set ? b.maxWait$value : AbstractDebeziumTask.$default$maxWait();
    }

    @Generated
    public String toString() {
        return "AbstractDebeziumTask(super=" + super.toString() + ", format=" + this.getFormat() + ", deleted=" + this.getDeleted() + ", deletedFieldName=" + this.getDeletedFieldName() + ", key=" + this.getKey() + ", metadata=" + this.getMetadata() + ", metadataFieldName=" + this.getMetadataFieldName() + ", splitTable=" + this.getSplitTable() + ", ignoreDdl=" + this.getIgnoreDdl() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", includedDatabases=" + this.getIncludedDatabases() + ", excludedDatabases=" + this.getExcludedDatabases() + ", includedTables=" + this.getIncludedTables() + ", excludedTables=" + this.getExcludedTables() + ", includedColumns=" + this.getIncludedColumns() + ", excludedColumns=" + this.getExcludedColumns() + ", properties=" + this.getProperties() + ", stateName=" + this.getStateName() + ", maxRecords=" + this.getMaxRecords() + ", maxDuration=" + this.getMaxDuration() + ", maxWait=" + this.getMaxWait() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDebeziumTask)) {
            return false;
        }
        AbstractDebeziumTask other = (AbstractDebeziumTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDdl = this.getIgnoreDdl();
        Boolean other$ignoreDdl = other.getIgnoreDdl();
        if (this$ignoreDdl == null ? other$ignoreDdl != null : !((Object)this$ignoreDdl).equals(other$ignoreDdl)) {
            return false;
        }
        Integer this$maxRecords = this.getMaxRecords();
        Integer other$maxRecords = other.getMaxRecords();
        if (this$maxRecords == null ? other$maxRecords != null : !((Object)this$maxRecords).equals(other$maxRecords)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
            return false;
        }
        Deleted this$deleted = this.getDeleted();
        Deleted other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)((Object)this$deleted)).equals((Object)other$deleted)) {
            return false;
        }
        String this$deletedFieldName = this.getDeletedFieldName();
        String other$deletedFieldName = other.getDeletedFieldName();
        if (this$deletedFieldName == null ? other$deletedFieldName != null : !this$deletedFieldName.equals(other$deletedFieldName)) {
            return false;
        }
        Key this$key = this.getKey();
        Key other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)((Object)this$key)).equals((Object)other$key)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)((Object)this$metadata)).equals((Object)other$metadata)) {
            return false;
        }
        String this$metadataFieldName = this.getMetadataFieldName();
        String other$metadataFieldName = other.getMetadataFieldName();
        if (this$metadataFieldName == null ? other$metadataFieldName != null : !this$metadataFieldName.equals(other$metadataFieldName)) {
            return false;
        }
        SplitTable this$splitTable = this.getSplitTable();
        SplitTable other$splitTable = other.getSplitTable();
        if (this$splitTable == null ? other$splitTable != null : !((Object)((Object)this$splitTable)).equals((Object)other$splitTable)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Object this$includedDatabases = this.getIncludedDatabases();
        Object other$includedDatabases = other.getIncludedDatabases();
        if (this$includedDatabases == null ? other$includedDatabases != null : !this$includedDatabases.equals(other$includedDatabases)) {
            return false;
        }
        Object this$excludedDatabases = this.getExcludedDatabases();
        Object other$excludedDatabases = other.getExcludedDatabases();
        if (this$excludedDatabases == null ? other$excludedDatabases != null : !this$excludedDatabases.equals(other$excludedDatabases)) {
            return false;
        }
        Object this$includedTables = this.getIncludedTables();
        Object other$includedTables = other.getIncludedTables();
        if (this$includedTables == null ? other$includedTables != null : !this$includedTables.equals(other$includedTables)) {
            return false;
        }
        Object this$excludedTables = this.getExcludedTables();
        Object other$excludedTables = other.getExcludedTables();
        if (this$excludedTables == null ? other$excludedTables != null : !this$excludedTables.equals(other$excludedTables)) {
            return false;
        }
        Object this$includedColumns = this.getIncludedColumns();
        Object other$includedColumns = other.getIncludedColumns();
        if (this$includedColumns == null ? other$includedColumns != null : !this$includedColumns.equals(other$includedColumns)) {
            return false;
        }
        Object this$excludedColumns = this.getExcludedColumns();
        Object other$excludedColumns = other.getExcludedColumns();
        if (this$excludedColumns == null ? other$excludedColumns != null : !this$excludedColumns.equals(other$excludedColumns)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$stateName = this.getStateName();
        String other$stateName = other.getStateName();
        if (this$stateName == null ? other$stateName != null : !this$stateName.equals(other$stateName)) {
            return false;
        }
        Duration this$maxDuration = this.getMaxDuration();
        Duration other$maxDuration = other.getMaxDuration();
        if (this$maxDuration == null ? other$maxDuration != null : !((Object)this$maxDuration).equals(other$maxDuration)) {
            return false;
        }
        Duration this$maxWait = this.getMaxWait();
        Duration other$maxWait = other.getMaxWait();
        return !(this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractDebeziumTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDdl = this.getIgnoreDdl();
        result = result * 59 + ($ignoreDdl == null ? 43 : ((Object)$ignoreDdl).hashCode());
        Integer $maxRecords = this.getMaxRecords();
        result = result * 59 + ($maxRecords == null ? 43 : ((Object)$maxRecords).hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        Deleted $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)((Object)$deleted)).hashCode());
        String $deletedFieldName = this.getDeletedFieldName();
        result = result * 59 + ($deletedFieldName == null ? 43 : $deletedFieldName.hashCode());
        Key $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)((Object)$key)).hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)((Object)$metadata)).hashCode());
        String $metadataFieldName = this.getMetadataFieldName();
        result = result * 59 + ($metadataFieldName == null ? 43 : $metadataFieldName.hashCode());
        SplitTable $splitTable = this.getSplitTable();
        result = result * 59 + ($splitTable == null ? 43 : ((Object)((Object)$splitTable)).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Object $includedDatabases = this.getIncludedDatabases();
        result = result * 59 + ($includedDatabases == null ? 43 : $includedDatabases.hashCode());
        Object $excludedDatabases = this.getExcludedDatabases();
        result = result * 59 + ($excludedDatabases == null ? 43 : $excludedDatabases.hashCode());
        Object $includedTables = this.getIncludedTables();
        result = result * 59 + ($includedTables == null ? 43 : $includedTables.hashCode());
        Object $excludedTables = this.getExcludedTables();
        result = result * 59 + ($excludedTables == null ? 43 : $excludedTables.hashCode());
        Object $includedColumns = this.getIncludedColumns();
        result = result * 59 + ($includedColumns == null ? 43 : $includedColumns.hashCode());
        Object $excludedColumns = this.getExcludedColumns();
        result = result * 59 + ($excludedColumns == null ? 43 : $excludedColumns.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $stateName = this.getStateName();
        result = result * 59 + ($stateName == null ? 43 : $stateName.hashCode());
        Duration $maxDuration = this.getMaxDuration();
        result = result * 59 + ($maxDuration == null ? 43 : ((Object)$maxDuration).hashCode());
        Duration $maxWait = this.getMaxWait();
        result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
        return result;
    }

    @Override
    @Generated
    public Format getFormat() {
        return this.format;
    }

    @Override
    @Generated
    public Deleted getDeleted() {
        return this.deleted;
    }

    @Override
    @Generated
    public String getDeletedFieldName() {
        return this.deletedFieldName;
    }

    @Override
    @Generated
    public Key getKey() {
        return this.key;
    }

    @Override
    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @Generated
    public String getMetadataFieldName() {
        return this.metadataFieldName;
    }

    @Override
    @Generated
    public SplitTable getSplitTable() {
        return this.splitTable;
    }

    @Override
    @Generated
    public Boolean getIgnoreDdl() {
        return this.ignoreDdl;
    }

    @Override
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public String getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Object getIncludedDatabases() {
        return this.includedDatabases;
    }

    @Override
    @Generated
    public Object getExcludedDatabases() {
        return this.excludedDatabases;
    }

    @Override
    @Generated
    public Object getIncludedTables() {
        return this.includedTables;
    }

    @Override
    @Generated
    public Object getExcludedTables() {
        return this.excludedTables;
    }

    @Override
    @Generated
    public Object getIncludedColumns() {
        return this.includedColumns;
    }

    @Override
    @Generated
    public Object getExcludedColumns() {
        return this.excludedColumns;
    }

    @Override
    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    @Generated
    public String getStateName() {
        return this.stateName;
    }

    @Override
    @Generated
    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    @Override
    @Generated
    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    @Generated
    public Duration getMaxWait() {
        return this.maxWait;
    }

    @Generated
    public AbstractDebeziumTask() {
        this.format = AbstractDebeziumTask.$default$format();
        this.deleted = AbstractDebeziumTask.$default$deleted();
        this.deletedFieldName = AbstractDebeziumTask.$default$deletedFieldName();
        this.key = AbstractDebeziumTask.$default$key();
        this.metadata = AbstractDebeziumTask.$default$metadata();
        this.metadataFieldName = AbstractDebeziumTask.$default$metadataFieldName();
        this.splitTable = AbstractDebeziumTask.$default$splitTable();
        this.ignoreDdl = AbstractDebeziumTask.$default$ignoreDdl();
        this.stateName = AbstractDebeziumTask.$default$stateName();
        this.maxWait = AbstractDebeziumTask.$default$maxWait();
    }

    static {
        LoggerFactory.getLogger("org.apache.kafka.connect");
        LoggerFactory.getLogger("io.debezium");
        ((LoggerContext)LoggerFactory.getILoggerFactory()).getLoggerList().stream().filter(logger -> logger.getName().startsWith("org.apache.kafka.connect") || logger.getName().startsWith("io.debezium")).forEach(logger -> logger.setLevel(Level.ERROR));
    }

    @Generated
    public static abstract class AbstractDebeziumTaskBuilder<C extends AbstractDebeziumTask, B extends AbstractDebeziumTaskBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean format$set;
        @Generated
        private Format format$value;
        @Generated
        private boolean deleted$set;
        @Generated
        private Deleted deleted$value;
        @Generated
        private boolean deletedFieldName$set;
        @Generated
        private String deletedFieldName$value;
        @Generated
        private boolean key$set;
        @Generated
        private Key key$value;
        @Generated
        private boolean metadata$set;
        @Generated
        private Metadata metadata$value;
        @Generated
        private boolean metadataFieldName$set;
        @Generated
        private String metadataFieldName$value;
        @Generated
        private boolean splitTable$set;
        @Generated
        private SplitTable splitTable$value;
        @Generated
        private boolean ignoreDdl$set;
        @Generated
        private Boolean ignoreDdl$value;
        @Generated
        private String hostname;
        @Generated
        private String port;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private Object includedDatabases;
        @Generated
        private Object excludedDatabases;
        @Generated
        private Object includedTables;
        @Generated
        private Object excludedTables;
        @Generated
        private Object includedColumns;
        @Generated
        private Object excludedColumns;
        @Generated
        private Map<String, String> properties;
        @Generated
        private boolean stateName$set;
        @Generated
        private String stateName$value;
        @Generated
        private Integer maxRecords;
        @Generated
        private Duration maxDuration;
        @Generated
        private boolean maxWait$set;
        @Generated
        private Duration maxWait$value;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B format(Format format) {
            this.format$value = format;
            this.format$set = true;
            return (B)this.self();
        }

        @Generated
        public B deleted(Deleted deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return (B)this.self();
        }

        @Generated
        public B deletedFieldName(String deletedFieldName) {
            this.deletedFieldName$value = deletedFieldName;
            this.deletedFieldName$set = true;
            return (B)this.self();
        }

        @Generated
        public B key(Key key) {
            this.key$value = key;
            this.key$set = true;
            return (B)this.self();
        }

        @Generated
        public B metadata(Metadata metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return (B)this.self();
        }

        @Generated
        public B metadataFieldName(String metadataFieldName) {
            this.metadataFieldName$value = metadataFieldName;
            this.metadataFieldName$set = true;
            return (B)this.self();
        }

        @Generated
        public B splitTable(SplitTable splitTable) {
            this.splitTable$value = splitTable;
            this.splitTable$set = true;
            return (B)this.self();
        }

        @Generated
        public B ignoreDdl(Boolean ignoreDdl) {
            this.ignoreDdl$value = ignoreDdl;
            this.ignoreDdl$set = true;
            return (B)this.self();
        }

        @Generated
        public B hostname(String hostname) {
            this.hostname = hostname;
            return (B)this.self();
        }

        @Generated
        public B port(String port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B includedDatabases(Object includedDatabases) {
            this.includedDatabases = includedDatabases;
            return (B)this.self();
        }

        @Generated
        public B excludedDatabases(Object excludedDatabases) {
            this.excludedDatabases = excludedDatabases;
            return (B)this.self();
        }

        @Generated
        public B includedTables(Object includedTables) {
            this.includedTables = includedTables;
            return (B)this.self();
        }

        @Generated
        public B excludedTables(Object excludedTables) {
            this.excludedTables = excludedTables;
            return (B)this.self();
        }

        @Generated
        public B includedColumns(Object includedColumns) {
            this.includedColumns = includedColumns;
            return (B)this.self();
        }

        @Generated
        public B excludedColumns(Object excludedColumns) {
            this.excludedColumns = excludedColumns;
            return (B)this.self();
        }

        @Generated
        public B properties(Map<String, String> properties) {
            this.properties = properties;
            return (B)this.self();
        }

        @Generated
        public B stateName(String stateName) {
            this.stateName$value = stateName;
            this.stateName$set = true;
            return (B)this.self();
        }

        @Generated
        public B maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return (B)this.self();
        }

        @Generated
        public B maxDuration(Duration maxDuration) {
            this.maxDuration = maxDuration;
            return (B)this.self();
        }

        @Generated
        public B maxWait(Duration maxWait) {
            this.maxWait$value = maxWait;
            this.maxWait$set = true;
            return (B)this.self();
        }

        @Generated
        public String toString() {
            return "AbstractDebeziumTask.AbstractDebeziumTaskBuilder(super=" + super.toString() + ", format$value=" + this.format$value + ", deleted$value=" + this.deleted$value + ", deletedFieldName$value=" + this.deletedFieldName$value + ", key$value=" + this.key$value + ", metadata$value=" + this.metadata$value + ", metadataFieldName$value=" + this.metadataFieldName$value + ", splitTable$value=" + this.splitTable$value + ", ignoreDdl$value=" + this.ignoreDdl$value + ", hostname=" + this.hostname + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", includedDatabases=" + this.includedDatabases + ", excludedDatabases=" + this.excludedDatabases + ", includedTables=" + this.includedTables + ", excludedTables=" + this.excludedTables + ", includedColumns=" + this.includedColumns + ", excludedColumns=" + this.excludedColumns + ", properties=" + this.properties + ", stateName$value=" + this.stateName$value + ", maxRecords=" + this.maxRecords + ", maxDuration=" + this.maxDuration + ", maxWait$value=" + this.maxWait$value + ")";
        }
    }

    @Introspected
    public static enum SplitTable {
        OFF,
        DATABASE,
        TABLE;

    }

    @Introspected
    public static enum Deleted {
        ADD_FIELD,
        NULL,
        DROP;

    }

    @Introspected
    public static enum Format {
        RAW,
        INLINE,
        WRAP;

    }

    @Introspected
    public static enum Metadata {
        ADD_FIELD,
        DROP;

    }

    @Introspected
    public static enum Key {
        ADD_FIELD,
        DROP;

    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The state with offset")
        private URI stateOffset;
        @Schema(title="The state with database history")
        private URI stateHistory;
        @Schema(title="The size of the rows fetch")
        private Integer size;
        @Schema(title="Uri of the generated internal storage file")
        @PluginProperty(additionalProperties=URI.class)
        private final Map<String, URI> uris;

        @ConstructorProperties(value={"stateOffset", "stateHistory", "size", "uris"})
        @Generated
        Output(URI stateOffset, URI stateHistory, Integer size, Map<String, URI> uris) {
            this.stateOffset = stateOffset;
            this.stateHistory = stateHistory;
            this.size = size;
            this.uris = uris;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getStateOffset() {
            return this.stateOffset;
        }

        @Generated
        public URI getStateHistory() {
            return this.stateHistory;
        }

        @Generated
        public Integer getSize() {
            return this.size;
        }

        @Generated
        public Map<String, URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI stateOffset;
            @Generated
            private URI stateHistory;
            @Generated
            private Integer size;
            @Generated
            private Map<String, URI> uris;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder stateOffset(URI stateOffset) {
                this.stateOffset = stateOffset;
                return this;
            }

            @Generated
            public OutputBuilder stateHistory(URI stateHistory) {
                this.stateHistory = stateHistory;
                return this;
            }

            @Generated
            public OutputBuilder size(Integer size) {
                this.size = size;
                return this;
            }

            @Generated
            public OutputBuilder uris(Map<String, URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.stateOffset, this.stateHistory, this.size, this.uris);
            }

            @Generated
            public String toString() {
                return "AbstractDebeziumTask.Output.OutputBuilder(stateOffset=" + this.stateOffset + ", stateHistory=" + this.stateHistory + ", size=" + this.size + ", uris=" + this.uris + ")";
            }
        }
    }
}

