/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample.dependent;

import io.fabric8.kubernetes.api.model.Secret;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.ConfigurationConverter;
import io.javaoperatorsdk.operator.api.config.dependent.Configured;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.DependentResourceConfigurator;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.external.PerResourcePollingDependentResource;
import io.javaoperatorsdk.operator.sample.MySQLDbConfig;
import io.javaoperatorsdk.operator.sample.MySQLSchema;
import io.javaoperatorsdk.operator.sample.SchemaSpec;
import io.javaoperatorsdk.operator.sample.SchemaStatus;
import io.javaoperatorsdk.operator.sample.dependent.ResourcePollerConfig;
import io.javaoperatorsdk.operator.sample.dependent.SchemaConfig;
import io.javaoperatorsdk.operator.sample.schema.Schema;
import io.javaoperatorsdk.operator.sample.schema.SchemaService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SchemaConfig(pollPeriod=700, host="127.0.0.1", port=3307, user="root", password="password")
@Configured(by=SchemaConfig.class, with=ResourcePollerConfig.class, converter=ResourcePollerConfigConverter.class)
public class SchemaDependentResource
extends PerResourcePollingDependentResource<Schema, MySQLSchema>
implements DependentResourceConfigurator<ResourcePollerConfig>,
Creator<Schema, MySQLSchema>,
Deleter<MySQLSchema> {
    public static final String NAME = "schema";
    public static final int LOCAL_PORT = 3307;
    private static final Logger log = LoggerFactory.getLogger(SchemaDependentResource.class);
    private MySQLDbConfig dbConfig;

    public SchemaDependentResource() {
        super(Schema.class);
    }

    public Optional<ResourcePollerConfig> configuration() {
        return Optional.of(new ResourcePollerConfig((int)this.getPollingPeriod(), this.dbConfig));
    }

    public void configureWith(ResourcePollerConfig config) {
        this.dbConfig = config.getMySQLDbConfig();
        this.setPollingPeriod(config.getPollPeriod());
    }

    public Schema desired(MySQLSchema primary, Context<MySQLSchema> context) {
        return new Schema(primary.getMetadata().getName(), ((SchemaSpec)primary.getSpec()).getEncoding());
    }

    public Schema create(Schema target, MySQLSchema mySQLSchema, Context<MySQLSchema> context) {
        Schema schema;
        block8: {
            Connection connection = this.getConnection();
            try {
                Secret secret = (Secret)context.getSecondaryResource(Secret.class).orElseThrow();
                String username = SchemaDependentResource.decode((String)secret.getData().get("mysql.secret.user.name"));
                String password = SchemaDependentResource.decode((String)secret.getData().get("mysql.secret.user.password"));
                schema = SchemaService.createSchemaAndRelatedUser(connection, target.getName(), target.getCharacterSet(), username, password);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error("Error while creating Schema", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
            connection.close();
        }
        return schema;
    }

    private Connection getConnection() throws SQLException {
        String connectURL = String.format("jdbc:mysql://%1$s:%2$s", this.dbConfig.getHost(), this.dbConfig.getPort());
        log.debug("Connecting to '{}' with user '{}'", (Object)connectURL, (Object)this.dbConfig.getUser());
        return DriverManager.getConnection(connectURL, this.dbConfig.getUser(), this.dbConfig.getPassword());
    }

    public void delete(MySQLSchema primary, Context<MySQLSchema> context) {
        try (Connection connection = this.getConnection();){
            String userName = primary.getStatus() != null ? ((SchemaStatus)((Object)primary.getStatus())).getUserName() : null;
            SchemaService.deleteSchemaAndRelatedUser(connection, primary.getMetadata().getName(), userName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while trying to delete Schema", e);
        }
    }

    public static String decode(String value) {
        return new String(Base64.getDecoder().decode(value.getBytes()));
    }

    public Set<Schema> fetchResources(MySQLSchema primaryResource) {
        Set<Schema> set;
        block8: {
            Connection connection = this.getConnection();
            try {
                set = SchemaService.getSchema(connection, primaryResource.getMetadata().getName()).map(Set::of).orElse(Collections.emptySet());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error while trying read Schema", e);
                }
            }
            connection.close();
        }
        return set;
    }

    static class ResourcePollerConfigConverter
    implements ConfigurationConverter<SchemaConfig, ResourcePollerConfig, SchemaDependentResource> {
        ResourcePollerConfigConverter() {
        }

        public ResourcePollerConfig configFrom(SchemaConfig configAnnotation, ControllerConfiguration<?> parentConfiguration, Class<SchemaDependentResource> originatingClass) {
            if (configAnnotation != null) {
                return new ResourcePollerConfig(configAnnotation.pollPeriod(), new MySQLDbConfig(configAnnotation.host(), "" + configAnnotation.port(), configAnnotation.user(), configAnnotation.password()));
            }
            return new ResourcePollerConfig(500, MySQLDbConfig.loadFromEnvironmentVars());
        }
    }
}

