/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.monitoring.micrometer.MicrometerMetrics;
import io.javaoperatorsdk.operator.sample.MySQLDbConfig;
import io.javaoperatorsdk.operator.sample.MySQLSchemaReconciler;
import io.javaoperatorsdk.operator.sample.dependent.ResourcePollerConfig;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.logging.LoggingMeterRegistry;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.takes.Take;
import org.takes.facets.fork.FkRegex;
import org.takes.facets.fork.Fork;
import org.takes.facets.fork.TkFork;
import org.takes.http.Exit;
import org.takes.http.FtBasic;

public class MySQLSchemaOperator {
    private static final Logger log = LoggerFactory.getLogger(MySQLSchemaOperator.class);

    public static void main(String[] args) throws IOException {
        log.info("MySQL Schema Operator starting");
        KubernetesClient client = new KubernetesClientBuilder().build();
        Operator operator = new Operator(client, overrider -> overrider.withMetrics((Metrics)new MicrometerMetrics((MeterRegistry)new LoggingMeterRegistry())));
        MySQLSchemaReconciler schemaReconciler = new MySQLSchemaReconciler();
        operator.register((Reconciler)schemaReconciler, configOverrider -> configOverrider.replacingNamedDependentResourceConfig("schema", (Object)new ResourcePollerConfig(300, MySQLDbConfig.loadFromEnvironmentVars())));
        operator.installShutdownHook();
        operator.start();
        new FtBasic((Take)new TkFork(new Fork[]{new FkRegex("/health", "ALL GOOD!")}), 8080).start(Exit.NEVER);
    }
}

