/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample.dependent;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.sample.MySQLSchema;
import java.util.Base64;
import org.apache.commons.lang3.RandomStringUtils;

public class SecretDependentResource
extends KubernetesDependentResource<Secret, MySQLSchema>
implements Creator<Secret, MySQLSchema> {
    public static final String SECRET_FORMAT = "%s-secret";
    public static final String USERNAME_FORMAT = "%s-user";
    public static final String MYSQL_SECRET_USERNAME = "mysql.secret.user.name";
    public static final String MYSQL_SECRET_PASSWORD = "mysql.secret.user.password";

    public SecretDependentResource() {
        super(Secret.class);
    }

    private static String encode(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes());
    }

    protected Secret desired(MySQLSchema schema, Context<MySQLSchema> context) {
        String password = RandomStringUtils.randomAlphanumeric((int)16);
        String name = schema.getMetadata().getName();
        String secretName = this.getSecretName(name);
        String userName = String.format(USERNAME_FORMAT, name);
        return ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(secretName)).withNamespace(schema.getMetadata().getNamespace())).endMetadata()).addToData(MYSQL_SECRET_USERNAME, SecretDependentResource.encode(userName))).addToData(MYSQL_SECRET_PASSWORD, SecretDependentResource.encode(password))).build();
    }

    private String getSecretName(String schemaName) {
        return String.format(SECRET_FORMAT, schemaName);
    }

    public Matcher.Result<Secret> match(Secret actual, MySQLSchema primary, Context<MySQLSchema> context) {
        String desiredSecretName = this.getSecretName(primary.getMetadata().getName());
        return Matcher.Result.nonComputed((boolean)actual.getMetadata().getName().equals(desiredSecretName));
    }
}

