/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Dependent;
import io.javaoperatorsdk.operator.sample.MySQLSchema;
import io.javaoperatorsdk.operator.sample.SchemaStatus;
import io.javaoperatorsdk.operator.sample.dependent.SchemaDependentResource;
import io.javaoperatorsdk.operator.sample.dependent.SecretDependentResource;
import io.javaoperatorsdk.operator.sample.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration(dependents={@Dependent(type=SecretDependentResource.class), @Dependent(type=SchemaDependentResource.class, name="schema")})
public class MySQLSchemaReconciler
implements Reconciler<MySQLSchema>,
ErrorStatusHandler<MySQLSchema> {
    static final Logger log = LoggerFactory.getLogger(MySQLSchemaReconciler.class);

    public UpdateControl<MySQLSchema> reconcile(MySQLSchema schema, Context<MySQLSchema> context) {
        Secret secret = (Secret)context.getSecondaryResource(Secret.class).orElseThrow();
        return context.getSecondaryResource(Schema.class, "schema").map(s -> {
            this.updateStatusPojo(schema, (Schema)s, secret.getMetadata().getName(), SchemaDependentResource.decode((String)secret.getData().get("mysql.secret.user.name")));
            log.info("Schema {} created - updating CR status", (Object)s.getName());
            return UpdateControl.patchStatus((HasMetadata)schema);
        }).orElse(UpdateControl.noUpdate());
    }

    public ErrorStatusUpdateControl<MySQLSchema> updateErrorStatus(MySQLSchema schema, Context<MySQLSchema> context, Exception e) {
        SchemaStatus status = new SchemaStatus();
        status.setUrl(null);
        status.setUserName(null);
        status.setSecretName(null);
        status.setStatus("ERROR: " + e.getMessage());
        schema.setStatus((Object)status);
        return ErrorStatusUpdateControl.updateStatus((HasMetadata)schema);
    }

    private void updateStatusPojo(MySQLSchema mySQLSchema, Schema schema, String secretName, String userName) {
        SchemaStatus status = new SchemaStatus();
        status.setUrl(String.format("jdbc:mysql://%1$s/%2$s", System.getenv("MYSQL_HOST"), schema.getName()));
        status.setUserName(userName);
        status.setSecretName(secretName);
        status.setStatus("CREATED");
        mySQLSchema.setStatus((Object)status);
    }
}

