/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample.schema;

import io.javaoperatorsdk.operator.sample.MySQLDbConfig;
import io.javaoperatorsdk.operator.sample.schema.Schema;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaService {
    private static final Logger log = LoggerFactory.getLogger(SchemaService.class);
    private final MySQLDbConfig mySQLDbConfig;

    public SchemaService(MySQLDbConfig mySQLDbConfig) {
        this.mySQLDbConfig = mySQLDbConfig;
    }

    public Optional<Schema> getSchema(String name) {
        Optional<Schema> optional;
        block8: {
            Connection connection = this.getConnection();
            try {
                optional = SchemaService.getSchema(connection, name);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            connection.close();
        }
        return optional;
    }

    public static void createSchemaAndRelatedUser(Connection connection, String schemaName, String encoding, String userName, String password) {
        try {
            try (Statement statement = connection.createStatement();){
                statement.execute(String.format("CREATE SCHEMA `%1$s` DEFAULT CHARACTER SET %2$s", schemaName, encoding));
            }
            if (!SchemaService.userExists(connection, userName)) {
                statement = connection.createStatement();
                try {
                    statement.execute(String.format("CREATE USER '%1$s' IDENTIFIED BY '%2$s'", userName, password));
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            statement = connection.createStatement();
            try {
                statement.execute(String.format("GRANT ALL ON `%1$s`.* TO '%2$s'", schemaName, userName));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void deleteSchemaAndRelatedUser(Connection connection, String schemaName, String userName) {
        block15: {
            try {
                try (Statement statement = connection.createStatement();){
                    statement.execute(String.format("DROP DATABASE `%1$s`", schemaName));
                }
                log.info("Deleted Schema '{}'", (Object)schemaName);
                if (userName == null) break block15;
                statement = connection.createStatement();
                try {
                    statement.execute(String.format("DROP USER '%1$s'", userName));
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                log.info("Deleted User '{}'", (Object)userName);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean userExists(Connection connection, String username) {
        try (PreparedStatement ps = connection.prepareStatement("SELECT 1 FROM mysql.user WHERE user = ?");){
            boolean bl;
            block14: {
                ps.setString(1, username);
                ResultSet resultSet = ps.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<Schema> getSchema(Connection connection, String schemaName) {
        try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM information_schema.schemata WHERE schema_name = ?");){
            Optional<Schema> optional;
            block18: {
                ResultSet resultSet;
                block16: {
                    Optional<Schema> optional2;
                    block17: {
                        ps.setString(1, schemaName);
                        resultSet = ps.executeQuery();
                        try {
                            boolean exists = resultSet.next();
                            if (exists) break block16;
                            optional2 = Optional.empty();
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional2;
                }
                optional = Optional.of(new Schema(resultSet.getString("SCHEMA_NAME"), resultSet.getString("DEFAULT_CHARACTER_SET_NAME")));
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private Connection getConnection() {
        try {
            String connectionString = String.format("jdbc:mysql://%1$s:%2$s", this.mySQLDbConfig.getHost(), this.mySQLDbConfig.getPort());
            log.debug("Connecting to '{}' with user '{}'", (Object)connectionString, (Object)this.mySQLDbConfig.getUser());
            return DriverManager.getConnection(connectionString, this.mySQLDbConfig.getUser(), this.mySQLDbConfig.getPassword());
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

