/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.event.source.Cache;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.polling.PerResourcePollingEventSource;
import io.javaoperatorsdk.operator.sample.MySQLDbConfig;
import io.javaoperatorsdk.operator.sample.MySQLSchema;
import io.javaoperatorsdk.operator.sample.SchemaPollingResourceSupplier;
import io.javaoperatorsdk.operator.sample.SchemaSpec;
import io.javaoperatorsdk.operator.sample.SchemaStatus;
import io.javaoperatorsdk.operator.sample.schema.Schema;
import io.javaoperatorsdk.operator.sample.schema.SchemaService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class MySQLSchemaReconciler
implements Reconciler<MySQLSchema>,
ErrorStatusHandler<MySQLSchema>,
EventSourceInitializer<MySQLSchema> {
    public static final String SECRET_FORMAT = "%s-secret";
    public static final String USERNAME_FORMAT = "%s-user";
    public static final int POLL_PERIOD = 500;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KubernetesClient kubernetesClient;
    private final MySQLDbConfig mysqlDbConfig;

    public MySQLSchemaReconciler(KubernetesClient kubernetesClient, MySQLDbConfig mysqlDbConfig) {
        this.kubernetesClient = kubernetesClient;
        this.mysqlDbConfig = mysqlDbConfig;
    }

    public List<EventSource> prepareEventSources(EventSourceContext<MySQLSchema> context) {
        return List.of(new PerResourcePollingEventSource((PerResourcePollingEventSource.ResourceSupplier)new SchemaPollingResourceSupplier(this.mysqlDbConfig), (Cache)context.getPrimaryCache(), 500L, Schema.class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpdateControl<MySQLSchema> reconcile(MySQLSchema schema, Context context) {
        this.log.info("Reconciling MySQLSchema with name: {}", (Object)schema.getMetadata().getName());
        Optional dbSchema = context.getSecondaryResource(Schema.class);
        this.log.debug("Schema: {} found for: {} ", (Object)dbSchema, (Object)schema.getMetadata().getName());
        try (Connection connection = this.getConnection();){
            if (dbSchema.isEmpty()) {
                this.log.debug("Creating Schema and related resources for: {}", (Object)schema.getMetadata().getName());
                String schemaName = schema.getMetadata().getName();
                String password = RandomStringUtils.randomAlphanumeric((int)16);
                String secretName = String.format(SECRET_FORMAT, schemaName);
                String userName = String.format(USERNAME_FORMAT, schemaName);
                SchemaService.createSchemaAndRelatedUser(connection, schemaName, ((SchemaSpec)schema.getSpec()).getEncoding(), userName, password);
                this.createSecret(schema, password, secretName, userName);
                this.updateStatusPojo(schema, secretName, userName);
                this.log.info("Schema {} created - updating CR status", (Object)schema.getMetadata().getName());
                UpdateControl updateControl2 = UpdateControl.updateStatus((HasMetadata)schema);
                return updateControl2;
            }
            this.log.debug("No update on MySQLSchema with name: {}", (Object)schema.getMetadata().getName());
            UpdateControl updateControl = UpdateControl.noUpdate();
            return updateControl;
        }
        catch (SQLException e) {
            this.log.error("Error while creating Schema", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public DeleteControl cleanup(MySQLSchema schema, Context context) {
        DeleteControl deleteControl;
        block10: {
            this.log.info("Cleaning up for: {}", (Object)schema.getMetadata().getName());
            Connection connection = this.getConnection();
            try {
                Optional<Schema> dbSchema = SchemaService.getSchema(connection, schema.getMetadata().getName());
                if (dbSchema.isPresent()) {
                    String userName = schema.getStatus() != null ? ((SchemaStatus)((Object)schema.getStatus())).getUserName() : null;
                    SchemaService.deleteSchemaAndRelatedUser(connection, schema.getMetadata().getName(), userName);
                } else {
                    this.log.info("Delete event ignored for schema '{}', real schema doesn't exist", (Object)schema.getMetadata().getName());
                }
                deleteControl = DeleteControl.defaultDelete();
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.log.error("Error while trying to delete Schema", (Throwable)e);
                    return DeleteControl.noFinalizerRemoval();
                }
            }
            connection.close();
        }
        return deleteControl;
    }

    public Optional<MySQLSchema> updateErrorStatus(MySQLSchema schema, RetryInfo retryInfo, RuntimeException e) {
        SchemaStatus status = new SchemaStatus();
        status.setUrl(null);
        status.setUserName(null);
        status.setSecretName(null);
        status.setStatus("ERROR: " + e.getMessage());
        schema.setStatus((Object)status);
        return Optional.empty();
    }

    private Connection getConnection() throws SQLException {
        String connectionString = String.format("jdbc:mysql://%1$s:%2$s", this.mysqlDbConfig.getHost(), this.mysqlDbConfig.getPort());
        this.log.debug("Connecting to '{}' with user '{}'", (Object)connectionString, (Object)this.mysqlDbConfig.getUser());
        return DriverManager.getConnection(connectionString, this.mysqlDbConfig.getUser(), this.mysqlDbConfig.getPassword());
    }

    private void updateStatusPojo(MySQLSchema schema, String secretName, String userName) {
        SchemaStatus status = new SchemaStatus();
        status.setUrl(String.format("jdbc:mysql://%1$s/%2$s", System.getenv("MYSQL_HOST"), schema.getMetadata().getName()));
        status.setUserName(userName);
        status.setSecretName(secretName);
        status.setStatus("CREATED");
        schema.setStatus((Object)status);
    }

    private void createSecret(MySQLSchema schema, String password, String secretName, String userName) {
        Secret currentSecret = (Secret)((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(schema.getMetadata().getNamespace())).withName(secretName)).get();
        if (currentSecret != null) {
            return;
        }
        Secret credentialsSecret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(secretName)).withOwnerReferences(new OwnerReference[]{new OwnerReference("mysql.sample.javaoperatorsdk/v1", Boolean.valueOf(false), Boolean.valueOf(false), "MySQLSchema", schema.getMetadata().getName(), schema.getMetadata().getUid())})).endMetadata()).addToData("MYSQL_USERNAME", Base64.getEncoder().encodeToString(userName.getBytes()))).addToData("MYSQL_PASSWORD", Base64.getEncoder().encodeToString(password.getBytes()))).build();
        ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(schema.getMetadata().getNamespace())).create((Object)credentialsSecret);
    }
}

