/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.springboot.starter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.javaoperatorsdk.operator.ControllerUtils;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.config.AbstractConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.config.runtime.AnnotationConfiguration;
import io.javaoperatorsdk.operator.springboot.starter.ControllerProperties;
import io.javaoperatorsdk.operator.springboot.starter.KubernetesClientProperties;
import io.javaoperatorsdk.operator.springboot.starter.OperatorConfigurationProperties;
import io.javaoperatorsdk.operator.springboot.starter.RetryProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OperatorConfigurationProperties.class})
public class OperatorAutoConfiguration
extends AbstractConfigurationService {
    @Autowired
    private OperatorConfigurationProperties configuration;

    public OperatorAutoConfiguration() {
        super(Utils.loadFromProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient() {
        Config config = this.getClientConfiguration();
        return this.configuration.getClient().isOpenshift() ? new DefaultOpenShiftClient(config) : new DefaultKubernetesClient(config);
    }

    public Config getClientConfiguration() {
        KubernetesClientProperties clientCfg = this.configuration.getClient();
        ConfigBuilder config = new ConfigBuilder();
        config.withTrustCerts(clientCfg.isTrustSelfSignedCertificates());
        clientCfg.getMasterUrl().ifPresent(arg_0 -> ((ConfigBuilder)config).withMasterUrl(arg_0));
        clientCfg.getUsername().ifPresent(arg_0 -> ((ConfigBuilder)config).withUsername(arg_0));
        clientCfg.getPassword().ifPresent(arg_0 -> ((ConfigBuilder)config).withPassword(arg_0));
        return config.build();
    }

    public boolean checkCRDAndValidateLocalModel() {
        return this.configuration.getCheckCrdAndValidateLocalModel();
    }

    @Bean
    @ConditionalOnMissingBean(value={Operator.class})
    public Operator operator(KubernetesClient kubernetesClient, List<ResourceController<?>> resourceControllers, Optional<ObjectMapper> objectMapper) {
        Operator operator = objectMapper.map(x -> new Operator(kubernetesClient, (ConfigurationService)this, x)).orElse(new Operator(kubernetesClient, (ConfigurationService)this));
        resourceControllers.forEach(r -> operator.register(this.processController((ResourceController<?>)r)));
        return operator;
    }

    private ResourceController<?> processController(ResourceController<?> controller) {
        Map<String, ControllerProperties> controllerPropertiesMap = this.configuration.getControllers();
        String name = ControllerUtils.getNameFor(controller);
        ControllerProperties controllerProps = controllerPropertiesMap.get(name);
        this.register((ControllerConfiguration)new ConfigurationWrapper(controller, controllerProps));
        return controller;
    }

    private static class ConfigurationWrapper<R extends CustomResource>
    extends AnnotationConfiguration<R> {
        private final Optional<ControllerProperties> properties;

        private ConfigurationWrapper(ResourceController<R> controller, ControllerProperties properties) {
            super(controller);
            this.properties = Optional.ofNullable(properties);
        }

        public String getName() {
            return super.getName();
        }

        public String getCRDName() {
            return this.properties.map(ControllerProperties::getCRDName).orElse(super.getCRDName());
        }

        public String getFinalizer() {
            return this.properties.map(ControllerProperties::getFinalizer).orElse(super.getFinalizer());
        }

        public boolean isGenerationAware() {
            return this.properties.map(ControllerProperties::isGenerationAware).orElse(super.isGenerationAware());
        }

        public Class<R> getCustomResourceClass() {
            return super.getCustomResourceClass();
        }

        public Set<String> getNamespaces() {
            return this.properties.map(ControllerProperties::getNamespaces).orElse(super.getNamespaces());
        }

        public boolean watchAllNamespaces() {
            return super.watchAllNamespaces();
        }

        public RetryConfiguration getRetryConfiguration() {
            return this.properties.map(ControllerProperties::getRetry).map(RetryProperties::asRetryConfiguration).orElse(RetryConfiguration.DEFAULT);
        }
    }
}

