/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.quarkus.it;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.client.CustomResource;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/operator")
public class TestOperatorApp {
    @Inject
    Instance<ResourceController<? extends CustomResource>> controllers;
    @Inject
    ConfigurationService configurationService;

    @GET
    @Path(value="{name}")
    public boolean getController(@PathParam(value="name") String name) {
        return this.configurationService.getKnownControllerNames().contains(name);
    }

    @GET
    @Path(value="{name}/config")
    public JSONControllerConfiguration getConfig(@PathParam(value="name") String name) {
        JSONControllerConfiguration configuration = this.controllers.stream().map(c -> this.configurationService.getConfigurationFor(c)).filter(c -> c.getName().equals(name)).findFirst().map(JSONControllerConfiguration::new).orElse(null);
        return configuration;
    }

    static class JSONControllerConfiguration {
        private final ControllerConfiguration conf;

        public JSONControllerConfiguration(ControllerConfiguration conf) {
            this.conf = conf;
        }

        public String getName() {
            return this.conf.getName();
        }

        @JsonProperty(value="crdName")
        public String getCRDName() {
            return this.conf.getCRDName();
        }

        public String getFinalizer() {
            return this.conf.getFinalizer();
        }

        public boolean isGenerationAware() {
            return this.conf.isGenerationAware();
        }

        public String getCustomResourceClass() {
            return this.conf.getCustomResourceClass().getCanonicalName();
        }

        public String getAssociatedControllerClassName() {
            return this.conf.getAssociatedControllerClassName();
        }

        public String[] getNamespaces() {
            return this.conf.getNamespaces().toArray(new String[0]);
        }

        public boolean watchAllNamespaces() {
            return this.conf.watchAllNamespaces();
        }

        public RetryConfiguration getRetryConfiguration() {
            return this.conf.getRetryConfiguration();
        }
    }
}

