/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.RegisteredController;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.junit.AbstractOperatorExtension;
import io.javaoperatorsdk.operator.junit.KubernetesClientAware;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalOperatorExtension
extends AbstractOperatorExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOperatorExtension.class);
    private final Operator operator;
    private final List<ReconcilerSpec> reconcilers;
    private final List<PortFowardSpec> portForwards;
    private final List<LocalPortForward> localPortForwards;
    private final Map<Reconciler, RegisteredController> registeredControllers;

    private LocalOperatorExtension(ConfigurationService configurationService, List<ReconcilerSpec> reconcilers, List<HasMetadata> infrastructure, List<PortFowardSpec> portForwards, Duration infrastructureTimeout, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion, boolean oneNamespacePerClass) {
        super(configurationService, infrastructure, infrastructureTimeout, oneNamespacePerClass, preserveNamespaceOnError, waitForNamespaceDeletion);
        this.reconcilers = reconcilers;
        this.portForwards = portForwards;
        this.localPortForwards = new ArrayList<LocalPortForward>(portForwards.size());
        this.operator = new Operator(this.getKubernetesClient(), this.configurationService);
        this.registeredControllers = new HashMap<Reconciler, RegisteredController>();
    }

    public static Builder builder() {
        return new Builder();
    }

    private Stream<Reconciler> reconcilers() {
        return this.reconcilers.stream().map(reconcilerSpec -> reconcilerSpec.reconciler);
    }

    public List<Reconciler> getReconcilers() {
        return this.reconcilers().collect(Collectors.toUnmodifiableList());
    }

    public Reconciler getFirstReconciler() {
        return this.reconcilers().findFirst().orElseThrow();
    }

    public <T extends Reconciler> T getReconcilerOfType(Class<T> type) {
        return (T)this.reconcilers().filter(type::isInstance).map(type::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find a reconciler of type: " + type));
    }

    public RegisteredController getRegisteredControllerForReconcile(Class<? extends Reconciler> type) {
        return this.registeredControllers.get(this.getReconcilerOfType(type));
    }

    @Override
    protected void before(ExtensionContext context) {
        super.before(context);
        KubernetesClient kubernetesClient = this.getKubernetesClient();
        for (PortFowardSpec portFowardSpec : this.portForwards) {
            String podName = ((Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(portFowardSpec.getNamespace())).withLabel(portFowardSpec.getLabelKey(), portFowardSpec.getLabelValue())).list()).getItems().get(0)).getMetadata().getName();
            this.localPortForwards.add((LocalPortForward)((PodResource)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(portFowardSpec.getNamespace())).withName(podName)).portForward(portFowardSpec.getPort(), portFowardSpec.getLocalPort()));
        }
        for (ReconcilerSpec reconcilerSpec : this.reconcilers) {
            ControllerConfiguration config = this.configurationService.getConfigurationFor(reconcilerSpec.reconciler);
            ControllerConfigurationOverrider oconfig = ControllerConfigurationOverrider.override((ControllerConfiguration)config).settingNamespace(this.namespace);
            String path = "/META-INF/fabric8/" + config.getResourceTypeName() + "-v1.yml";
            if (reconcilerSpec.retry != null) {
                oconfig.withRetry((RetryConfiguration)reconcilerSpec.retry);
            }
            if (reconcilerSpec.controllerConfigurationOverrider != null) {
                reconcilerSpec.controllerConfigurationOverrider.accept(oconfig);
            }
            try (InputStream is = this.getClass().getResourceAsStream(path);){
                ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable crd = kubernetesClient.load(is);
                crd.createOrReplace();
                Thread.sleep(2000L);
                LOGGER.debug("Applied CRD with name: {}", (Object)config.getResourceTypeName());
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted.", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot apply CRD yaml: " + path, ex);
            }
            if (reconcilerSpec.reconciler instanceof KubernetesClientAware) {
                ((KubernetesClientAware)reconcilerSpec.reconciler).setKubernetesClient(kubernetesClient);
            }
            RegisteredController registeredController = this.operator.register(reconcilerSpec.reconciler, oconfig.build());
            this.registeredControllers.put(reconcilerSpec.reconciler, registeredController);
        }
        LOGGER.debug("Starting the operator locally");
        this.operator.start();
    }

    @Override
    protected void after(ExtensionContext context) {
        super.after(context);
        try {
            this.operator.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (LocalPortForward ref : this.localPortForwards) {
            try {
                ref.close();
            }
            catch (Exception exception) {}
        }
        this.localPortForwards.clear();
    }

    private static class ReconcilerSpec {
        final Reconciler reconciler;
        final Retry retry;
        final Consumer<ControllerConfigurationOverrider> controllerConfigurationOverrider;

        public ReconcilerSpec(Reconciler reconciler, Retry retry) {
            this(reconciler, retry, null);
        }

        public ReconcilerSpec(Reconciler reconciler, Retry retry, Consumer<ControllerConfigurationOverrider> controllerConfigurationOverrider) {
            this.reconciler = reconciler;
            this.retry = retry;
            this.controllerConfigurationOverrider = controllerConfigurationOverrider;
        }
    }

    private static class PortFowardSpec {
        final String namespace;
        final String labelKey;
        final String labelValue;
        final int port;
        final int localPort;

        public PortFowardSpec(String namespace, String labelKey, String labelValue, int port, int localPort) {
            this.namespace = namespace;
            this.labelKey = labelKey;
            this.labelValue = labelValue;
            this.port = port;
            this.localPort = localPort;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getLabelKey() {
            return this.labelKey;
        }

        public String getLabelValue() {
            return this.labelValue;
        }

        public int getPort() {
            return this.port;
        }

        public int getLocalPort() {
            return this.localPort;
        }
    }

    public static class Builder
    extends AbstractOperatorExtension.AbstractBuilder<Builder> {
        private final List<ReconcilerSpec> reconcilers = new ArrayList<ReconcilerSpec>();
        private final List<PortFowardSpec> portForwards = new ArrayList<PortFowardSpec>();

        protected Builder() {
        }

        public Builder withReconciler(Reconciler value, Consumer<ControllerConfigurationOverrider> configurationOverrider) {
            return this.withReconciler(value, null, configurationOverrider);
        }

        public Builder withReconciler(Reconciler value, Retry retry, Consumer<ControllerConfigurationOverrider> configurationOverrider) {
            this.reconcilers.add(new ReconcilerSpec(value, retry, configurationOverrider));
            return this;
        }

        public Builder withReconciler(Reconciler value) {
            this.reconcilers.add(new ReconcilerSpec(value, null));
            return this;
        }

        public Builder withReconciler(Reconciler value, Retry retry) {
            this.reconcilers.add(new ReconcilerSpec(value, retry));
            return this;
        }

        public Builder withReconciler(Class<? extends Reconciler> value) {
            try {
                this.reconcilers.add(new ReconcilerSpec(value.getConstructor(new Class[0]).newInstance(new Object[0]), null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withPortForward(String namespace, String labelKey, String labelValue, int port, int localPort) {
            this.portForwards.add(new PortFowardSpec(namespace, labelKey, labelValue, port, localPort));
            return this;
        }

        public LocalOperatorExtension build() {
            return new LocalOperatorExtension(this.configurationService, this.reconcilers, this.infrastructure, this.portForwards, this.infrastructureTimeout, this.preserveNamespaceOnError, this.waitForNamespaceDeletion, this.oneNamespacePerClass);
        }
    }
}

