/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.junit.HasKubernetesClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperatorExtension
implements HasKubernetesClient,
BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperatorExtension.class);
    public static final int CRD_READY_WAIT = 2000;
    private final KubernetesClient kubernetesClient = new DefaultKubernetesClient();
    protected final ConfigurationService configurationService;
    protected final List<HasMetadata> infrastructure;
    protected Duration infrastructureTimeout;
    protected final boolean oneNamespacePerClass;
    protected final boolean preserveNamespaceOnError;
    protected final boolean waitForNamespaceDeletion;
    protected String namespace;

    protected AbstractOperatorExtension(ConfigurationService configurationService, List<HasMetadata> infrastructure, Duration infrastructureTimeout, boolean oneNamespacePerClass, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion) {
        this.configurationService = configurationService;
        this.infrastructure = infrastructure;
        this.infrastructureTimeout = infrastructureTimeout;
        this.oneNamespacePerClass = oneNamespacePerClass;
        this.preserveNamespaceOnError = preserveNamespaceOnError;
        this.waitForNamespaceDeletion = waitForNamespaceDeletion;
    }

    public void beforeAll(ExtensionContext context) {
        this.beforeAllImpl(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.beforeEachImpl(context);
    }

    public void afterAll(ExtensionContext context) {
        this.afterAllImpl(context);
    }

    public void afterEach(ExtensionContext context) {
        this.afterEachImpl(context);
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public <T extends HasMetadata> NonNamespaceOperation<T, KubernetesResourceList<T>, Resource<T>> resources(Class<T> type) {
        return (NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace);
    }

    public <T extends HasMetadata> T get(Class<T> type, String name) {
        return (T)((HasMetadata)((Resource)((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).withName(name)).get());
    }

    public <T extends HasMetadata> T create(Class<T> type, T resource) {
        return (T)((HasMetadata)((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).create(resource));
    }

    public <T extends HasMetadata> T replace(Class<T> type, T resource) {
        return (T)((HasMetadata)((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).replace(resource));
    }

    public <T extends HasMetadata> boolean delete(Class<T> type, T resource) {
        return ((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).delete((Object[])new HasMetadata[]{resource});
    }

    protected void beforeAllImpl(ExtensionContext context) {
        if (this.oneNamespacePerClass) {
            this.namespace = context.getRequiredTestClass().getSimpleName();
            this.namespace = this.namespace + "-";
            this.namespace = this.namespace + UUID.randomUUID();
            this.namespace = KubernetesResourceUtil.sanitizeName((String)this.namespace).toLowerCase(Locale.US);
            this.namespace = this.namespace.substring(0, Math.min(this.namespace.length(), 63));
            this.before(context);
        }
    }

    protected void beforeEachImpl(ExtensionContext context) {
        if (!this.oneNamespacePerClass) {
            this.namespace = context.getRequiredTestClass().getSimpleName();
            this.namespace = this.namespace + "-";
            this.namespace = this.namespace + context.getRequiredTestMethod().getName();
            this.namespace = this.namespace + "-";
            this.namespace = this.namespace + UUID.randomUUID();
            this.namespace = KubernetesResourceUtil.sanitizeName((String)this.namespace).toLowerCase(Locale.US);
            this.namespace = this.namespace.substring(0, Math.min(this.namespace.length(), 63));
            this.before(context);
        }
    }

    protected void before(ExtensionContext context) {
        LOGGER.info("Initializing integration test in namespace {}", (Object)this.namespace);
        this.kubernetesClient.namespaces().create((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(this.namespace)).endMetadata()).build());
        this.kubernetesClient.resourceList(this.infrastructure).createOrReplace();
        this.kubernetesClient.resourceList(this.infrastructure).waitUntilReady(this.infrastructureTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void afterAllImpl(ExtensionContext context) {
        if (this.oneNamespacePerClass) {
            this.after(context);
        }
    }

    protected void afterEachImpl(ExtensionContext context) {
        if (!this.oneNamespacePerClass) {
            this.after(context);
        }
    }

    protected void after(ExtensionContext context) {
        if (this.namespace != null) {
            if (this.preserveNamespaceOnError && context.getExecutionException().isPresent()) {
                LOGGER.info("Preserving namespace {}", (Object)this.namespace);
            } else {
                this.kubernetesClient.resourceList(this.infrastructure).delete();
                this.deleteOperator();
                LOGGER.info("Deleting namespace {} and stopping operator", (Object)this.namespace);
                ((Resource)this.kubernetesClient.namespaces().withName(this.namespace)).delete();
                if (this.waitForNamespaceDeletion) {
                    LOGGER.info("Waiting for namespace {} to be deleted", (Object)this.namespace);
                    Awaitility.await((String)"namespace deleted").pollInterval(50L, TimeUnit.MILLISECONDS).atMost(90L, TimeUnit.SECONDS).until(() -> ((Resource)this.kubernetesClient.namespaces().withName(this.namespace)).get() == null);
                }
            }
        }
    }

    protected void deleteOperator() {
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        protected ConfigurationService configurationService = ConfigurationServiceProvider.instance();
        protected final List<HasMetadata> infrastructure = new ArrayList<HasMetadata>();
        protected Duration infrastructureTimeout = Duration.ofMinutes(1L);
        protected boolean preserveNamespaceOnError = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.preserveNamespaceOnError", (Boolean)false);
        protected boolean waitForNamespaceDeletion = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.waitForNamespaceDeletion", (Boolean)true);
        protected boolean oneNamespacePerClass = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.oneNamespacePerClass", (Boolean)false);

        protected AbstractBuilder() {
        }

        public T preserveNamespaceOnError(boolean value) {
            this.preserveNamespaceOnError = value;
            return (T)this;
        }

        public T waitForNamespaceDeletion(boolean value) {
            this.waitForNamespaceDeletion = value;
            return (T)this;
        }

        public T oneNamespacePerClass(boolean value) {
            this.oneNamespacePerClass = value;
            return (T)this;
        }

        public T withConfigurationService(ConfigurationService value) {
            this.configurationService = value;
            return (T)this;
        }

        public T withInfrastructureTimeout(Duration value) {
            this.infrastructureTimeout = value;
            return (T)this;
        }

        public T withInfrastructure(List<HasMetadata> hm) {
            this.infrastructure.addAll(hm);
            return (T)this;
        }

        public T withInfrastructure(HasMetadata ... hms) {
            this.infrastructure.addAll(Arrays.asList(hms));
            return (T)this;
        }
    }
}

