/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.junit.AbstractOperatorExtension;
import io.javaoperatorsdk.operator.junit.KubernetesClientAware;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorExtension
extends AbstractOperatorExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorExtension.class);
    private final Operator operator;
    private final List<ReconcilerSpec> reconcilers;

    private OperatorExtension(ConfigurationService configurationService, List<ReconcilerSpec> reconcilers, List<HasMetadata> infrastructure, Duration infrastructureTimeout, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion, boolean oneNamespacePerClass) {
        super(configurationService, infrastructure, infrastructureTimeout, oneNamespacePerClass, preserveNamespaceOnError, waitForNamespaceDeletion);
        this.reconcilers = reconcilers;
        this.operator = new Operator(this.getKubernetesClient(), this.configurationService);
    }

    public static Builder builder() {
        return new Builder();
    }

    private Stream<Reconciler> reconcilers() {
        return this.operator.getControllers().stream().map(Controller::getReconciler);
    }

    public List<Reconciler> getReconcilers() {
        return this.reconcilers().collect(Collectors.toUnmodifiableList());
    }

    public Reconciler getFirstReconciler() {
        return this.reconcilers().findFirst().orElseThrow();
    }

    public <T extends Reconciler> T getControllerOfType(Class<T> type) {
        return (T)this.reconcilers().filter(type::isInstance).map(type::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find a reconciler of type: " + type));
    }

    @Override
    protected void before(ExtensionContext context) {
        super.before(context);
        for (ReconcilerSpec ref : this.reconcilers) {
            ControllerConfiguration config = this.configurationService.getConfigurationFor(ref.reconciler);
            ControllerConfigurationOverrider oconfig = ControllerConfigurationOverrider.override((ControllerConfiguration)config).settingNamespace(this.namespace);
            String path = "/META-INF/fabric8/" + config.getResourceTypeName() + "-v1.yml";
            if (ref.retry != null) {
                oconfig.withRetry((RetryConfiguration)ref.retry);
            }
            KubernetesClient kubernetesClient = this.getKubernetesClient();
            try (InputStream is = this.getClass().getResourceAsStream(path);){
                ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable crd = kubernetesClient.load(is);
                crd.createOrReplace();
                crd.waitUntilReady(2L, TimeUnit.SECONDS);
                LOGGER.debug("Applied CRD with name: {}", (Object)config.getResourceTypeName());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot apply CRD yaml: " + path, ex);
            }
            if (ref.reconciler instanceof KubernetesClientAware) {
                ((KubernetesClientAware)ref.reconciler).setKubernetesClient(kubernetesClient);
            }
            this.operator.register(ref.reconciler, oconfig.build());
        }
        LOGGER.debug("Starting the operator locally");
        this.operator.start();
    }

    @Override
    protected void after(ExtensionContext context) {
        super.after(context);
        try {
            this.operator.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ReconcilerSpec {
        final Reconciler reconciler;
        final Retry retry;

        public ReconcilerSpec(Reconciler reconciler, Retry retry) {
            this.reconciler = reconciler;
            this.retry = retry;
        }
    }

    public static class Builder
    extends AbstractOperatorExtension.AbstractBuilder<Builder> {
        private final List<ReconcilerSpec> reconcilers = new ArrayList<ReconcilerSpec>();

        protected Builder() {
        }

        public Builder withReconciler(Reconciler value) {
            this.reconcilers.add(new ReconcilerSpec(value, null));
            return this;
        }

        public Builder withReconciler(Reconciler value, Retry retry) {
            this.reconcilers.add(new ReconcilerSpec(value, retry));
            return this;
        }

        public Builder withReconciler(Class<? extends Reconciler> value) {
            try {
                this.reconcilers.add(new ReconcilerSpec(value.getConstructor(new Class[0]).newInstance(new Object[0]), null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public OperatorExtension build() {
            return new OperatorExtension(this.configurationService, this.reconcilers, this.infrastructure, this.infrastructureTimeout, this.preserveNamespaceOnError, this.waitForNamespaceDeletion, this.oneNamespacePerClass);
        }
    }
}

