/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.extended.run.RunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;

public class InClusterCurl {
    private final KubernetesClient client;
    private final String namespace;

    public InClusterCurl(KubernetesClient client, String namespace) {
        this.client = client;
        this.namespace = namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkUrl(String url) {
        String podName = KubernetesResourceUtil.sanitizeName((String)("curl-" + UUID.randomUUID()));
        try {
            String curlOutput;
            Pod curlPod = this.client.run().inNamespace(this.namespace).withRunConfig((RunConfig)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)new RunConfigBuilder().withArgs(new String[]{"-s", "-o", "/dev/null", "-w", "%{http_code}", url})).withName(podName)).withImage("curlimages/curl:7.78.0")).withRestartPolicy("Never")).build()).done();
            Awaitility.await((String)"wait-for-curl-pod-run").atMost(2L, TimeUnit.MINUTES).until(() -> {
                String phase = ((Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(podName)).get()).getStatus().getPhase();
                return phase.equals("Succeeded") || phase.equals("Failed");
            });
            String string = curlOutput = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(curlPod.getMetadata().getName())).getLog();
            return string;
        }
        finally {
            ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(podName)).delete();
            Awaitility.await((String)"wait-for-curl-pod-stop").atMost(1L, TimeUnit.MINUTES).until(() -> ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(podName)).get() == null);
        }
    }
}

