/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.junit.AbstractOperatorExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E2EOperatorExtension
extends AbstractOperatorExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(E2EOperatorExtension.class);
    private final List<HasMetadata> operatorDeployment;
    private final Duration operatorDeploymentTimeout;

    private E2EOperatorExtension(ConfigurationService configurationService, List<HasMetadata> operatorDeployment, Duration operatorDeploymentTimeout, List<HasMetadata> infrastructure, Duration infrastructureTimeout, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion, boolean oneNamespacePerClass) {
        super(configurationService, infrastructure, infrastructureTimeout, oneNamespacePerClass, preserveNamespaceOnError, waitForNamespaceDeletion);
        this.operatorDeployment = operatorDeployment;
        this.operatorDeploymentTimeout = operatorDeploymentTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void before(ExtensionContext context) {
        super.before(context);
        String crdPath = "./target/classes/META-INF/fabric8/";
        String crdSuffix = "-v1.yml";
        KubernetesClient kubernetesClient = this.getKubernetesClient();
        for (File crdFile : Objects.requireNonNull(new File("./target/classes/META-INF/fabric8/").listFiles((ignored, name) -> name.endsWith("-v1.yml")))) {
            try (FileInputStream is = new FileInputStream(crdFile);){
                ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable crd = kubernetesClient.load((InputStream)is);
                crd.createOrReplace();
                crd.waitUntilReady(2L, TimeUnit.SECONDS);
                LOGGER.debug("Applied CRD with name: {}", (Object)((HasMetadata)((List)crd.get()).get(0)).getMetadata().getName());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot apply CRD yaml: " + crdFile.getAbsolutePath(), ex);
            }
        }
        LOGGER.debug("Deploying the operator into Kubernetes");
        this.operatorDeployment.forEach(hm -> {
            hm.getMetadata().setNamespace(this.namespace);
            if (hm.getKind().toLowerCase(Locale.ROOT).equals("clusterrolebinding")) {
                ClusterRoleBinding crb = (ClusterRoleBinding)hm;
                for (Subject subject : crb.getSubjects()) {
                    subject.setNamespace(this.namespace);
                }
            }
        });
        ((ListVisitFromServerGetDeleteRecreateWaitApplicable)kubernetesClient.resourceList(this.operatorDeployment).inNamespace(this.namespace)).createOrReplace();
        kubernetesClient.resourceList(this.operatorDeployment).waitUntilReady(this.operatorDeploymentTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void deleteOperator() {
        ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.getKubernetesClient().resourceList(this.operatorDeployment).inNamespace(this.namespace)).delete();
    }

    public static class Builder
    extends AbstractOperatorExtension.AbstractBuilder<Builder> {
        private final List<HasMetadata> operatorDeployment = new ArrayList<HasMetadata>();
        private Duration deploymentTimeout = Duration.ofMinutes(1L);

        protected Builder() {
        }

        public Builder withDeploymentTimeout(Duration value) {
            this.deploymentTimeout = value;
            return this;
        }

        public Builder withOperatorDeployment(List<HasMetadata> hm) {
            this.operatorDeployment.addAll(hm);
            return this;
        }

        public Builder withOperatorDeployment(HasMetadata ... hms) {
            this.operatorDeployment.addAll(Arrays.asList(hms));
            return this;
        }

        public E2EOperatorExtension build() {
            return new E2EOperatorExtension(this.configurationService, this.operatorDeployment, this.deploymentTimeout, this.infrastructure, this.infrastructureTimeout, this.preserveNamespaceOnError, this.waitForNamespaceDeletion, this.oneNamespacePerClass);
        }
    }
}

