/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.config.BaseConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.junit.HasKubernetesClient;
import io.javaoperatorsdk.operator.junit.KubernetesClientAware;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorExtension
implements HasKubernetesClient,
BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorExtension.class);
    private final KubernetesClient kubernetesClient = new DefaultKubernetesClient();
    private final ConfigurationService configurationService;
    private final Operator operator;
    private final List<ReconcilerSpec> reconcilers;
    private final boolean preserveNamespaceOnError;
    private final boolean waitForNamespaceDeletion;
    private String namespace;

    private OperatorExtension(ConfigurationService configurationService, List<ReconcilerSpec> reconcilers, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion) {
        this.configurationService = configurationService;
        this.reconcilers = reconcilers;
        this.operator = new Operator(this.kubernetesClient, this.configurationService);
        this.preserveNamespaceOnError = preserveNamespaceOnError;
        this.waitForNamespaceDeletion = waitForNamespaceDeletion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.before(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.before(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.after(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.after(context);
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<Reconciler> getReconcilers() {
        return this.operator.getControllers().stream().map(Controller::getReconciler).collect(Collectors.toUnmodifiableList());
    }

    public <T extends Reconciler> T getControllerOfType(Class<T> type) {
        return (T)this.operator.getControllers().stream().map(Controller::getReconciler).filter(type::isInstance).map(type::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find a reconciler of type: " + type));
    }

    public <T extends HasMetadata> NonNamespaceOperation<T, KubernetesResourceList<T>, Resource<T>> resources(Class<T> type) {
        return (NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace);
    }

    public <T extends HasMetadata> T get(Class<T> type, String name) {
        return (T)((HasMetadata)((Resource)((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).withName(name)).get());
    }

    public <T extends HasMetadata> T create(Class<T> type, T resource) {
        return (T)((HasMetadata)((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).create(resource));
    }

    public <T extends HasMetadata> T replace(Class<T> type, T resource) {
        return (T)((HasMetadata)((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).replace(resource));
    }

    public <T extends HasMetadata> boolean delete(Class<T> type, T resource) {
        return ((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).delete((Object[])new HasMetadata[]{resource});
    }

    protected void before(ExtensionContext context) {
        this.namespace = context.getRequiredTestClass().getSimpleName();
        this.namespace = this.namespace + "-";
        this.namespace = this.namespace + context.getRequiredTestMethod().getName();
        this.namespace = KubernetesResourceUtil.sanitizeName((String)this.namespace).toLowerCase(Locale.US);
        this.namespace = this.namespace.substring(0, Math.min(this.namespace.length(), 63));
        LOGGER.info("Initializing integration test in namespace {}", (Object)this.namespace);
        this.kubernetesClient.namespaces().create((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(this.namespace)).endMetadata()).build());
        for (ReconcilerSpec ref : this.reconcilers) {
            ControllerConfiguration config = this.configurationService.getConfigurationFor(ref.reconciler);
            ControllerConfigurationOverrider oconfig = ControllerConfigurationOverrider.override((ControllerConfiguration)config).settingNamespace(this.namespace);
            String path = "/META-INF/fabric8/" + config.getResourceTypeName() + "-v1.yml";
            if (ref.retry != null) {
                oconfig.withRetry((RetryConfiguration)ref.retry);
            }
            try (InputStream is = this.getClass().getResourceAsStream(path);){
                this.kubernetesClient.load(is).createOrReplace();
                Thread.sleep(2000L);
                LOGGER.debug("Applied CRD with name: {}", (Object)config.getResourceTypeName());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot apply CRD yaml: " + path, ex);
            }
            if (ref.reconciler instanceof KubernetesClientAware) {
                ((KubernetesClientAware)ref.reconciler).setKubernetesClient(this.kubernetesClient);
            }
            this.operator.register(ref.reconciler, oconfig.build());
        }
        this.operator.start();
    }

    protected void after(ExtensionContext context) {
        if (this.namespace != null) {
            if (this.preserveNamespaceOnError && context.getExecutionException().isPresent()) {
                LOGGER.info("Preserving namespace {}", (Object)this.namespace);
            } else {
                LOGGER.info("Deleting namespace {} and stopping operator", (Object)this.namespace);
                ((Resource)this.kubernetesClient.namespaces().withName(this.namespace)).delete();
                if (this.waitForNamespaceDeletion) {
                    LOGGER.info("Waiting for namespace {} to be deleted", (Object)this.namespace);
                    Awaitility.await((String)"namespace deleted").pollInterval(50L, TimeUnit.MILLISECONDS).atMost(90L, TimeUnit.SECONDS).until(() -> ((Resource)this.kubernetesClient.namespaces().withName(this.namespace)).get() == null);
                }
            }
        }
        try {
            this.operator.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ReconcilerSpec {
        final Reconciler reconciler;
        final Retry retry;

        public ReconcilerSpec(Reconciler reconciler, Retry retry) {
            this.reconciler = reconciler;
            this.retry = retry;
        }
    }

    public static class Builder {
        private final List<ReconcilerSpec> reconcilers;
        private ConfigurationService configurationService = new BaseConfigurationService(Version.UNKNOWN);
        private boolean preserveNamespaceOnError;
        private boolean waitForNamespaceDeletion;

        protected Builder() {
            this.reconcilers = new ArrayList<ReconcilerSpec>();
            this.preserveNamespaceOnError = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.preserveNamespaceOnError", (Boolean)false);
            this.waitForNamespaceDeletion = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.waitForNamespaceDeletion", (Boolean)true);
        }

        public Builder preserveNamespaceOnError(boolean value) {
            this.preserveNamespaceOnError = value;
            return this;
        }

        public Builder waitForNamespaceDeletion(boolean value) {
            this.waitForNamespaceDeletion = value;
            return this;
        }

        public Builder withConfigurationService(ConfigurationService value) {
            this.configurationService = value;
            return this;
        }

        public Builder withReconciler(Reconciler value) {
            this.reconcilers.add(new ReconcilerSpec(value, null));
            return this;
        }

        public Builder withReconciler(Reconciler value, Retry retry) {
            this.reconcilers.add(new ReconcilerSpec(value, retry));
            return this;
        }

        public Builder withReconciler(Class<? extends Reconciler> value) {
            try {
                this.reconcilers.add(new ReconcilerSpec(value.getConstructor(new Class[0]).newInstance(new Object[0]), null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public OperatorExtension build() {
            return new OperatorExtension(this.configurationService, this.reconcilers, this.preserveNamespaceOnError, this.waitForNamespaceDeletion);
        }
    }
}

