/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.micrometer;

import io.javaoperatorsdk.operator.Metrics;
import io.javaoperatorsdk.operator.processing.DefaultEventHandler;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Collections;
import java.util.Map;

public class MicrometerMetrics
implements Metrics {
    public static final String PREFIX = "operator.sdk.";
    private final MeterRegistry registry;
    private final DefaultEventHandler.EventMonitor monitor = new DefaultEventHandler.EventMonitor(){

        public void processedEvent(String uid, Event event) {
            MicrometerMetrics.this.incrementProcessedEventsNumber();
        }

        public void failedEvent(String uid, Event event) {
            MicrometerMetrics.this.incrementControllerRetriesNumber();
        }
    };

    public MicrometerMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public <T> T timeControllerExecution(Metrics.ControllerExecution<T> execution) {
        String name = execution.controllerName();
        String execName = "operator.sdk.controllers.execution." + execution.name();
        Timer timer = Timer.builder((String)execName).tags(new String[]{"controller", name}).publishPercentiles(new double[]{0.3, 0.5, 0.95}).publishPercentileHistogram().register(this.registry);
        try {
            Object result = timer.record(() -> execution.execute());
            String successType = execution.successTypeName(result);
            this.registry.counter(execName + ".success", new String[]{"controller", name, "type", successType}).increment();
            return (T)result;
        }
        catch (Exception e) {
            String exception = e.getClass().getSimpleName();
            this.registry.counter(execName + ".failure", new String[]{"controller", name, "exception", exception}).increment();
            throw e;
        }
    }

    public void incrementControllerRetriesNumber() {
        this.registry.counter("operator.sdk.retry.on.exception", new String[]{"retry", "retryCounter", "type", "retryException"}).increment();
    }

    public void incrementProcessedEventsNumber() {
        this.registry.counter("operator.sdk.total.events.received", new String[]{"events", "totalEvents", "type", "eventsReceived"}).increment();
    }

    public <T extends Map<?, ?>> T monitorSizeOf(T map, String name) {
        return (T)this.registry.gaugeMapSize(PREFIX + name + ".size", Collections.emptyList(), map);
    }

    public DefaultEventHandler.EventMonitor getEventMonitor() {
        return this.monitor;
    }
}

